package com.tydic.dyc.oc.components.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderRspBo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocPasteCancelApplySaleOrderTransaction
 * 说明:
 * 时间:2023/8/29 11:24
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocPasteCancelApplySaleOrderTransaction {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Value("${uoc.dealPasteCancelApply.cancelApplyStatusAgr:XS_LYZ}")
    private String cancelApplyStatusAgr;

    @Value("${uoc.dealPasteCancelApply.cancelApplyStatusEs:XS_FH_DFH}")
    private String cancelApplyStatusEs;

    @Value("${uoc.dealPasteCancelApply.cancelApplyStatusNoAgr:XS_FH_DFH}")
    private String cancelApplyStatusNoAgr;


    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocPasteCancelApplySaleOrderRspBo dealPasteCancelApply(UocPasteCancelApplySaleOrderReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //删除取消申请变更单
        this.deleteCancelApplyChangeOrder(reqBo);
        //更新销售单信息
        this.updateSaleOrder(reqBo);

        UocPasteCancelApplySaleOrderRspBo rspBo = new UocPasteCancelApplySaleOrderRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    /**
     * 更新销售单信息
     *
     * @param reqBo
     */
    private void updateSaleOrder(UocPasteCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderQryBo qrySale = new UocSaleOrderQryBo();
        qrySale.setOrderId(reqBo.getOrderId());
        qrySale.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(qrySale);
        if (ObjectUtil.isEmpty(uocSaleOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "该销售单单不存在：" + reqBo.getSaleOrderId());
        }

        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());

        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
            updateSaleOrderDo.setSaleOrderState(cancelApplyStatusAgr);
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        } else if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource())) {
            updateSaleOrderDo.setSaleOrderState(cancelApplyStatusEs);
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        } else if (UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(uocSaleOrderDo.getOrderSource())) {
            updateSaleOrderDo.setSaleOrderState(cancelApplyStatusNoAgr);
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        }

    }

    /**
     * 取消申请变更单删除
     *
     * @param reqBo
     */
    private void deleteCancelApplyChangeOrder(UocPasteCancelApplySaleOrderReqBo reqBo) {
        UocChngOrderDo deleteChngOrderDo = new UocChngOrderDo();
        if (null == reqBo.getChngOrderId()) {
            UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
            uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
            uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
            uocChngOrderQryBo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_QXSQZ);
//            UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
            uocChngOrderQryBo.setOrderBy("create_time");
            //此处会包含多条数据，取最新的一条来撤回
            List<UocChngOrderDo> listChngOrder = iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
            if (ObjectUtil.isEmpty(listChngOrder)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "该销售单单[" + reqBo.getSaleOrderId() + "]不存在变更单");
            }
            reqBo.setChngOrderId(listChngOrder.get(0).getChngOrderId());
        }
        deleteChngOrderDo.setOrderId(reqBo.getOrderId());
        deleteChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YCX);
        deleteChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
        deleteChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        deleteChngOrderDo.setUpdateTime(new Date());
        deleteChngOrderDo.setUpdateOperName(reqBo.getName());
//        deleteChngOrderDo.setDelTag(1);
        this.iUocChngOrderModel.updateChngOrderMain(deleteChngOrderDo);
    }

    /**
     * 参数校验
     *
     * @param reqBo
     */
    private void verifyParam(UocPasteCancelApplySaleOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
//		if (null == reqBo.getChngOrderId()) {
//			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID不能为空");
//		}
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        if (StringUtils.isEmpty(reqBo.getName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
    }
}


