package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.components.transactionservice.UocCancelApplySaleOrderTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单取消申请提交实现〉
 * @author : yuhao
 * @date : 2022/7/29 16:55
 */
@HTServiceImpl
public class UocCancelApplySaleOrderServiceImpl implements UocCancelApplySaleOrderService {
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocCancelApplySaleOrderTransaction uocCancelApplySaleOrderTransaction;

    @Override
    public UocCancelApplySaleOrderRspBo cancelApplySaleOrder(UocCancelApplySaleOrderReqBo reqBo) {
        UocCancelApplySaleOrderRspBo rspBo = uocCancelApplySaleOrderTransaction.cancelApplySaleOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }

        return rspBo;
    }


    private void syncEs(UocCancelApplySaleOrderReqBo reqBo, UocCancelApplySaleOrderRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
        saleOrderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleOrderBo.setOrderId(reqBo.getOrderId());
        saleOrderBo.setObjId(reqBo.getSaleOrderId());
        saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleOrderBo);

        SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
        chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
        chngBo.setOrderId(reqBo.getOrderId());
        chngBo.setObjId(rspBo.getChngOrderId());
        chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(chngBo);

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}
