package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.components.transactionservice.UocCancelSaleOrderBatchConfirmOrRefuseTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-销售单取消申请同意/拒绝（批量）实现〉
 *
 * @author : yuhao
 * @date : 2022/8/2 14:40
 */
@HTServiceImpl
public class UocCancelSaleOrderBatchConfirmOrRefuseServiceImpl implements UocCancelSaleOrderBatchConfirmOrRefuseService {

    @Autowired
    private UocCancelSaleOrderBatchConfirmOrRefuseTransaction uocCancelSaleOrderBatchConfirmOrRefuseTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocCancelSaleOrderBatchConfirmOrRefuseRspBo cancelSaleOrderBatchConfirmOrRefuse(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo = uocCancelSaleOrderBatchConfirmOrRefuseTransaction.cancelSaleOrderBatchConfirmOrRefuse(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo, UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        for (String saleOrderStr : rspBo.getSaleOrderIdList()) {
            String[] split = saleOrderStr.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }

        for (String chngOrderStr : rspBo.getChngOrderIdList()) {
            String[] split = chngOrderStr.split("-");
            SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
            chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
            chngBo.setOrderId(Long.valueOf(split[1]));
            chngBo.setObjId(Long.valueOf(split[0]));
            chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(chngBo);
        }

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}
