package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.components.transactionservice.UocChngOrderConfirmOrRefuseForInspTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author WangJiuXin
 * @date 2023/6/20
 * @decr  新变更确认/拒绝（验收单维度）服务实现
 **/
@HTServiceImpl
public class UocChngOrderConfirmOrRefuseForInspServiceImpl implements UocChngOrderConfirmOrRefuseForInspService{

    @Autowired
    private UocChngOrderConfirmOrRefuseForInspTransaction uocChngOrderConfirmOrRefuseForInspTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;


    @Override
    public UocChngOrderConfirmOrRefuseForInspRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        UocChngOrderConfirmOrRefuseForInspRspBo rspBo = uocChngOrderConfirmOrRefuseForInspTransaction.dealConfirmOrRefuse(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }

        return rspBo;

    }

    private void syncEs(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        //同步变更单
        for (UocChngOrderConfirmOrRefuseReqItemBo uocChngOrderConfirmOrRefuseReqItemBo : reqBo.getChngOrderList()) {
            SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
            chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
            chngBo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            chngBo.setObjId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(chngBo);
        }

        //同步销售单
        List<String> saleOrderIdList = rspBo.getSaleOrderIdList();
        for (String saleOrderId : saleOrderIdList) {
            String[] split = saleOrderId.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }

        //同步验收单
        List<String> inspOrderIdList = rspBo.getInspOrderIdList();
        for (String inspOrderId : inspOrderIdList) {
            String[] split = inspOrderId.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(uocIndexConfig.getInspOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }


}
