/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderMapQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderWaybillQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderWaybill;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.UocGetAfOrderDetailService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderCommodityItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderReceiverAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderRefundDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderServiceInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderShipInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocGetAfOrderDetailService"})
public class UocGetAfOrderDetailServiceImpl
implements UocGetAfOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocGetAfOrderDetailServiceImpl.class);
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    private static final String TO_PAY_P_CODE = "TO_PAY";
    @Value(value="${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;

    @PostMapping(value={"qryAfOrderDetails"})
    public UocGetAfOrderDetailServiceRspBo qryAfOrderDetails(@RequestBody UocGetAfOrderDetailServiceReqBo reqBo) {
        UocGetAfOrderDetailServiceRspBo rspBo = UocRu.success(UocGetAfOrderDetailServiceRspBo.class);
        int source = UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT;
        this.validateParam(reqBo);
        UocAfOrder uocAfOrder = this.getAfOrderMain(reqBo, null);
        String dataAchiveTabSuffix = null;
        if (this.dataAchiveFlag.booleanValue() && Objects.isNull(uocAfOrder)) {
            dataAchiveTabSuffix = "_" + new SimpleDateFormat("yyyy").format((reqBo.getOrderId() >> 22) + 1420041600000L);
            uocAfOrder = this.getAfOrderMain(reqBo, dataAchiveTabSuffix);
        }
        if (ObjectUtil.isNull((Object)uocAfOrder)) {
            return rspBo;
        }
        List<UocSaleStakeholder> stakeHolderList = this.getStakeHolderList(new UocSaleOrderItem(), reqBo, false, dataAchiveTabSuffix);
        List<UocAfOrderItem> afOrderItemList = this.getAfOrderItemList(reqBo, dataAchiveTabSuffix);
        List<UocAfOrderWaybill> afOrderWayBillList = this.getAfOrderWayBillList(reqBo, dataAchiveTabSuffix);
        source = this.encapCommodityInfo(afOrderItemList, rspBo, reqBo, uocAfOrder, dataAchiveTabSuffix);
        this.encapServInfo(stakeHolderList, uocAfOrder, rspBo, reqBo, source, dataAchiveTabSuffix);
        this.encapRefundInfo(stakeHolderList, uocAfOrder, reqBo, rspBo, dataAchiveTabSuffix);
        this.encapShipInfo(rspBo, afOrderWayBillList);
        UocAfOrderMapQryBo qryAfMap = new UocAfOrderMapQryBo();
        qryAfMap.setOrderId(reqBo.getOrderId());
        qryAfMap.setAfOrderId(reqBo.getAfOrderId());
        qryAfMap.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocAfOrderMap> afOrderMapList = this.iUocAfOrderModel.getAfOrderMapList(qryAfMap);
        if (ObjectUtil.isNotEmpty(afOrderMapList)) {
            rspBo.setExtFields(new ArrayList());
            for (UocAfOrderMap uocAfOrderMap : afOrderMapList) {
                BaseExtendFieldBo extRspBo = (BaseExtendFieldBo)JUtil.js((Object)uocAfOrderMap, BaseExtendFieldBo.class);
                rspBo.getExtFields().add(extRspBo);
            }
        }
        return rspBo;
    }

    private void encapShipInfo(UocGetAfOrderDetailServiceRspBo rspBo, List<UocAfOrderWaybill> afOrderWayBillList) {
        UocAfOrderShipInfoBo shipInfo = new UocAfOrderShipInfoBo();
        if (ObjectUtil.isNotEmpty(afOrderWayBillList)) {
            UocAfOrderWaybill waybill = afOrderWayBillList.get(0);
            shipInfo = UocRu.js(waybill, UocAfOrderShipInfoBo.class);
            shipInfo.setFreightMoney(BigDecimal.valueOf(waybill.getFreight()));
            UocSysDictionaryQryBo qryCodeBo = new UocSysDictionaryQryBo();
            qryCodeBo.setPCode(TO_PAY_P_CODE);
            qryCodeBo.setCode(shipInfo.getToPay().toString());
            UocSysDictionaryDo dic = this.iUocSysDictionaryModel.getModelBy(qryCodeBo);
            shipInfo.setToPayStr(dic.getDescrip());
        }
        rspBo.setShipInfo(shipInfo);
    }

    private List<UocAfOrderWaybill> getAfOrderWayBillList(UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo = new UocAfOrderWaybillQryBo();
        uocAfOrderWaybillQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderWaybillQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocAfOrderModel.getAfOrderWayBillList(uocAfOrderWaybillQryBo);
    }

    private void encapRefundInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceReqBo reqBo, UocGetAfOrderDetailServiceRspBo rspBo, String dataAchiveTabSuffix) {
        UocAfOrderRefundDetailBo refundDetailBo = new UocAfOrderRefundDetailBo();
        List<UocPayOrder> listPayOrder = this.getUocPayOrderDoList(reqBo, dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            refundDetailBo = UocRu.js(listPayOrder.get(0), UocAfOrderRefundDetailBo.class);
            if (ObjectUtil.isNotEmpty(stakeHolderList)) {
                refundDetailBo.setPurAccount(stakeHolderList.get(0).getPurAccount());
                refundDetailBo.setPurAccountName(stakeHolderList.get(0).getPurAccountName());
            }
            rspBo.getServInfo().setIsPayFlag(Boolean.valueOf(true));
        }
        refundDetailBo.setRealReturnFee(uocAfOrder.getRealReturnFee());
        refundDetailBo.setPayFee(uocAfOrder.getRetTotalSaleFee());
        this.translateRefundInfo(refundDetailBo);
        rspBo.setRefundInfo(refundDetailBo);
    }

    private void translateRefundInfo(UocAfOrderRefundDetailBo refundDetailBo) {
        if (null != refundDetailBo.getInterType()) {
            refundDetailBo.setInterTypeStr(this.getDic().get("UOC_SALE_ORDER_SOURCE").get(refundDetailBo.getInterType().toString()));
        }
        Optional.ofNullable(refundDetailBo.getPayState()).ifPresent(x -> refundDetailBo.setPayStateStr(this.getDic().get("PAY_AFTER_STATE").get(x)));
        if (null != refundDetailBo.getPayType()) {
            refundDetailBo.setPayTypeStr(this.getDic().get("UOC_SALE_ORDER_PAY_TYPE").get(refundDetailBo.getPayType().toString()));
        }
    }

    private List<UocPayOrder> getUocPayOrderDoList(UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocPayOrderQryBo uocPayOrderQryBo = new UocPayOrderQryBo();
        uocPayOrderQryBo.setOrderId(reqBo.getOrderId());
        uocPayOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocPayOrder> listPayOrder = this.iUocPayOrderModel.getListPayOrder(uocPayOrderQryBo);
        return listPayOrder;
    }

    private void encapServInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo, Integer source, String dataAchiveTabSuffix) {
        UocAfOrderServiceInfoBo servInfoBo = UocRu.js(uocAfOrder, UocAfOrderServiceInfoBo.class);
        servInfoBo.setClientName(uocAfOrder.getExtField2());
        servInfoBo.setClientPhone(uocAfOrder.getExtField3());
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder stakeholder = stakeHolderList.get(0);
            servInfoBo.setSupplierId(stakeholder.getSupId());
            servInfoBo.setSupplierName(stakeholder.getSupName());
            servInfoBo.setPurName(stakeholder.getPurName());
            servInfoBo.setPurUserId(stakeholder.getPurUserId());
            servInfoBo.setPurOrgId(stakeholder.getPurOrgId());
        }
        this.encapReceiverAddressInfo(uocAfOrder, servInfoBo, dataAchiveTabSuffix);
        this.encapOutOrderInfo(uocAfOrder, servInfoBo, source, dataAchiveTabSuffix);
        this.encapAccessoryInfo(reqBo, servInfoBo, dataAchiveTabSuffix);
        this.translateServInfo(servInfoBo);
        this.buildTaskInfo(servInfoBo, uocAfOrder, dataAchiveTabSuffix);
        rspBo.setServInfo(servInfoBo);
    }

    private void buildTaskInfo(UocAfOrderServiceInfoBo servInfoBo, UocAfOrder uocAfOrder, String dataAchiveTabSuffix) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(uocAfOrder.getOrderId());
        uocOrderTaskInst.setObjId(uocAfOrder.getAfOrderId());
        uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderTaskInst.setFinishTag(0);
        uocOrderTaskInst.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (CollectionUtil.isNotEmpty(uocOrderTaskInsts)) {
            UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
            servInfoBo.setTaskId(uocOrderTaskInst1.getTaskInstId());
            servInfoBo.setStepId(uocOrderTaskInst1.getProcState());
        }
    }

    private void encapOutOrderInfo(UocAfOrder uocAfOrder, UocAfOrderServiceInfoBo servInfoBo, Integer source, String dataAchiveTabSuffix) {
        if (null != source && UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(source)) {
            List<UocOrderQueryIndex> orderQueryIndexList = this.getOrderQueryIndexList(uocAfOrder, dataAchiveTabSuffix);
            List<UocDMsgPoolQryBo> dMsgList = this.getDMsgList(uocAfOrder, dataAchiveTabSuffix);
            if (ObjectUtil.isNotEmpty(orderQueryIndexList)) {
                servInfoBo.setOutOrderId(orderQueryIndexList.get(0).getOutObjId());
            }
            if (ObjectUtil.isNotEmpty(dMsgList)) {
                servInfoBo.setOrderType(dMsgList.get(0).getOrderType());
            }
        }
    }

    private void translateServInfo(UocAfOrderServiceInfoBo servInfoBo) {
        if (null != servInfoBo.getServType()) {
            servInfoBo.setServTypeStr(this.getDic().get("UOC_ORD_SERVICE_TYPE").get(servInfoBo.getServType().toString()));
        }
        if (null != servInfoBo.getServState()) {
            servInfoBo.setServStateStr(this.getDic().get("UOC_ORD_SERVICE_STATE").get(servInfoBo.getServState().toString()));
        }
        servInfoBo.setPayTypeStr(this.getDic().get("UOC_SALE_ORDER_PAY_TYPE").get(servInfoBo.getPayType()));
        if (null != servInfoBo.getAfsReason()) {
            servInfoBo.setAfsReasonStr(this.getDic().get("AFS_REASON").get(servInfoBo.getAfsReason().toString()));
        }
        if (null != servInfoBo.getOrderType()) {
            servInfoBo.setOrderTypeStr(this.getDic().get("VENDOR_ORDER_TYPE").get(servInfoBo.getOrderType().toString()));
        }
        if (null != servInfoBo.getPickwareType()) {
            servInfoBo.setPickwareTypeStr(this.getDic().get("UOC_ORD_PICKWARE_SERVE_TYPE").get(servInfoBo.getPickwareType().toString()));
        }
    }

    private void encapAccessoryInfo(UocGetAfOrderDetailServiceReqBo reqBo, UocAfOrderServiceInfoBo servInfoBo, String dataAchiveTabSuffix) {
        ArrayList<UocBaseOrderAccessoryTypeDetailBo> accessoryInfo = new ArrayList<UocBaseOrderAccessoryTypeDetailBo>();
        UocOrderAccessoryQryBo qryBo = new UocOrderAccessoryQryBo();
        qryBo.setObjId(reqBo.getAfOrderId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderAccessory> orderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(qryBo);
        if (ObjectUtil.isNotEmpty(orderAccessoryList)) {
            ConcurrentMap<Integer, List<UocOrderAccessory>> uocOrderAccessoryMap = orderAccessoryList.stream().collect(Collectors.groupingByConcurrent(UocOrderAccessory::getAttachmentType));
            Iterator iterator = uocOrderAccessoryMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer key = (Integer)iterator.next();
                accessoryTypeDetailBo.setAttachmentType(key);
                accessoryTypeDetailBo.setAttchList(UocRu.jsl((List)uocOrderAccessoryMap.get(key), UocBaseOrderAccessoryDetailBo.class));
                accessoryInfo.add(accessoryTypeDetailBo);
            }
        }
        servInfoBo.setAccessoryInfo(accessoryInfo);
    }

    private void encapReceiverAddressInfo(UocAfOrder uocAfOrder, UocAfOrderServiceInfoBo servInfoBo, String dataAchiveTabSuffix) {
        UocOrdLogisticsRelaQryBo qryBo = new UocOrdLogisticsRelaQryBo();
        qryBo.setOrderId(uocAfOrder.getOrderId());
        qryBo.setContactId(uocAfOrder.getTpContactId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(qryBo);
        if (ObjectUtil.isNotNull((Object)uocOrdLogisticsRela)) {
            servInfoBo.setOrderTakeDeliveryInfo(UocRu.js(uocOrdLogisticsRela, UocAfOrderReceiverAddressBo.class));
        }
        UocOrdLogisticsRelaQryBo qryBo1 = new UocOrdLogisticsRelaQryBo();
        qryBo1.setOrderId(uocAfOrder.getOrderId());
        qryBo1.setContactId(uocAfOrder.getContactId());
        qryBo1.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela getAddress = this.iUocOrderModel.qryOrderLogisticsRela(qryBo1);
        if (ObjectUtil.isNotNull((Object)getAddress)) {
            servInfoBo.setOrderTakeReceiveInfo(UocRu.js(getAddress, UocAfOrderReceiverAddressBo.class));
        }
        UocOrdLogisticsRelaQryBo qryBo2 = new UocOrdLogisticsRelaQryBo();
        qryBo2.setOrderId(uocAfOrder.getOrderId());
        qryBo2.setContactId(uocAfOrder.getJhContactId());
        qryBo2.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela getAddress2 = this.iUocOrderModel.qryOrderLogisticsRela(qryBo2);
        if (ObjectUtil.isNotNull((Object)getAddress2)) {
            servInfoBo.setEsReceiveInfo(UocRu.js(getAddress2, UocAfOrderReceiverAddressBo.class));
        }
    }

    private Integer encapCommodityInfo(List<UocAfOrderItem> afOrderItemList, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo, UocAfOrder uocAfOrder, String dataAchiveTabSuffix) {
        ArrayList<UocAfOrderCommodityItemBo> commodityInfo = new ArrayList<UocAfOrderCommodityItemBo>();
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItem(uocAfOrder, dataAchiveTabSuffix);
        Map<Long, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSaleOrderItemId));
        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            for (int i = 0; i < afOrderItemList.size(); ++i) {
                UocAfOrderItem each = afOrderItemList.get(i);
                BigDecimal returnCount = each.getReturnCount();
                UocAfOrderCommodityItemBo commodityItemBo = new UocAfOrderCommodityItemBo();
                BeanUtils.copyProperties((Object)each, (Object)commodityItemBo);
                this.encapSaleOrderItemInfo(each, commodityItemBo, reqBo, i, dataAchiveTabSuffix);
                this.encapShipOrderItemInfo(each, commodityItemBo, dataAchiveTabSuffix);
                this.dealCommodityData(commodityItemBo);
                this.translateCommodityInfo(commodityItemBo);
                List<UocSaleOrderItem> uocSaleOrderItems = saleOrderItemMap.get(each.getSaleItemId());
                UocSaleOrderItem saleOrderItem = uocSaleOrderItems.get(0);
                if (saleOrderItem != null) {
                    commodityItemBo.setUnitDigit(saleOrderItem.getUnitDigit());
                }
                commodityItemBo.setReturnCount(returnCount);
                commodityInfo.add(commodityItemBo);
            }
            log.info("commodityInfo\uff1a" + JSON.toJSONString(commodityInfo));
        }
        rspBo.setCommodityInfo(commodityInfo);
        return reqBo.getOrderSource();
    }

    private void dealCommodityData(UocAfOrderCommodityItemBo commodityItemBo) {
        if (null != commodityItemBo.getSendCount() && null != commodityItemBo.getAfterServingCount() && null != commodityItemBo.getAlreadyReturnCount()) {
            commodityItemBo.setAvailableAfterServCount(commodityItemBo.getSendCount().subtract(commodityItemBo.getAfterServingCount()).subtract(commodityItemBo.getAlreadyReturnCount()).abs());
        }
        if (null == commodityItemBo.getRetSaleFee()) {
            commodityItemBo.setRetSaleFee(BigDecimal.ZERO);
        }
        if (null == commodityItemBo.getRetPurchaseFee()) {
            commodityItemBo.setRetPurchaseFee(BigDecimal.ZERO);
        }
    }

    private void translateCommodityInfo(UocAfOrderCommodityItemBo commodityItemBo) {
        commodityItemBo.setShipOrderStateStr(this.getDic().get("SHIP_ORDER_STATE").get(commodityItemBo.getShipOrderState()));
        if (null != commodityItemBo.getSkuSource()) {
            commodityItemBo.setSkuSourceStr(this.getDic().get("UOC_SALE_ORDER_SOURCE").get(commodityItemBo.getSkuSource().toString()));
        }
    }

    private void encapInspOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, String dataAchiveTabSuffix) {
        List<UocInspOrderItem> inspOrderItemList = this.getInspOrderItemList(item, dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(inspOrderItemList)) {
            UocInspOrderItem uocInspOrderItem = inspOrderItemList.get(0);
            BeanUtils.copyProperties((Object)uocInspOrderItem, (Object)commodityItemBo);
        } else {
            commodityItemBo.setAlreadyReturnCount(BigDecimal.ZERO);
        }
    }

    private List<UocSaleOrderItem> getSaleOrderItem(UocAfOrder afOrderMain, String dataAchiveTabSuffix) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(afOrderMain.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(afOrderMain.getOrderId());
        uocSaleOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private List<UocInspOrderItem> getInspOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        UocInspOrderItemQryBo qryBo = new UocInspOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setInspOrderItemId(reqBo.getInspItemId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocInspOrderModel.getListInspOrderItem(qryBo).getUocInspOrderItemList();
    }

    private List<UocDMsgPoolQryBo> getDMsgList(UocAfOrder reqBo, String dataAchiveTabSuffix) {
        UocDMsgPoolQryBo dMsgPoolQryBo = new UocDMsgPoolQryBo();
        dMsgPoolQryBo.setOrderId(reqBo.getOrderId());
        dMsgPoolQryBo.setObjId(reqBo.getAfOrderId());
        dMsgPoolQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        dMsgPoolQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocOrderModel.getMsgList(dMsgPoolQryBo);
    }

    private List<UocSaleItemMap> getSaleOrderItemMapList(UocAfOrder uocAfOrder, String dataAchiveTabSuffix) {
        UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
        uocSaleItemMapQryBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        uocSaleItemMapQryBo.setOrderId(uocAfOrder.getOrderId());
        uocSaleItemMapQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    private List<UocOrderQueryIndex> getOrderQueryIndexList(UocAfOrder reqBo, String dataAchiveTabSuffix) {
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjId(reqBo.getAfOrderId());
        queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        queryIndexQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
    }

    private void encapShipOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, String dataAchiveTabSuffix) {
        List<UocShipOrderItem> shipOrderItemList = this.getShipOrderItemList(item, dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemList.get(0);
            BeanUtils.copyProperties((Object)uocShipOrderItem, (Object)commodityItemBo);
            commodityItemBo.setAlreadyReturnCount(uocShipOrderItem.getReturnCount());
            UocShipOrderDo uocShipOrderDo = this.encapShipOrderMainInfo(commodityItemBo, uocShipOrderItem, dataAchiveTabSuffix);
            commodityItemBo.setShipCompanyNo(uocShipOrderDo.getShipCompanyNo());
            if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
                BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
                commodityItemBo.setAvailableAfterServCount(afterCountEnable);
            }
        }
    }

    private UocShipOrderDo encapShipOrderMainInfo(UocAfOrderCommodityItemBo commodityItemBo, UocShipOrderItem uocShipOrderItem, String dataAchiveTabSuffix) {
        UocShipOrderDo shipOrderDo = this.getShipOrderDo(uocShipOrderItem, dataAchiveTabSuffix);
        if (ObjectUtil.isNotNull((Object)shipOrderDo)) {
            BeanUtils.copyProperties((Object)shipOrderDo, (Object)commodityItemBo);
        }
        return shipOrderDo;
    }

    private void encapSaleOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, UocGetAfOrderDetailServiceReqBo reqBo, int index, String dataAchiveTabSuffix) {
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(item, dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            UocSaleOrderItem saleOrderItem = saleOrderItemList.get(0);
            if (index == 0) {
                reqBo.setOrderSource(saleOrderItem.getSkuSource());
            }
            BeanUtils.copyProperties((Object)((Object)saleOrderItem), (Object)commodityItemBo);
            this.encapStakeHolderInfo(commodityItemBo, saleOrderItem, reqBo, dataAchiveTabSuffix);
        }
    }

    private void encapOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, String dataAchiveTabSuffix) {
        List<UocOrderItem> orderItemList = this.getOrderItemList(item, dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(orderItemList)) {
            UocOrderItem uocOrderItem = orderItemList.get(0);
            BeanUtils.copyProperties((Object)((Object)uocOrderItem), (Object)commodityItemBo);
        }
    }

    private List<UocOrderItem> getOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        UocOrderItemQryBo qryBo = new UocOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocOrderModel.qryOrderItemList(qryBo);
    }

    private void encapStakeHolderInfo(UocAfOrderCommodityItemBo commodityItemBo, UocSaleOrderItem saleOrderItem, UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        List<UocSaleStakeholder> stakeHolderList = this.getStakeHolderList(saleOrderItem, reqBo, true, dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder uocSaleStakeholder = stakeHolderList.get(0);
            BeanUtils.copyProperties((Object)uocSaleStakeholder, (Object)commodityItemBo);
        }
    }

    private List<UocSaleStakeholder> getStakeHolderList(UocSaleOrderItem item, UocGetAfOrderDetailServiceReqBo reqBo, Boolean isSaleItem, String dataAchiveTabSuffix) {
        UocSaleStakeholderQryBo qryBo = new UocSaleStakeholderQryBo();
        if (isSaleItem.booleanValue()) {
            qryBo.setOrderId(item.getOrderId());
        } else {
            qryBo.setOrderId(reqBo.getOrderId());
        }
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocSaleOrderModel.qrySaleOrderStakeholder(qryBo);
    }

    private UocShipOrderDo getShipOrderDo(UocShipOrderItem reqBo, String dataAchiveTabSuffix) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        uocShipOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private List<UocShipOrderItem> getShipOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(reqBo.getShipItemId());
        uocShipOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo).getShipOrderItemBoList();
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        UocSaleOrderItemQryBo qryBo = new UocSaleOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderItemId(reqBo.getSaleItemId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocSaleOrderModel.getSaleOrderItemList(qryBo);
    }

    private UocAfOrder getAfOrderMain(UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    private List<UocAfOrderItem> getAfOrderItemList(UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    private void validateParam(UocGetAfOrderDetailServiceReqBo reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAfOrderId() == null) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORD_SERVICE_STATE");
        pCodes.add("UOC_ORD_SERVICE_TYPE");
        pCodes.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodes.add("AFS_REASON");
        pCodes.add("UOC_SALE_ORDER_SOURCE");
        pCodes.add("SHIP_ORDER_STATE");
        pCodes.add("VENDOR_ORDER_TYPE");
        pCodes.add("UOC_ORD_PICKWARE_SERVE_TYPE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

