package com.tydic.dyc.oc.components.thread;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.concurrent.*;

/**
 * 标题:UocThreadPool
 * 说明:
 * 时间:2023/8/21 18:13
 * 作者:田桂银
 */
@Component
public class UocThreadPool {

    private ThreadPoolExecutor executor = null;

    // 核心线程数
    @Value("${uoc.thread.corePoolSize:4}")
    int corePoolSize;

    // 最大线程数
    @Value("${uoc.thread.maximumPoolSize:50}")
    int maximumPoolSize;

    // 线程空闲时间
    @Value("${uoc.thread.keepAliveTime:60}")
    long keepAliveTime;

    /**
     * 等待队列数量
     */
    @Value("${uoc.thread.blockingCapacity:100}")
    private int blockingCapacity;

    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    @PostConstruct
    public void initThreadPoolExecutor() {
        // 等待任务的队列
        BlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<>(blockingCapacity);

        // 自定义线程工厂
        ThreadFactory threadFactory = Executors.defaultThreadFactory();

        // 自定义拒绝策略
        RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
        executor = new ThreadPoolExecutor(
                corePoolSize,
                maximumPoolSize,
                keepAliveTime,
                TimeUnit.SECONDS,
                workQueue,
                threadFactory,
                rejectedExecutionHandler
        );
    }


    public ThreadPoolExecutor getExecutor() {
        return executor;
    }

    /**
     * 描述:对外部传入Runnable对象，进行属性注入，并执行线程
     *
     * @param runnable 入参
     * @return void
     * @author tgy
     * @date 2023/8/21 18:40
     */
    public void executeRunnable(Runnable runnable) {
        beanFactory.autowireBean(runnable);
        executor.execute(runnable);
    }

}


