/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.service.bargaining.UocUpdateBargainingOrderedService;
import com.tydic.dyc.oc.service.bargaining.bo.UocUpdateBargainingOrderedReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocUpdateBargainingOrderedRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocUpdateBargainingOrderedService"})
public class UocUpdateBargainingOrderedServiceImpl
implements UocUpdateBargainingOrderedService {
    private static final Logger log = LoggerFactory.getLogger(UocUpdateBargainingOrderedServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"updateBargaining"})
    public UocUpdateBargainingOrderedRspBo updateBargaining(@RequestBody UocUpdateBargainingOrderedReqBo reqBo) {
        this.verifyParam(reqBo);
        this.verifyState(reqBo);
        this.updateBargainingState(reqBo);
        this.insertProgressRecord(reqBo);
        return UocRu.success(UocUpdateBargainingOrderedRspBo.class);
    }

    private void verifyState(UocUpdateBargainingOrderedReqBo reqBO) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        UocBargainingDo bargainingDo = this.uocBargainingModel.qryBargainingBy(uocBargainingDo);
        if (!"YJ_YBJ".equals(bargainingDo.getBargainingState())) {
            throw new BaseBusinessException("102001", "\u53ea\u80fd\u5bf9\u5df2\u62a5\u4ef7\u7684\u8bae\u4ef7\u5355\u4e0b\u5355\uff01");
        }
    }

    private void verifyParam(UocUpdateBargainingOrderedReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBargainingId()) {
            throw new BaseBusinessException("102001", "\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateBargainingState(UocUpdateBargainingOrderedReqBo reqBO) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setUpdateTime(new Date());
        uocBargainingDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setUpdateOperName(reqBO.getName());
        uocBargainingDo.setBargainingState("YJ_YXD");
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.updateBargaining(uocBargainingDo);
    }

    private void insertProgressRecord(UocUpdateBargainingOrderedReqBo reqBO) {
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.ORDER);
        recordDo.setOperTypeName("\u4e0b\u5355\u6210\u529f");
        recordDo.setOperId((long)reqBO.getUserId());
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        recordDo.setOrderId(reqBO.getOrderId());
        this.uocBargainingModel.insertProgressRecord(recordDo);
    }
}

