/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.domainservice.UocCreateApprovalOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateApprovalOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateApprovalOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCreateApprovalOrderService"})
public class UocCreateApprovalOrderServiceImpl
implements UocCreateApprovalOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateApprovalOrderServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private UocCommonRepository uocCommonRepository;

    @PostMapping(value={"createApprovalOrder"})
    public UocCreateApprovalOrderServiceRspBo createApprovalOrder(@RequestBody UocCreateApprovalOrderServiceReqBo reqBo) {
        UocCreateApprovalOrderServiceRspBo rspBo = UocRu.success(UocCreateApprovalOrderServiceRspBo.class);
        this.validateParm(reqBo);
        List<UocSaleOrderDo> saleOrderDoList = this.getUocSaleOrderDos(reqBo);
        this.checkSaleOrderState(rspBo, saleOrderDoList);
        log.info("\u5ba1\u6279\u4e2d\u9500\u552e\u8ba2\u5355\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(saleOrderDoList));
        ArrayList noRelevantSaleOrderList = new ArrayList();
        List<List<UocSaleOrderDo>> list = this.calculcateData(saleOrderDoList);
        log.info("\u521b\u5efa\u6570\u636e\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(list));
        ArrayList<Long> approvalOrderIdList = new ArrayList<Long>();
        for (List<UocSaleOrderDo> saleOrderDos : list) {
            long auditId = IdUtil.nextId();
            UocAuditOrderDo auditDo = new UocAuditOrderDo();
            auditDo.setOrderId(reqBo.getOrderId());
            auditDo.setAuditOrderId(auditId);
            auditDo.setAuditOrderStatus("0");
            auditDo.setAuditOrderCode(this.genRequestCode());
            auditDo.setCreateTime(new Date());
            auditDo.setCreateOperId(reqBo.getUserId());
            auditDo.setCreateOperName(reqBo.getUserName());
            ArrayList<UocApprovalObj> objList = new ArrayList<UocApprovalObj>();
            auditDo.setApprovalObjs(objList);
            ArrayList<UocApprovalLog> uocApprovalLogList = new ArrayList<UocApprovalLog>();
            auditDo.setUocApprovalLogList(uocApprovalLogList);
            for (UocSaleOrderDo uocSaleOrderDo : saleOrderDos) {
                UocApprovalObj approvalObj = new UocApprovalObj();
                approvalObj.setObjId(uocSaleOrderDo.getSaleOrderId().toString());
                approvalObj.setId(IdUtil.nextId());
                approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
                approvalObj.setOrderId(reqBo.getOrderId());
                approvalObj.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                approvalObj.setObjBusiType(UocDicConstant.OBJ_TYPE.SALE);
                objList.add(approvalObj);
                UocApprovalLog uocApprovalLog = new UocApprovalLog();
                uocApprovalLog.setAuditOrderId(auditId);
                uocApprovalLog.setId(IdUtil.nextId());
                uocApprovalLog.setCreateTime(new Date());
                uocApprovalLog.setObjNum(objList.size());
                uocApprovalLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocApprovalLog.setAuditResult(UocConstant.AUDIT_TYPE.CREATE);
                uocApprovalLogList.add(uocApprovalLog);
            }
            this.iUocAuditOrderModel.saveAudit(auditDo);
            approvalOrderIdList.add(auditId);
        }
        rspBo.setApprovalOrderIdList(approvalOrderIdList);
        return rspBo;
    }

    private String genRequestCode() {
        return this.uocCommonRepository.getOrderNoSingle("AUTID_ORDER_NO");
    }

    private List<List<UocSaleOrderDo>> calculcateData(List<UocSaleOrderDo> saleOrderDoList) {
        ArrayList<UocSaleOrderDo> relevantSaleOrderList = new ArrayList<UocSaleOrderDo>();
        ArrayList<UocSaleOrderDo> noRelevantSaleOrderList = new ArrayList<UocSaleOrderDo>();
        List auditingSaleOrderList = saleOrderDoList.stream().filter(e -> "XS_SP_SPZ".equals(e.getSaleOrderState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(auditingSaleOrderList)) {
            throw new ZTBusinessException("\u8be5\u8ba2\u5355\u4e0b\u6ca1\u6709\u5bf9\u5e94\u7684\u201c\u5ba1\u6279\u4e2d\u201d\u72b6\u6001\u7684\u9500\u552e\u5355,\u6682\u4e0d\u521b\u5efa\u5ba1\u6279\u5355");
        }
        log.info("\u5f85\u751f\u6210\u5ba1\u6279\u5f97\u8ba2\u5355\u5217\u8868:{}", (Object)JSON.toJSONString(auditingSaleOrderList));
        for (UocSaleOrderDo saleOrderDo : auditingSaleOrderList) {
            UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
            uocSaleOrderMapQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
            List<UocSaleOrderMap> uocSaleOrderMapList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
            log.info("\u8ba2\u5355\u6269\u5c55\u5217\u8868:{}", (Object)JSON.toJSONString(uocSaleOrderMapList));
            Iterator<UocSaleOrderMap> iterator = uocSaleOrderMapList.iterator();
            boolean releFalg = false;
            while (iterator.hasNext()) {
                UocSaleOrderMap uocSaleOrderMap = iterator.next();
                if (!"relevantDeptId".equals(uocSaleOrderMap.getFieldCode())) continue;
                releFalg = true;
                ArrayList<BaseExtendFieldBo> extFields = new ArrayList<BaseExtendFieldBo>();
                BaseExtendFieldBo extendFieldBo = new BaseExtendFieldBo();
                extendFieldBo.setFieldCode(uocSaleOrderMap.getFieldCode());
                extendFieldBo.setFieldValue(uocSaleOrderMap.getFieldValue());
                extFields.add(extendFieldBo);
                saleOrderDo.setExtFields(extFields);
            }
            if (releFalg) {
                relevantSaleOrderList.add(saleOrderDo);
                continue;
            }
            noRelevantSaleOrderList.add(saleOrderDo);
        }
        log.info("\u6ca1\u6709\u5f52\u53e3\u90e8\u95e8\u7684\u9500\u552e\u5355\u5217\u8868:{}", (Object)JSON.toJSONString(noRelevantSaleOrderList));
        log.info("\u6709\u5f52\u53e3\u90e8\u95e8\u7684\u9500\u552e\u5355\u5217\u8868:{}", (Object)JSON.toJSONString(relevantSaleOrderList));
        ArrayList<List<UocSaleOrderDo>> list = new ArrayList<List<UocSaleOrderDo>>();
        if (ObjectUtil.isNotEmpty(noRelevantSaleOrderList)) {
            list.add(noRelevantSaleOrderList);
        }
        Map<String, List<UocSaleOrderDo>> saleOrderListMap = relevantSaleOrderList.stream().collect(Collectors.groupingBy(e -> ((BaseExtendFieldBo)e.getExtFields().get(0)).getFieldCode()));
        for (Map.Entry<String, List<UocSaleOrderDo>> entry : saleOrderListMap.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    private List<UocSaleOrderDo> getUocSaleOrderDos(UocCreateApprovalOrderServiceReqBo reqBo) {
        UocSaleOrderDo qryDo = new UocSaleOrderDo();
        qryDo.setOrderId(reqBo.getOrderId());
        qryDo.setOrderSource(reqBo.getOrderSource());
        List<UocSaleOrderDo> saleOrderDoList = this.iUocSaleOrderModel.qrySaleOrderList(qryDo);
        return saleOrderDoList;
    }

    private void checkSaleOrderState(UocCreateApprovalOrderServiceRspBo rspBo, List<UocSaleOrderDo> saleOrderDoList) {
        boolean allCancelOrAuditing = true;
        for (UocSaleOrderDo uocSaleOrderDo : saleOrderDoList) {
            if ("XS_SP_SPZ".equals(uocSaleOrderDo.getSaleOrderState()) || "XS_QX_QX".equals(uocSaleOrderDo.getSaleOrderState())) continue;
            allCancelOrAuditing = false;
        }
        if (!allCancelOrAuditing) {
            throw new ZTBusinessException("\u8be5\u8ba2\u5355(orderId)\u4e0b\u6709\u72b6\u6001\u4e0d\u662f\u201d\u5ba1\u6279\u4e2d\u201c\u6216\u201c\u5df2\u53d6\u6d88\u201d\u7684\u9500\u552e\u8ba2\u5355");
        }
    }

    private void validateParm(UocCreateApprovalOrderServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("\u9500\u552e\u8ba2\u5355id\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderSource())) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u3010orderSource\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

