/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocCancelSaleOrderBatchConfirmOrRefuseTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocCancelSaleOrderBatchConfirmOrRefuseTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Value(value="${uoc.cancelSaleOrderConfirmOrRefuse.refuseAgrStatus:XS_LYZ}")
    private String refuseAgrStatus;
    @Value(value="${uoc.cancelSaleOrderConfirmOrRefuse.refuseEsStatus:XS_FH_DFH}")
    private String refuseEsStatus;
    @Value(value="${uoc.cancelSaleOrderConfirmOrRefuse.refuseNoAgrStatus:XS_FH_DFH}")
    private String refuseNoAgrStatus;
    @Value(value="${uoc.cancelSaleOrderBatchConfirmOrRefuse.runTask:false}")
    private boolean runTask;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocCancelSaleOrderBatchConfirmOrRefuseRspBo cancelSaleOrderBatchConfirmOrRefuse(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        this.verifyParam(reqBo);
        this.batchUpdateCancelApplyChangeOrderInfo(reqBo);
        this.batchUpdateSaleOrderInfo(reqBo);
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult()) && this.runTask) {
            this.batchSubmitTask(reqBo);
        }
        UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo = new UocCancelSaleOrderBatchConfirmOrRefuseRspBo();
        this.buildSyncRsp(reqBo, rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void batchSubmitTask(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        for (UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo : reqBo.getCancelApplyChangeOrderInfos()) {
            if (!ObjectUtil.isNotEmpty((Object)uocCancelSaleOrderInfoBo.getTaskId())) continue;
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            task.setTaskId(uocCancelSaleOrderInfoBo.getTaskId());
            taskInfos.add(task);
            uocCommonDo.setCompleteTaskInfos(taskInfos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
    }

    private void buildSyncRsp(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo, UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo) {
        List saleOrderIdList = reqBo.getCancelApplyChangeOrderInfos().stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList());
        List chngOrderIdList = reqBo.getCancelApplyChangeOrderInfos().stream().map(x -> x.getChngOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList());
        rspBo.setSaleOrderIdList(saleOrderIdList);
        rspBo.setChngOrderIdList(chngOrderIdList);
    }

    private void batchUpdateSaleOrderInfo(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        for (UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo : reqBo.getCancelApplyChangeOrderInfos()) {
            UocSaleOrderQryBo qrySale = new UocSaleOrderQryBo();
            qrySale.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            qrySale.setSaleOrderId(uocCancelSaleOrderInfoBo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(qrySale);
            if (ObjectUtil.isEmpty((Object)((Object)uocSaleOrderDo))) {
                throw new BaseBusinessException("100001", "\u8be5\u9500\u552e\u5355\u5355\u4e0d\u5b58\u5728\uff1a" + uocCancelSaleOrderInfoBo.getSaleOrderId());
            }
            UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
            updateSaleOrderDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            updateSaleOrderDo.setSaleOrderId(uocCancelSaleOrderInfoBo.getSaleOrderId());
            updateSaleOrderDo.setCancelReplyContent(reqBo.getCancelReplyContent());
            updateSaleOrderDo.setCancelReplyTime(new Date());
            updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            updateSaleOrderDo.setUpdateOperName(reqBo.getName());
            updateSaleOrderDo.setUpdateTime(new Date());
            updateSaleOrderDo.setCancelTime(new Date());
            if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
                updateSaleOrderDo.setSaleOrderState("XS_QX_QX");
            } else if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
                updateSaleOrderDo.setSaleOrderState(this.refuseAgrStatus);
            } else if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource())) {
                updateSaleOrderDo.setSaleOrderState(this.refuseEsStatus);
            } else if (UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(uocSaleOrderDo.getOrderSource())) {
                updateSaleOrderDo.setSaleOrderState(this.refuseNoAgrStatus);
            }
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        }
    }

    private void batchUpdateCancelApplyChangeOrderInfo(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        for (UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo : reqBo.getCancelApplyChangeOrderInfos()) {
            UocChngOrderDo updateChngOrderDo = new UocChngOrderDo();
            updateChngOrderDo.setChngOrderId(uocCancelSaleOrderInfoBo.getChngOrderId());
            updateChngOrderDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
                updateChngOrderDo.setChngOrderState("CHNG_XS_YQR");
            } else {
                updateChngOrderDo.setChngOrderState("CHNG_XS_YJJ");
            }
            updateChngOrderDo.setRejectReason(reqBo.getCancelReplyContent());
            updateChngOrderDo.setRejectTime(new Date());
            updateChngOrderDo.setUpdateOperName(reqBo.getName());
            updateChngOrderDo.setUpdateTime(new Date());
            updateChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.iUocChngOrderModel.updateChngOrderMain(updateChngOrderDo);
        }
    }

    private void verifyParam(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getConfirmResult()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCancelApplyChangeOrderInfos())) {
            throw new BaseBusinessException("100001", "\u53d6\u6d88\u7533\u8bf7\u53d8\u66f4\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

