/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.event.EventConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class EventConsumerManger {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerManger.class);
    private final Map<String, EventConsumer> eventMap = new ConcurrentHashMap<String, EventConsumer>();

    public EventConsumer getEventConsumer(String eventName) {
        EventConsumer intRet = this.eventMap.get(eventName);
        if (intRet == null) {
            throw new BaseBusinessException("8888", "\u4e8b\u4ef6\u7f16\u7801\u5b9e\u73b0\u7c7b(" + eventName + ")\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
        }
        return intRet;
    }

    public void register(EventConsumer consumer) {
        Assert.notNull((Object)consumer, (String)"consumer\u4e0d\u80fd\u4e3a\u7a7a");
        String event = consumer.getEvent();
        Assert.notNull((Object)event, (String)"consumer\u7684event\u4e0d\u80fd\u4e3a\u7a7a");
        EventConsumer intRet = this.eventMap.get(event);
        if (intRet != null) {
            throw new BaseBusinessException("8888", "\u4e8b\u4ef6\u7f16\u7801\u5b9e\u73b0\u7c7b(" + event + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info(EventConsumerManger.class.getSimpleName() + ".register\u6ce8\u518c\u4e86\u4e8b\u4ef6\u7f16\u7801\u5b9e\u73b0\u7c7b\uff1a" + event);
        this.eventMap.put(event, consumer);
    }
}

