package com.tydic.dyc.oc.model.shiporder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderItemQryBo
 * 说明:发货明细
 * 时间:2022-02-21 19:12
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocShipOrderItemQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  3128157420380223256L;

	//发货明细id")
	private Long shipOrderItemId;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//执行明细id")
	private Long implOrderItemId;

	//销售明细id")
	private Long saleOrderItemId;


	//发货单id")
	private Long shipOrderId;

	//明细状态")
	private String shipItemState;

	//计量单位")
	private String unitName;

	//发货数量")
	private BigDecimal sendCount;

	//到货数量             供应商到货登记时预留字段")
	private BigDecimal arriveCount;

	//拒收数量")
	private BigDecimal refuseCount;

	//退货数量")
	private BigDecimal returnCount;

	//验收数量")
	private BigDecimal inspCount;

	//异常变更在途数量，表示异常供应商确认之前的记录数量")
	private BigDecimal chngingCount;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

	//扩展字段")
	private String extField4;

    //扩展字段")
    private String extField5;

	//排序")
	private String orderBy;

	//发货单IDList")
	private List<Long> shipOrderIdList;

	//发货明细idList")
	private List<Long> shipOrderItemIdList;

	//订单IDList")
	private List<Long> orderIdList;

	//销售单明细IDList")
	private List<Long> saleOrderItemIdList;

}
