/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderBatchConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.transactionservice.UocCancelSaleOrderBatchConfirmOrRefuseTransaction;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderBatchConfirmOrRefuseService"})
public class UocCancelSaleOrderBatchConfirmOrRefuseServiceImpl
implements UocCancelSaleOrderBatchConfirmOrRefuseService {
    @Autowired
    private UocCancelSaleOrderBatchConfirmOrRefuseTransaction uocCancelSaleOrderBatchConfirmOrRefuseTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"cancelSaleOrderBatchConfirmOrRefuse"})
    public UocCancelSaleOrderBatchConfirmOrRefuseRspBo cancelSaleOrderBatchConfirmOrRefuse(@RequestBody UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo = this.uocCancelSaleOrderBatchConfirmOrRefuseTransaction.cancelSaleOrderBatchConfirmOrRefuse(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo, UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo) {
        String[] split;
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        for (String saleOrderStr : rspBo.getSaleOrderIdList()) {
            split = saleOrderStr.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }
        for (String chngOrderStr : rspBo.getChngOrderIdList()) {
            split = chngOrderStr.split("-");
            SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
            chngBo.setIndexName(this.uocIndexConfig.getChngOrderIndex());
            chngBo.setOrderId(Long.valueOf(split[1]));
            chngBo.setObjId(Long.valueOf(split[0]));
            chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(chngBo);
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

