/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocPasteCancelApplySaleOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderRspBo;
import com.tydic.dyc.oc.transactionservice.UocPasteCancelApplySaleOrderTransaction;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocPasteCancelApplySaleOrderService"})
public class UocPasteCancelApplySaleOrderServiceImpl
implements UocPasteCancelApplySaleOrderService {
    @Autowired
    private UocPasteCancelApplySaleOrderTransaction uocPasteCancelApplySaleOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealPasteCancelApply"})
    public UocPasteCancelApplySaleOrderRspBo dealPasteCancelApply(@RequestBody UocPasteCancelApplySaleOrderReqBo reqBo) {
        UocPasteCancelApplySaleOrderRspBo rspBo = this.uocPasteCancelApplySaleOrderTransaction.dealPasteCancelApply(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocPasteCancelApplySaleOrderReqBo reqBo, UocPasteCancelApplySaleOrderRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
        saleOrderBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleOrderBo.setOrderId(reqBo.getOrderId());
        saleOrderBo.setObjId(reqBo.getSaleOrderId());
        saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleOrderBo);
        SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
        chngBo.setIndexName(this.uocIndexConfig.getChngOrderIndex());
        chngBo.setOrderId(reqBo.getOrderId());
        chngBo.setObjId(reqBo.getChngOrderId());
        chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(chngBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

