package com.tydic.dyc.oc.repository;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.*;

import java.util.List;

/**
 * 标题:UocBargainingRepository
 * 说明:议价单
 * 时间:2023/7/26 15:51
 * 作者:Dum
 */
public interface UocBargainingRepository {
    /**
     * 查询议价单列表
     *
     * @param uocBargainingQryBo
     * @return
     */
    List<UocBargaining> qryListBargaining(UocBargainingQryBo uocBargainingQryBo);
    /**
     * 申请议价单
     *
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 申请议价单
     *
     * @param uocBargainingParentDo
     * @return
     */
    UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo);
    /**
     * 查询，同步议价单
     *
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo);
    /**
     * 更新议价单
     *
     * @param uocBargainingDo
     * @return
     */
    void updateBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 查询，查询商品最新报价列表
     *
     * @param uocBargainingItemQryBo
     * @return
     */
    List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo);
    /**
     * 查询 商品列表（运营商维度）
     *
     * @param uocBargainingItemQryBo
     * @return
     */
    BasePageRspBo<UocBargainingItem> qryListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo  参数对象
     * @return List<UocBargainingProgressRecordPO> 结果对象
     */
    List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo);


    /**
     * 根据条件查询单条数据
     *
     * @param reqBo  参数对象
     * @return UocBargainingAddressBo 结果对象
     */
    UocBargainingAddressBo getModelBy(UocBargaining reqBo);


    List<UocQryQuotationBo> qryListBargainingQuotatio(UocQryQuotationListServiceReqBo reqBo);

    /**
     * 分页查询:议价单报价明细
     * @param reqBo
     * @return
     */
    UocBargainingItemPageRspBo qryBargainingItemPage(UocBargainingItemPageReqBo reqBo);


    /**
     * 议价单报价创建
     * @param uocBargainingQuotationDo
     * @return
     */
    UocBargainingQuotationDo createQuotation(UocBargainingQuotationDo uocBargainingQuotationDo);
    /**
     * 报价单更新
     * @param uocBargainingQuotationDo
     * @return
     */
    void updateQuotation(UocBargainingQuotationDo uocBargainingQuotationDo);
    /**
     * 报价明细更新
     * @param uocBargainingQuotationDo
     * @return
     */
    int updateQuotationItem(UocBargainingQuotationDo uocBargainingQuotationDo);
    /**
    * 报价查询
    * @param uocBargainingQuotationBo
    * @return
    */
    UocBargainingQuotationBo getQuotationBy(UocBargainingQuotationBo uocBargainingQuotationBo);
    /**
     * 插入记录
     * @param uocBargainingProgressRecordDo
     * @return
     */
    void insertProgressRecord(UocBargainingProgressRecordDo uocBargainingProgressRecordDo);
    /**
     * 报价完成后，更新议价单明细-报价价格
     * @param uocBargainingDo
     * @return
     **/
    int updateBargainingItemConfirmedPrice(UocBargainingDo uocBargainingDo);
    /**
     * 报价完成后，按状态、允许下单日期查询
     * @param uocBargainingQryBo
     * @return
     **/
    List<UocBargaining> qryExpireBargainingList(UocBargainingQryBo uocBargainingQryBo);

}
