/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderItemQryBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspDetailBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemFormatBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemFormatChildBo;
import com.tydic.dyc.oc.service.domainservice.UocGetCmpOrderDetailBySaleOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCmpOrderDetailBySaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCmpOrderDetailServiceBySaleOrderRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocGetCmpOrderDetailBySaleOrderService"})
public class UocQryCmpOrderDetailBySaleOrderServiceImpl
implements UocGetCmpOrderDetailBySaleOrderService {
    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    @Autowired
    private IUocSaleOrderModel uocSaleOrderModel;

    @PostMapping(value={"qryCmpOrderDetail"})
    public UocGetCmpOrderDetailServiceBySaleOrderRspBo qryCmpOrderDetail(@RequestBody UocGetCmpOrderDetailBySaleOrderServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocGetCmpOrderDetailServiceBySaleOrderRspBo rspBo = UocRu.success(UocGetCmpOrderDetailServiceBySaleOrderRspBo.class);
        ArrayList<UocGetCmpOrderDetailServiceRspDetailBo> cmpOrderDetailinfoList = new ArrayList<UocGetCmpOrderDetailServiceRspDetailBo>();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.uocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        List cmpOrderNoList = saleOrderItems.stream().map(UocSaleOrderItem::getCmpOrderNo).collect(Collectors.toList());
        for (String cmpOrderNo : cmpOrderNoList) {
            UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
            uocCmpOrderQryBo.setCmpOrderNo(cmpOrderNo);
            UocCmpOrderQryBo cmpOrderDetail = this.uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
            if (!ObjectUtil.isNotEmpty((Object)cmpOrderDetail)) continue;
            UocGetCmpOrderDetailServiceRspDetailBo cmpOrderBo = UocRu.js(cmpOrderDetail, UocGetCmpOrderDetailServiceRspDetailBo.class);
            List<UocCmpOrderItemQryBo> uocCmpOrderItemList = cmpOrderDetail.getUocCmpOrderItemList();
            for (UocCmpOrderItemQryBo each : uocCmpOrderItemList) {
                each.setVendorId(each.getGoodsSupplierId());
            }
            if (CollectionUtil.isNotEmpty(uocCmpOrderItemList)) {
                cmpOrderBo.setUocCmpOrderItemList(UocRu.jsl(uocCmpOrderItemList, UocGetCmpOrderDetailServiceRspItemBo.class));
                cmpOrderBo.setSkuMainPicUrl(uocCmpOrderItemList.get(0).getImgUrl());
                cmpOrderBo.setUocCmpOrderItemFormatList(new ArrayList());
                ConcurrentMap<String, List<UocCmpOrderItemQryBo>> cmpOrderItemsMap = uocCmpOrderItemList.stream().collect(Collectors.groupingByConcurrent(UocCmpOrderItemQryBo::getSpuId));
                for (String key : cmpOrderItemsMap.keySet()) {
                    UocGetCmpOrderDetailServiceRspItemFormatBo formatBo = new UocGetCmpOrderDetailServiceRspItemFormatBo();
                    formatBo.setCmpOrderNo(cmpOrderBo.getCmpOrderNo());
                    formatBo.setImgUrl(((UocCmpOrderItemQryBo)((List)cmpOrderItemsMap.get(key)).get(0)).getImgUrl());
                    formatBo.setRemark(((UocCmpOrderItemQryBo)((List)cmpOrderItemsMap.get(key)).get(0)).getRemark());
                    formatBo.setUocCmpItemFormatChildList(UocRu.jsl((List)cmpOrderItemsMap.get(key), UocGetCmpOrderDetailServiceRspItemFormatChildBo.class));
                    cmpOrderBo.getUocCmpOrderItemFormatList().add(formatBo);
                }
            }
            cmpOrderDetailinfoList.add(cmpOrderBo);
        }
        rspBo.setCmpOrderDetailinfoList(cmpOrderDetailinfoList);
        return rspBo;
    }

    private void validateArg(UocGetCmpOrderDetailBySaleOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocGetCmpOrderDetailBySaleOrderServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

