/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.service.bargaining.UocUpdateBiddingResultService;
import com.tydic.dyc.oc.service.bargaining.bo.UocUpdateBiddingResultReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocUpdateBiddingResultRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocUpdateBiddingResultService"})
public class UocUpdateBiddingResultServiceImpl
implements UocUpdateBiddingResultService {
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"updateBiddingResult"})
    public UocUpdateBiddingResultRspBo updateBiddingResult(@RequestBody UocUpdateBiddingResultReqBo reqBo) {
        this.verifyParam(reqBo);
        this.verifyState(reqBo);
        this.updateQuotationState(reqBo);
        this.insertProgressRecord(reqBo);
        return UocRu.success(UocUpdateBiddingResultRspBo.class);
    }

    private void verifyState(UocUpdateBiddingResultReqBo reqBO) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        UocBargainingDo bargainingDo = this.uocBargainingModel.qryBargainingBy(uocBargainingDo);
        if (!"YJ_YBJ".equals(bargainingDo.getBargainingState())) {
            throw new BaseBusinessException("102001", "\u53ea\u80fd\u5bf9\u5df2\u62a5\u4ef7\u7684\u8bae\u4ef7\u5355\u53d1\u8d77\u4e2d\u6807\u64cd\u4f5c\uff01");
        }
    }

    private void verifyParam(UocUpdateBiddingResultReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBargainingId()) {
            throw new BaseBusinessException("102001", "\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getQuotationId()) {
            throw new BaseBusinessException("102001", "\u62a5\u4ef7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateQuotationState(UocUpdateBiddingResultReqBo reqBO) {
        UocBargainingQuotationDo quotationDo = new UocBargainingQuotationDo();
        quotationDo.setBargainingId(reqBO.getBargainingId());
        quotationDo.setQuotationId(reqBO.getQuotationId());
        quotationDo.setQuotationReason("\u91c7\u8d2d\u5546\u624b\u52a8\u4e2d\u6807");
        quotationDo.setQuotationStatus("4");
        quotationDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.updateQuotation(quotationDo);
    }

    private void insertProgressRecord(UocUpdateBiddingResultReqBo reqBO) {
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.ORDER);
        recordDo.setOperTypeName("\u4e2d\u6807\u62a5\u4ef7");
        recordDo.setOperId((long)reqBO.getUserId());
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        recordDo.setRemark("\u4e2d\u6807ID\uff1a" + reqBO.getQuotationId());
        this.uocBargainingModel.insertProgressRecord(recordDo);
    }
}

