package com.tydic.dyc.oc.components.thread.runnable;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.constants.UocConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocSyncEsRunnable
 * 说明:订单es同步Runnable对象
 * 时间:2023/8/26 10:14
 * 作者:田桂银
 */
@Slf4j
public class UocSyncEsRunnable implements Runnable {

    @Autowired
    private UocEsSyncManager uocEsSyncManager;

    @Override
    public void run() {
        //校验入参
        String errorStr = validateArgList(syncEsRunnableBoList);
        if (ObjectUtil.isNotEmpty(errorStr)) {
            log.error(errorStr);
            return;
        }
        for (SyncEsRunnableBo syncEsRunnableBo : syncEsRunnableBoList) {
            try {
                Integer opFlag = syncEsRunnableBo.getOpFlag();
                if (UocConstant.ES_SYNC_OP_FLAG.SAVE.equals(opFlag)) {
                    uocEsSyncManager.saveData(convertToSyncManagerBo(syncEsRunnableBo));
                } else if (UocConstant.ES_SYNC_OP_FLAG.UPDATE.equals(opFlag)) {
                    uocEsSyncManager.updateData(convertToSyncManagerBo(syncEsRunnableBo));
                } else if (UocConstant.ES_SYNC_OP_FLAG.DELETE.equals(opFlag)) {
                    uocEsSyncManager.deleteData(convertToSyncManagerBo(syncEsRunnableBo));
                } else {
                    log.info("同步es线程：无对应操作类型【" + opFlag + "】");
                }
            } catch (Exception e) {
                log.error("Es同步数据保存参数失败：{}", e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String validateArgList(List<SyncEsRunnableBo> syncEsRunnableBoList) {
        String errorStr = null;
        if (ObjectUtil.isEmpty(syncEsRunnableBoList)) {
            errorStr = "多线程同步es失败：入参list为空";
        }
        for (SyncEsRunnableBo syncEsRunnableBo : syncEsRunnableBoList) {
            if (ObjectUtil.isEmpty(syncEsRunnableBo.getObjId())) {
                errorStr = "多线程同步es失败：入参list为空";
            }
            if (ObjectUtil.isEmpty(syncEsRunnableBo.getOrderId())) {
                errorStr = "多线程同步es失败：入参list为空";
            }
            if (ObjectUtil.isEmpty(syncEsRunnableBo.getIndexName())) {
                errorStr = "多线程同步es失败：入参list为空";
            }
            if (ObjectUtil.isEmpty(syncEsRunnableBo.getOpFlag())) {
                errorStr = "多线程同步es失败：入参list为空";
            }
        }
        return errorStr;
    }


    private UocEsSyncManagerSaveDataReqBo convertToSyncManagerBo(SyncEsRunnableBo syncEsRunnableBo) {
        UocEsSyncManagerSaveDataReqBo saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        saveDataReqBo.setOrderId(syncEsRunnableBo.getOrderId());
        saveDataReqBo.setObjId(syncEsRunnableBo.getObjId());
        saveDataReqBo.setJsonObj(syncEsRunnableBo.getJsonObj());
        saveDataReqBo.setIndexName(syncEsRunnableBo.getIndexName());
        return saveDataReqBo;
    }

    private List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

    public UocSyncEsRunnable(SyncEsRunnableBo syncEsRunnableBo) {
        this.syncEsRunnableBoList.add(syncEsRunnableBo);
    }

    public UocSyncEsRunnable(List<SyncEsRunnableBo> syncEsRunnableBoList) {
        this.syncEsRunnableBoList = syncEsRunnableBoList;
    }
}


