package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerCommonSyncSale
 * 说明:解释销售单通用
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
@Slf4j
public class EventConsumerCommonSyncSale implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerCommonSyncSale->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setObjId(saleOrderId);
        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        saleList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        eventReqBo.setDataList(saleList);
        retList.add(eventReqBo);
    
        UocApprovalObjQryBo qryBo = new UocApprovalObjQryBo();
    
        qryBo.setOrderId(orderId);
        qryBo.setObjId(String.valueOf(saleOrderId));
        List<UocApprovalObj> uocApprovalObjList =  iUocAuditOrderModel.qryApprovealObj(qryBo);
        
        if(ObjectUtil.isNotEmpty(uocApprovalObjList)){
            uocApprovalObjList.forEach(uocApprovalObj -> {
                Long auditOrderId = uocApprovalObj.getAuditOrderId();
                addSyncParam(retList, orderId, auditOrderId, uocIndexConfig.getApprovalOrderPlusIndex());
    
            });
        }
        log.info("同步销售单提交出参:{}", JSON.toJSONString(retList));
    
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ES_SYNC_SALE_ORDER;
    }
    
    private void addSyncParam(List<IUocEsSyncQryEventReqBo> retList, Long orderId, Long objId, String indexName) {
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setObjId(objId);
        syncQryReqBo.setOrderId(orderId);
        addEvent(retList, syncQryReqBo, indexName);
    }
    private void addEvent(List<IUocEsSyncQryEventReqBo> retList, IUocEsSyncQryReqBo syncQryReqBo, String index) {
        List<IUocEsSyncQryReqBo> esSyncQryReqBoList = new ArrayList<>();
        esSyncQryReqBoList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(index);
        eventReqBo.setDataList(esSyncQryReqBoList);
        retList.add(eventReqBo);
    }
}


