package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateForInspReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqInspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqInspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:IUocEsSyncImplShip
 * 说明:验收单
 * 时间:2022/3/1 14:08
 * 作者:罗有
 */

@Slf4j
@Component
public class UocEsSyncInsp implements IUocEsSync {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

//    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    private static final String ES_INSP_ORDER_ITEM_KEY = "uocInspOrderItemList";
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    //放置验收来源
    @Value("${uoc.syncinsp.putInspSource:true}")
    private boolean putInspSource;

    @Override
    public String indexName() {
        return uocIndexConfig.getInspOrderIndex();
    }

    private static final String ES_INSP_ORDER_ACCESSORY_KEY = "inspAccessoryList";

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocInspOrderDo inspOrderMain = getInspOrderMain(reqBo);

        if (null == inspOrderMain) {
            return iUocEsSyncQryRspBo;
        }
        inspOrderMain.setCheckState(qryCheckState(reqBo,inspOrderMain));
        JSONObject inspOrderJson = JSON.parseObject(JSON.toJSONString(inspOrderMain));
        try {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.TOTAL_SALE_FEE_LONG, UocMoneyUtil.bigDecimal2Long(inspOrderMain.getTotalSaleFee()));
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.TOTAL_PURCHASE_FEE_LONG, UocMoneyUtil.bigDecimal2Long(inspOrderMain.getTotalPurchaseFee()));
        } catch (Exception e) {
            log.debug("金额转换错误！");
        }
        if (!CollectionUtils.isEmpty(inspOrderMain.getExtParallelBoList())) {
            inspOrderMain.getExtParallelBoList().forEach(uocInspOrderMap -> inspOrderJson.put(uocInspOrderMap.getFieldCode(), uocInspOrderMap.getFieldValue()));
        }
        UocInspOrderDo inspOderItem = getInspOderItem(inspOrderMain);
        if (!CollectionUtils.isEmpty(inspOderItem.getUocInspOrderItemList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = getSaleItem(inspOrderMain);
            Map<Long, UocShipOrderItem> shipOrderItemMap = getListShipOrderItem(inspOderItem);

            JSONArray inspOrdeItemArray = new JSONArray();
            BigDecimal inspSaleMoney = BigDecimal.ZERO;
            BigDecimal inspPurchaseMoney = BigDecimal.ZERO;
            for (UocInspOrderItem uocInspOrderItem : inspOderItem.getUocInspOrderItemList()) {
                JSONObject inspOrderItemJson = JSON.parseObject(JSON.toJSONString(uocInspOrderItem));
                if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                    uocInspOrderItem.getItemExtParallelBoList().forEach(uocInspItemMap -> inspOrderItemJson.put(uocInspItemMap.getFieldCode(), uocInspItemMap.getFieldValue()));
                }
                UocSaleOrderItem uocSaleOrderItem = saleItemMap.get(uocInspOrderItem.getSaleOrderItemId());
                putSaleItem(inspOrderItemJson, uocSaleOrderItem);
                if (null != uocSaleOrderItem && null != uocSaleOrderItem.getSalePrice() && null != uocSaleOrderItem.getPurchaseCount()) {
                    BigDecimal inspPurFee = uocSaleOrderItem.getSalePrice().multiply(uocInspOrderItem.getInspCount());
                    inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.INSP_SALE_MONEY, inspPurFee);
                    inspSaleMoney = inspSaleMoney.add(inspPurFee);
                }
                if (null != uocSaleOrderItem && null != uocSaleOrderItem.getPurchasePrice() && null != uocSaleOrderItem.getPurchaseCount()) {
                    BigDecimal inspSalFee = uocSaleOrderItem.getPurchasePrice().multiply(uocInspOrderItem.getInspCount());
                    inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.INSP_PUR_MONEY, inspSalFee);
                    inspPurchaseMoney = inspPurchaseMoney.add(inspSalFee);
                }

                putShipItem(inspOrderItemJson, shipOrderItemMap.get(uocInspOrderItem.getShipOrderItemId()));
                inspOrdeItemArray.add(inspOrderItemJson);
            }
            inspOrderJson.put(ES_INSP_ORDER_ITEM_KEY, inspOrdeItemArray);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_SALE_MONEY, inspSaleMoney);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_PUR_MONEY, inspPurchaseMoney);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_ACCESSORY, inspOrderMain.getUocOrderAccessoryList());
        }

        //查询验收单附件列表，并放入验收单es中
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        accessoryQryBo.setObjId(inspOrderMain.getInspOrderId());
        List<UocOrderAccessory> accessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            inspOrderJson.put(ES_INSP_ORDER_ACCESSORY_KEY, JSONArray.parseArray(JSON.toJSONString(accessoryList)));
        }

        Map<String, Map<String, String>> dicMap = getDic();
        UocSaleOrderDo saleOrder = getSaleOrder(inspOrderMain);
        UocOrderDo uocOrderDo = getUocOrderDo(inspOrderMain);
        putSaleOrder(inspOrderMain, inspOrderJson, saleOrder, dicMap);
        putOrder(inspOrderJson, uocOrderDo, dicMap);
        putShipOrder(inspOrderMain, inspOrderJson);
        putOrderRel(reqBo, inspOrderJson, saleOrder, dicMap);
        putOrderShouldPay(reqBo, inspOrderJson);
        putStr(inspOrderJson, inspOrderMain, dicMap);
        putInvoice(inspOrderJson, reqBo);
        putChngFlag(inspOrderJson, reqBo);
        putReceiverAddressBo(inspOrderJson, uocOrderDo);
        iUocEsSyncQryRspBo.setJsonObj(inspOrderJson);
        return iUocEsSyncQryRspBo;
    }

    /**
     * 同步收货人地址
     *
     * @param inspOrderJson
     * @param uocOrderDo
     */
    private void putReceiverAddressBo(JSONObject inspOrderJson, UocOrderDo uocOrderDo) {
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(uocOrderDo.getOrderId());
        relaQryBo.setContactId(uocOrderDo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.RECEIVER_ADDRESS_BO, uocOrdLogisticsRela);
    }

    /**
     * 判断是否有未完成的变更单
     *
     * @param inspOrderJson
     * @param reqBo
     */
    private void putChngFlag(JSONObject inspOrderJson, IUocEsSyncQryReqBo reqBo) {
//        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
//        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
//        uocChngOrderQryBo.setBusiTypeList(Arrays.asList(UocConstant.BUSI_TYPE.STATE, UocConstant.BUSI_TYPE.NUM));
//        uocChngOrderQryBo.setChngOrderState(UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QRZ);
//        List<UocChngOrderDo> chngOrderList = iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
//        if (CollectionUtils.isEmpty(chngOrderList)) {
//            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_CHNG_FLAG, "false");
//        } else {
//            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_CHNG_FLAG, "true");
//        }

        String flag = "false";
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderItemQryBo.setInspOrderId(reqBo.getObjId());
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(uocInspOrderDo)) {
            if (ObjectUtil.isNotEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
                for (UocInspOrderItem uocInspOrderItem : uocInspOrderDo.getUocInspOrderItemList()) {
                    if (uocInspOrderItem.getChngingCount().compareTo(BigDecimal.ZERO) > 0) {
                        flag = "true";
                        break;
                    }
                }
            }
        }

        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_CHNG_FLAG, flag);
    }

    private void putInvoice(JSONObject inspOrderJson, IUocEsSyncQryReqBo reqBo) {
        UocOrdInvoiceQryBo uocOrdInvoiceQryBo = new UocOrdInvoiceQryBo();
        uocOrdInvoiceQryBo.setOrderId(reqBo.getOrderId());
        UocOrdInvoice uocOrdInvoice = iUocOrderModel.qryOrderInvoice(uocOrdInvoiceQryBo);
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INVOICE, uocOrdInvoice);
        if (null != uocOrdInvoice) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.BUYER_NAME, uocOrdInvoice.getBuyerName());
        }
    }

    private void putOrderShouldPay(IUocEsSyncQryReqBo reqBo, JSONObject inspOrderJson) {
        List<UocOrderShouldPay> orderShouldPayList = getOrderShouldPayList(reqBo);
        if (ObjectUtil.isNotEmpty(orderShouldPayList)) {
            UocOrderShouldPay shouldPay = orderShouldPayList.get(0);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAYEE_ID, shouldPay.getPayeeId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAYEE_NAME, shouldPay.getPayeeName());
        }
    }

    private void putSaleOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_ID, inspOrderMain.getInspOrderId().toString());
        if (null != saleOrder) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_STATE, saleOrder.getPayState());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORD_SOURCE, saleOrder.getOrderSource().toString());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_OPER_ID, saleOrder.getCreateOperId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_OPER_NAME, saleOrder.getCreateOperName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_LOGIN_NAME, saleOrder.getStakeholder().getPurUserName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_TIME, saleOrder.getCreateTime());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_NO, saleOrder.getSaleOrderNo());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_NO_EXT, saleOrder.getSaleOrderNoExt());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE, saleOrder.getModelSettle());

            //查询业务流程实例
            IUocEsSyncQryReqBo iUocEsSyncQryReqBo = new IUocEsSyncQryReqBo();
            iUocEsSyncQryReqBo.setOrderId(saleOrder.getOrderId());
            iUocEsSyncQryReqBo.setObjId(saleOrder.getSaleOrderId());
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = getProcInst(iUocEsSyncQryReqBo, false, UocDicConstant.OBJ_TYPE.SALE);

            UocGetSaleOrderDetailServiceRspPorcBo auditProcInst;
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrder.getOrderSource())) {
                auditProcInst = getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.ORDER);
            } else {
                auditProcInst = getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.SALE);
            }

            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, busiProcInst.getProcInstId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE, saleOrder.getSaleOrderState());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, auditProcInst.getProcInstId());
            if (null != saleOrder.getOrderSource()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORD_SOURCE_STR, dicMap.get(UocDicConstant.ORDER_SOURCE.P_CODE).get(saleOrder.getOrderSource().toString()));
            }
            if (null != saleOrder.getModelSettle()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE_STR, dicMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(saleOrder.getModelSettle().toString()));
            }
            if (StringUtils.isNotBlank(saleOrder.getPayType())) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE_STR, dicMap.get(UocDicConstant.UOC_INSP_ORDER_PAY_TYPE.P_CODE).get(saleOrder.getPayType()));
            }
            if (null != saleOrder.getPayState()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_STATE_STR, dicMap.get(UocDicConstant.PAY_STATE.P_CODE).get(saleOrder.getPayState().toString()));
            }
            if (null != saleOrder.getSaleOrderState()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, dicMap.get(UocDicConstant.UOC_PRO_CNNG_ORDER_STATUS.P_CODE).get(saleOrder.getSaleOrderState().toString()));
            }

            List<UocSaleOrderMap> saleOrderMapList = getSaleOrderMapList(saleOrder);
            if (null != saleOrderMapList) {
                saleOrderMapList.forEach(each -> inspOrderJson.put(each.getFieldCode(), each.getFieldValue()));
            }
            if (putInspSource) {
                //放置验收来源
                if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
                    Map<String, String> saleExtMap = saleOrderMapList.stream().collect(Collectors.toMap(item -> item.getFieldCode(), item -> item.getFieldValue()));
                    String itAgrOrderCode = saleExtMap.get("itAgrOrderCode");
                    //是it协议类订单
                    if ("1".equals(itAgrOrderCode)) {
                        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ACCEPT_SOURCE, "1");
                        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ACCEPT_SOURCE_STR, "IT工作台");
                    } else {
                        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ACCEPT_SOURCE, "0");
                        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ACCEPT_SOURCE_STR, "商城");
                    }
                } else {
                    inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ACCEPT_SOURCE, "0");
                    inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ACCEPT_SOURCE_STR, "商城");
                }
            }

            putSaleStakeholder(saleOrder, inspOrderJson);
            putOrderAgreement(inspOrderJson, saleOrder, dicMap);
            putSalePayConf(inspOrderJson, saleOrder, dicMap);
        }
    }

    private void putOrder(JSONObject inspOrderJson, UocOrderDo orderDo, Map<String, Map<String, String>> dicMap) {
        if (StringUtils.isNotEmpty(orderDo.getUserType()) && Objects.nonNull(dicMap.get(UocDicConstant.ORDER_CREATE_USE_TYPE.P_CODE))) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_USER_TYPE, orderDo.getUserType());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_USER_TYPE_STR, dicMap.get(UocDicConstant.ORDER_CREATE_USE_TYPE.P_CODE).get(orderDo.getUserType()));
        }
    }

    private void putOrderAgreement(JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        List<UocOrderAgreement> agreementList = getOrderAgreement(saleOrder);
        if (ObjectUtil.isNotEmpty(agreementList)) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.TRADE_MODE, agreementList.get(0).getTradeMode());
            if (null != agreementList.get(0).getTradeMode()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.TRADE_MODE_STR, dicMap.get(UocDicConstant.TRADE_MODE.P_CODE).get(agreementList.get(0).getTradeMode().toString()));
            }
        }
    }

    private List<UocOrderAgreement> getOrderAgreement(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo agreementQryBo = new UocOrderAgreementQryBo();
        agreementQryBo.setOrderId(saleOrder.getOrderId());
        agreementQryBo.setId(saleOrder.getAgrDataId());
        return iUocSaleOrderModel.getAgreementOrderList(agreementQryBo);
    }

    /**
     * 查询销售单扩展
     */
    private List<UocSaleOrderMap> getSaleOrderMapList(UocSaleOrderDo reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getSaleOrderId());

        return iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    private void putSalePayConf(JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        List<UocSaleOrderPayConf> payConfList = getPayConfList(saleOrder);
        if (ObjectUtil.isNotEmpty(payConfList)) {

            for (UocSaleOrderPayConf uocSaleOrderPayConf : payConfList) {
                if (UocDicConstant.PAY_CONF_USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType())) {
                    putPayConfPurchase(inspOrderJson, dicMap, uocSaleOrderPayConf);
                }
                if (UocDicConstant.PAY_CONF_USE_TYPE.PRO.equals(uocSaleOrderPayConf.getUserType())) {
                    putPayConfPro(inspOrderJson, dicMap, uocSaleOrderPayConf);
                }
            }
        }
    }

    private void putPayConfPurchase(JSONObject inspOrderJson, Map<String, Map<String, String>> dicMap, UocSaleOrderPayConf payConf) {
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, payConf.getPayType());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_BREAK_SCALE, payConf.getPayBreakScale());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAYMENT_DAYS, payConf.getPaymentDays());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_RULE, payConf.getPayRule());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_ACCOUNT_DAY_RULE, payConf.getPayAccountDayRule());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_ACCOUNT_DAY, payConf.getPayAccountDay());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_NODE_RULE, payConf.getPayNodeRule());
        if (null != payConf.getPayRule()) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_RULE_STR, dicMap.get(UocDicConstant.PAY_RULE.P_CODE).get(payConf.getPayRule().toString()));
        }
        if (null != payConf.getPayAccountDayRule()) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_ACCOUNT_DAY_RULE_STR, dicMap.get(UocDicConstant.PAY_ACCOUNT_DAY_RULE.P_CODE).get(payConf.getPayAccountDayRule().toString()));
        }
        if (null != payConf.getPayNodeRule()) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_NODE_RULE_STR, dicMap.get(UocDicConstant.PAY_NODE_RULE.P_CODE).get(payConf.getPayNodeRule().toString()));
        }
    }

    private void putPayConfPro(JSONObject inspOrderJson, Map<String, Map<String, String>> dicMap, UocSaleOrderPayConf payConf) {
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_TYPE, payConf.getPayType());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_BREAK_SCALE, payConf.getPayBreakScale());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAYMENT_DAYS, payConf.getPaymentDays());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_RULE, payConf.getPayRule());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_ACCOUNT_DAY_RULE, payConf.getPayAccountDayRule());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_ACCOUNT_DAY, payConf.getPayAccountDay());
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_NODE_RULE, payConf.getPayNodeRule());
        if (null != payConf.getPayRule()) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_RULE_STR, dicMap.get(UocDicConstant.PAY_RULE.P_CODE).get(payConf.getPayRule().toString()));
        }
        if (null != payConf.getPayAccountDayRule()) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_ACCOUNT_DAY_RULE_STR, dicMap.get(UocDicConstant.PAY_ACCOUNT_DAY_RULE.P_CODE).get(payConf.getPayAccountDayRule().toString()));
        }
        if (null != payConf.getPayNodeRule()) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_PAY_NODE_RULE_STR, dicMap.get(UocDicConstant.PAY_NODE_RULE.P_CODE).get(payConf.getPayNodeRule().toString()));
        }
    }

    private List<UocSaleOrderPayConf> getPayConfList(UocSaleOrderDo saleOrder) {
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setSaleOrderId(saleOrder.getSaleOrderId());
        payConfQryBo.setOrderId(saleOrder.getOrderId());
        return iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
    }

    private List<UocOrderShouldPay> getOrderShouldPayList(IUocEsSyncQryReqBo reqBo) {
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setOrderId(reqBo.getOrderId());
        uocOrderShouldPay.setObjectId(reqBo.getObjId());
        uocOrderShouldPay.setObjectType(UocDicConstant.OBJ_TYPE.INSPECTION);
        return iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
    }

    private void putOrderRel(IUocEsSyncQryReqBo reqBo, JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        if (null != saleOrder) {
            List<UocOrderRel> relInfoList = getUocRelInfo(reqBo);
            if (UocConstant.ModelSettle.MY.equals(saleOrder.getModelSettle())) {
                if (CollectionUtils.isEmpty(relInfoList)) {
                    relInfoList = new ArrayList<>();
//                    addRelInfo(reqBo, relInfoList, UocDicConstant.REL_TYPE.CH_INVOICE);
                    addRelInfo(reqBo, relInfoList, UocDicConstant.REL_TYPE.COMMON_INVOICE);
                    addRelInfo(reqBo, relInfoList, UocDicConstant.REL_TYPE.UP_INVOICE);
                } else {
                    //if (relInfoList.size() == 1) {
                    //    Integer type = UocDicConstant.REL_TYPE.UP_INVOICE.equals(relInfoList.get(0).getRelType()) ? UocDicConstant.REL_TYPE.COMMON_INVOICE : UocDicConstant.REL_TYPE.UP_INVOICE;
                    //    addRelInfo(reqBo, relInfoList, type);
                    //}
                }
            }
            if (UocConstant.ModelSettle.CH.equals(saleOrder.getModelSettle())) {
                if (CollectionUtils.isEmpty(relInfoList)) {
                    relInfoList = new ArrayList<>();
                    addRelInfo(reqBo, relInfoList, UocDicConstant.REL_TYPE.CH_INVOICE);
                }
            }
            List<String> relId = new ArrayList<>();
            List<String> relInfo = new ArrayList<>();
            Map<String, String> statusMap = dicMap.get(UocDicConstant.REL_STATUS.P_CODE);
            for (UocOrderRel uocOrderRel : relInfoList) {
                if (null != uocOrderRel.getRelId()) {
                    relId.add(uocOrderRel.getRelId());
                }
                if (null != uocOrderRel.getRelStatus()) {
                    uocOrderRel.setRelStatusStr(statusMap.get(uocOrderRel.getRelStatus().toString()));
                }
                relInfo.add(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType());
            }
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_ID, relId);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.OBJ_ID, reqBo.getObjId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.OBJ_TYPE, UocDicConstant.OBJ_TYPE.INSPECTION);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, relInfoList.stream().map(UocOrderRel::getRelType).collect(Collectors.toList()));
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_INFO, relInfo);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.FSC_REL_INFO_BOS, relInfoList);
        }
    }

    private void addRelInfo(IUocEsSyncQryReqBo reqBo, List<UocOrderRel> relInfoList, Integer relType) {
        UocOrderRel uocOrderRel = new UocOrderRel();
        uocOrderRel.setOrderId(reqBo.getOrderId());
        uocOrderRel.setObjType(reqBo.getObjType());
        uocOrderRel.setRelType(relType);
        uocOrderRel.setObjId(reqBo.getObjId());
        uocOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        relInfoList.add(uocOrderRel);
    }

    private List<UocOrderRel> getUocRelInfo(IUocEsSyncQryReqBo reqBo) {
        UocOrderRelQryBo qryBo = new UocOrderRelQryBo();
        qryBo.setObjId(reqBo.getObjId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        List<Integer> relType = new ArrayList<>();
        relType.add(UocDicConstant.REL_TYPE.UP_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.COMMON_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.CH_INVOICE);
        qryBo.setRelTypeList(relType);
        return iUocOrderModel.qryListRelInfo(qryBo);
    }

    private void putStr(JSONObject inspOrderJson, UocInspOrderDo inspOrderMain, Map<String, Map<String, String>> dicMap) {
        Map<String, String> stateMap = dicMap.get(UocStateConstants.InspOrder.P_CODE);
        Map<String, String> checkStateMap = dicMap.get(UocDicConstant.CHECK_STATE.P_CODE);
        Map<String, String> invoiceTagMap = dicMap.get(UocDicConstant.INVOICE_TAG.P_CODE);
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_STATE_STR,
                ObjectUtil.isNotEmpty(stateMap) ? stateMap.get(inspOrderMain.getInspOrderState()) : "");
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.CHECK_STATE_STR,
                ObjectUtil.isNotEmpty(checkStateMap) ? checkStateMap.get(inspOrderMain.getCheckState()) : "");
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INVOICE_TAG_STR,
                ObjectUtil.isNotEmpty(invoiceTagMap) ? invoiceTagMap.get(Convert.toStr(inspOrderMain.getInvoiceTag())) : "");
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_ID,
                ObjectUtil.isNotEmpty(inspOrderJson.get(UocConstant.ES_MAIN_OTHER.SALE_ORD_ID)) ? inspOrderMain.getSaleOrderId().toString() : "");
    }

    private void putShipItem(JSONObject inspOrderItemJson, UocShipOrderItem uocShipOrderItem) {
        if (null != uocShipOrderItem) {
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SEND_COUNT, uocShipOrderItem.getSendCount());
        }
    }

    private void putSaleStakeholder(UocSaleOrderDo saleOrder, JSONObject inspOrderJson) {
        UocSaleStakeholder uocSaleStakeholder = saleOrder.getStakeholder();
        if (null != uocSaleStakeholder) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NO, uocSaleStakeholder.getSupNo());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ID, uocSaleStakeholder.getSupId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, uocSaleStakeholder.getSupName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, uocSaleStakeholder.getPurUserId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, uocSaleStakeholder.getPurOrgId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, uocSaleStakeholder.getPurOrgName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_COMPANY_ID, uocSaleStakeholder.getPurCompanyId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_COMPANY_NAME, uocSaleStakeholder.getPurCompanyName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ID, uocSaleStakeholder.getProId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_NAME, uocSaleStakeholder.getProName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ACCOUNT, uocSaleStakeholder.getPurAccount());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ACCOUNT_NAME, uocSaleStakeholder.getPurAccountName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_LOGIN_NAME, uocSaleStakeholder.getPurUserName());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_PATH, uocSaleStakeholder.getPurOrgPath());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ORG_PATH, uocSaleStakeholder.getSupOrgPath());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ORG_PATH, uocSaleStakeholder.getProOrgPath());
        }
    }

    private void putShipOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        List<UocShipOrderDo> uocShipOrderDoList = getListShipOrder(inspOrderMain);
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            List<String> shipOrderNoList = new ArrayList<>();
            List<String> shipOrderIdList = new ArrayList<>();
            uocShipOrderDoList.forEach(uocShipOrderDo -> {
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
            });
            uocShipOrderDoList.sort(Comparator.comparing(UocShipOrderDo::getArriveTime).reversed());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.LAST_ARRIVE_TIME, uocShipOrderDoList.get(0).getArriveTime());
            //一个验收单只会对应一个发货单
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO, shipOrderNoList);
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_ID, shipOrderIdList);
        }
    }

    private List<UocShipOrderDo> getListShipOrder(UocInspOrderDo uocInspOrderDo) {
        if (CollectionUtils.isEmpty(uocInspOrderDo.getUocShipInspRelList())) {
            return new ArrayList<>();
        }
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderIdList(uocInspOrderDo.getUocShipInspRelList().stream().map(UocShipInspRel::getShipOrderId).collect(Collectors.toList()));
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private Map<Long, UocShipOrderItem> getListShipOrderItem(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getShipOrderItemId).collect(Collectors.toList()));
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            return uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        }
        return new HashMap<>();
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<>();
    }

    private void putSaleItem(JSONObject inspOrderItemJson, UocSaleOrderItem uocSaleOrderItem) {
        if (null != uocSaleOrderItem) {
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SUPPLIER_ID, uocSaleOrderItem.getSupplierId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SUPPLIER_SHOP_ID, uocSaleOrderItem.getSupplierShopId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_EXT_SKU_ID, uocSaleOrderItem.getSkuExtSkuId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_ID, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_NAME, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_ID, uocSaleOrderItem.getSkuId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_CODE, uocSaleOrderItem.getSkuCode());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_NAME, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_ID, uocSaleOrderItem.getSkuMaterialId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_CODE, uocSaleOrderItem.getSkuMaterialCode());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MAIN_PIC_URL, uocSaleOrderItem.getSkuMainPicUrl());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_NAME, uocSaleOrderItem.getSkuMaterialName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_ID, uocSaleOrderItem.getSkuMaterialTypeId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_NAME, uocSaleOrderItem.getSkuMaterialTypeName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.MODEL, uocSaleOrderItem.getModel());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SPEC, uocSaleOrderItem.getSpec());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX, uocSaleOrderItem.getTax());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX_ID, uocSaleOrderItem.getTaxId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX_PRICE, uocSaleOrderItem.getTaxPrice());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG, uocSaleOrderItem.getL1Catalog());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG_NAME, uocSaleOrderItem.getL1CatalogName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG, uocSaleOrderItem.getL2Catalog());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG_NAME, uocSaleOrderItem.getL2CatalogName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG, uocSaleOrderItem.getL3Catalog());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG_NAME, uocSaleOrderItem.getL3CatalogName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SALE_PRICE, uocSaleOrderItem.getSalePrice());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.PUR_PRICE, uocSaleOrderItem.getPurchasePrice());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.PURCHASE_COUNT, uocSaleOrderItem.getPurchaseCount());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SETTLE_UNIT, uocSaleOrderItem.getSettleUnit());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.UNIT_DIGIT, StringUtils.isEmpty(uocSaleOrderItem.getUnitDigit()) ? "" : uocSaleOrderItem.getUnitDigit());
        }
    }

    private UocInspOrderDo getInspOderItem(UocInspOrderDo inspOrderMain) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        uocInspOrderItemQryBo.setOrderId(inspOrderMain.getOrderId());
        return iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
    }

    private UocInspOrderDo getInspOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    /**
     * 查询执行单主体
     */
//    private UocImplOrderDo getImplOrderMain(UocInspOrderDo uocInspOrderDo) {
//        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
//        uocImplOrderQryBo.setImplOrderId(uocInspOrderDo.getImplOrderId());
//        uocImplOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
//        return iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
//    }
//
//    private UocImplOrderDo getListImplOrderItem(UocInspOrderDo uocInspOrderDo) {
//        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
//        uocImplOrderItemQryBo.setImplOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getImplOrderItemId).filter(Objects::nonNull).collect(Collectors.toList()));
//        uocImplOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
//        return iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
//    }

    /**
     * 查询销售单主体
     */
    private UocSaleOrderDo getSaleOrder(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    /**
     * 查询订单主体
     *
     * @param reqBo
     * @return UocOrderDo
     */
    private UocOrderDo getUocOrderDo(UocInspOrderDo reqBo) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.qryOrderBy(qryBo);
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.InspOrder.P_CODE);
        pCodes.add(UocDicConstant.CHECK_STATE.P_CODE);
        pCodes.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        pCodes.add(UocDicConstant.OBJ_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REL_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REL_STATUS.P_CODE);
        pCodes.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        pCodes.add(UocDicConstant.PAY_RULE.P_CODE);
        pCodes.add(UocDicConstant.PAY_ACCOUNT_DAY_RULE.P_CODE);
        pCodes.add(UocDicConstant.PAY_NODE_RULE.P_CODE);
        pCodes.add(UocDicConstant.TRADE_MODE.P_CODE);
        pCodes.add(UocDicConstant.UOC_INSP_ORDER_PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PAY_STATE.P_CODE);
        pCodes.add(UocDicConstant.UOC_PRO_CNNG_ORDER_STATUS.P_CODE);
        pCodes.add(UocDicConstant.ORDER_CREATE_USE_TYPE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private String qryCheckState(IUocEsSyncQryReqBo reqBo,UocInspOrderDo inspOrderMain) {
        UocOrderCheckAccountQryBo uocOrderCheckAccountQryBo = new UocOrderCheckAccountQryBo();
        uocOrderCheckAccountQryBo.setOrderId(inspOrderMain.getSaleOrderId());
        uocOrderCheckAccountQryBo.setObjId(reqBo.getObjId());
        uocOrderCheckAccountQryBo.setObjType(reqBo.getObjType());
        UocOrderCheckAccount uocOrderCheckAccount = iUocOrderModel.qryCheckInfo(uocOrderCheckAccountQryBo);
        if (null == uocOrderCheckAccount) {
            return UocDicConstant.CHECK_STATE.NO_CHECK.toString();
        }
        return Convert.toStr(uocOrderCheckAccount.getCheckState());
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
//            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });

                //为了联调，先取第一个环节编码和任务id
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }

            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param objType
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询销售单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        //销售单
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjId(reqBo.getObjId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {//整单
            uocApprovalObjQryBo.setObjId(reqBo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }

        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            //taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                procInst.setTaskList(taskBoList);

                String procInstId = "";
                if (UocDicConstant.OBJ_TYPE.ORDER.equals(objType)) {
                    procInstId = uocOrderTaskInsts.get(0).getProcInstId();
                } else {
                    //取审批未结束的审批实例Id
                    for (UocOrderTaskInst bo : uocOrderTaskInsts) {
                        if (0 == bo.getFinishTag()) {
                            procInstId = bo.getProcInstId();
                            break;
                        }
                    }
                }
                if (StringUtils.isNotBlank(procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }

        }
        return procInst;
    }

}
