/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.impl.UocAfOrderModelImpl;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderFinishConfirmService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderFinishConfirmService"})
public class UocAfterOrderFinishConfirmServiceImpl
implements UocAfterOrderFinishConfirmService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private UocAfOrderModelImpl uocAfOrderModel;
    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @PostMapping(value={"finishConfirmAfterOrder"})
    public UocAfterOrderFinishConfirmRspBo finishConfirmAfterOrder(@RequestBody UocAfterOrderFinishConfirmReqBo reqBo) {
        this.val(reqBo);
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setOrderId(reqBo.getOrderId());
        uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.COMPLATE);
        List<UocAfOrderObj> afOrderObjList = this.uocAfOrderModel.getAfOrderObjList(reqBo);
        if (null != reqBo.getFlag() && reqBo.getFlag() == 1) {
            uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.REMARK_COMPLATE);
        }
        uocAfOrderDo.setFinishTime(new Date());
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        UocAfOrder afOrderById = this.uocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(afOrderById.getServType())) {
            uocAfOrderDo.setPayState(this.payStateRevise(afOrderObjList.get(0)));
        }
        uocAfOrderDo.setWaybillFlag(0);
        this.afOrderModel.modifyAfOrderState(uocAfOrderDo);
        if (null != reqBo.getFlag() && reqBo.getFlag() == 1) {
            this.updateAfteringCount(reqBo);
        }
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        UocAfterOrderFinishConfirmRspBo rspBo = UocRu.success(UocAfterOrderFinishConfirmRspBo.class);
        rspBo.setShipOrderId(afOrderObjList.get(0).getShipOrderId());
        rspBo.setSaleOrderId(afOrderObjList.get(0).getSaleOrderId());
        rspBo.setShipOrderIdList(this.setShipOrderIdList(afOrderObjList));
        return rspBo;
    }

    private List<Long> setShipOrderIdList(List<UocAfOrderObj> afOrderObjList) {
        ArrayList<Long> list = new ArrayList<Long>();
        afOrderObjList.forEach(uocAfOrderObj -> list.add(uocAfOrderObj.getShipOrderId()));
        return list;
    }

    private void val(UocAfterOrderFinishConfirmReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getAfOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u552e\u540e\u5355ID\u4e3a\u7a7a");
        }
    }

    private void updateAfteringCount(UocAfterOrderFinishConfirmReqBo reqBo) {
        this.uocAfOrderModel.modifyAfterOrderCount(reqBo);
    }

    private Integer payStateRevise(UocAfOrderObj afOrderObj) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setOrderId(afOrderObj.getOrderId());
        querySaleOrderDo.setSaleOrderId(afOrderObj.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.saleOrderModel.getSaleOrderMain(querySaleOrderDo);
        UocShipOrderItemQryBo shipOrderItemQryBo = new UocShipOrderItemQryBo();
        shipOrderItemQryBo.setShipOrderId(afOrderObj.getShipOrderId());
        shipOrderItemQryBo.setOrderId(afOrderObj.getOrderId());
        List<UocShipOrderItem> shipOrderItemList = this.shipOrderModel.getShipOrderItemList(shipOrderItemQryBo);
        BigDecimal shipCount = shipOrderItemList.stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        UocAfOrderItemQryBo afOrderItemQryBo = new UocAfOrderItemQryBo();
        afOrderItemQryBo.setOrderId(afOrderObj.getOrderId());
        afOrderItemQryBo.setAfOrderId(afOrderObj.getAfOrderId());
        List<UocAfOrderItem> afOrderItemList = this.afOrderModel.getAfOrderItemList(afOrderItemQryBo);
        BigDecimal afCount = afOrderItemList.stream().map(UocAfOrderItem::getReturnCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Boolean payFlag = shipCount.compareTo(afCount) == 0;
        Integer patState = null;
        if (null != saleOrderMain) {
            if (String.valueOf(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED).equals(saleOrderMain.getPayType())) {
                patState = payFlag != false ? UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED : UocDicConstant.PAY_AFTER_STATE.PART_REFUNDED;
            }
            if (String.valueOf(UocDicConstant.PAY_TYPE.PAY_BY_PERIOD).equals(saleOrderMain.getPayType())) {
                if (UocDicConstant.PAY_STATE.WAIT_PAY.equals(saleOrderMain.getPayState())) {
                    patState = UocDicConstant.PAY_AFTER_STATE.AMOUNT__DUE_UPDATED;
                }
                if (UocDicConstant.PAY_STATE.PAYED.equals(saleOrderMain.getPayState())) {
                    patState = payFlag != false ? UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED : UocDicConstant.PAY_AFTER_STATE.PART_REFUNDED;
                }
            }
        }
        return patState;
    }
}

