/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocElasticsearchUtil;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.service.domainservice.UocEsSyncServicePro;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocEsSyncServicePro"})
public class UocEsSyncServiceProImpl
implements UocEsSyncServicePro {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncServiceProImpl.class);
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Value(value="${uoc.syncProDeleteAndCreateIndex:false}")
    private boolean syncProDeleteAndCreateIndex;

    @PostMapping(value={"sync"})
    public UocEsSyncRspBo sync(@RequestBody UocEsSyncReqBo reqBo) {
        this.val(reqBo);
        if (!reqBo.getAll().booleanValue()) {
            SyncEsRunnableBo signleSync = new SyncEsRunnableBo();
            signleSync.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            signleSync.setOrderId(reqBo.getOrderId());
            signleSync.setObjId(reqBo.getObjId());
            signleSync.setIndexName(reqBo.getIndexName());
            this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(signleSync));
            return UocRu.success(UocEsSyncRspBo.class);
        }
        if (reqBo.getSyncAllIndex().booleanValue() || this.uocIndexConfig.getSaleOrderIndex().equals(reqBo.getIndexName())) {
            this.delAndCreateIdx(this.uocIndexConfig.getSaleOrderIndex());
            this.batchSyncSale();
        }
        if (reqBo.getSyncAllIndex().booleanValue() || this.uocIndexConfig.getShipOrderIndex().equals(reqBo.getIndexName())) {
            this.delAndCreateIdx(this.uocIndexConfig.getShipOrderIndex());
            this.batchSyncShip();
        }
        if (reqBo.getSyncAllIndex().booleanValue() || this.uocIndexConfig.getInspOrderIndex().equals(reqBo.getIndexName())) {
            this.delAndCreateIdx(this.uocIndexConfig.getInspOrderIndex());
            this.batchSyncInsp();
        }
        return UocRu.success(UocEsSyncRspBo.class);
    }

    private void batchSyncInsp() {
        this.iUocInspOrderModel.batchSyncInsp();
    }

    private void batchSyncShip() {
        this.iUocShipOrderModel.batchSyncShip();
    }

    private void batchSyncSale() {
        this.iUocSaleOrderModel.batchSyncSale();
    }

    private void delAndCreateIdx(String idx) {
        if (this.syncProDeleteAndCreateIndex) {
            block3: {
                try {
                    this.uocElasticsearchUtil.deleteIndex(idx);
                }
                catch (Exception e) {
                    String eCause = JSON.toJSONString((Object)e.getCause());
                    log.error(eCause);
                    if (!eCause.contains("index_not_found_exception")) break block3;
                    log.info("\u7d22\u5f15\u4e0d\u5b58\u5728");
                }
            }
            this.uocElasticsearchUtil.createIndex(idx);
        }
    }

    private void val(UocEsSyncReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!reqBo.getAll().booleanValue()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ID\u4e3a\u7a7a");
            }
            if (null == reqBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBo.getIndexName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u7d22\u5f15\u540d\u4e3a\u7a7a");
            }
        }
    }
}

