/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.statecalculator;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.statecalculator.UocStateCalculator;
import com.tydic.dyc.oc.components.statecalculator.UocStateCalculatorManager;
import com.tydic.dyc.oc.components.statecalculator.bo.UocStateCalculatorReqBo;
import com.tydic.dyc.oc.components.statecalculator.bo.UocStateCalculatorRspBo;
import com.tydic.dyc.oc.components.statecalculator.bo.UocStateCalculatorRspDataBo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.qrybo.UocQryOrderStateChngLogBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocStateCalculatorService {
    private static final Logger log = LoggerFactory.getLogger(UocStateCalculatorService.class);
    @Autowired
    private UocStateCalculatorManager uocStateCalculatorManager;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    public void calculateStateAndSaveLog(UocStateCalculatorReqBo reqBo) {
        UocStateCalculator uocStateCalculator;
        log.info("\u72b6\u6001\u8ba1\u7b97\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        this.validateReqArg(reqBo);
        String callServerClassName = reqBo.getCallServer().getClass().getName();
        String calculatorClassName = this.getCalculatorClassName(callServerClassName);
        if (ObjectUtil.isNotEmpty((Object)calculatorClassName) && ObjectUtil.isNotEmpty((Object)(uocStateCalculator = this.uocStateCalculatorManager.getUocStateCalculator(calculatorClassName)))) {
            log.info("\u72b6\u6001\u8ba1\u7b97\u670d\u52a1\u5b9e\u73b0\u7c7b\u8c03\u7528\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
            UocStateCalculatorRspBo uocStateCalculatorRspBo = uocStateCalculator.calculateState(reqBo);
            log.info("\u72b6\u6001\u8ba1\u7b97\u670d\u52a1\u5b9e\u73b0\u7c7b\u8c03\u7528\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)uocStateCalculatorRspBo)));
            this.validateRsp(uocStateCalculatorRspBo);
            if (ObjectUtil.isNotEmpty(uocStateCalculatorRspBo.getChangeDataList())) {
                this.saveStateChngLog(uocStateCalculatorRspBo);
            }
        }
    }

    private void saveStateChngLog(UocStateCalculatorRspBo uocStateCalculatorRspBo) {
        List<UocStateCalculatorRspDataBo> changeDataList = uocStateCalculatorRspBo.getChangeDataList();
        for (UocStateCalculatorRspDataBo uocStateCalculatorRspDataBo : changeDataList) {
            UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
            uocOrderStateChgLog.setId(IdUtil.nextId());
            uocOrderStateChgLog.setObjId(uocStateCalculatorRspDataBo.getObjId());
            uocOrderStateChgLog.setOrderId(uocStateCalculatorRspDataBo.getOrderId());
            uocOrderStateChgLog.setObjType(uocStateCalculatorRspDataBo.getObjType());
            uocOrderStateChgLog.setOldState(this.qryOldState(uocStateCalculatorRspDataBo));
            uocOrderStateChgLog.setNewState(uocStateCalculatorRspDataBo.getState());
            uocOrderStateChgLog.setChgTime(new Date());
            uocOrderStateChgLog.setOperId(uocStateCalculatorRspDataBo.getOperId());
            uocOrderStateChgLog.setChgReson(uocStateCalculatorRspDataBo.getChngReason());
            uocOrderStateChgLog.setChgDesc(uocStateCalculatorRspDataBo.getChngDesc());
            this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        }
    }

    private String qryOldState(UocStateCalculatorRspDataBo uocStateCalculatorRspDataBo) {
        UocQryOrderStateChngLogBo qryBo = new UocQryOrderStateChngLogBo();
        qryBo.setObjId(uocStateCalculatorRspDataBo.getObjId());
        qryBo.setOrderId(uocStateCalculatorRspDataBo.getOrderId());
        qryBo.setObjType(uocStateCalculatorRspDataBo.getObjType());
        return this.iUocCommonModel.qryUocLastChngStateByObjId(qryBo).getNewState();
    }

    private String getCalculatorClassName(String callServerClassName) {
        return this.iUocCommonModel.qryUocStateCalculatorServerConfig(callServerClassName).getCalculatorService();
    }

    private void validateRsp(UocStateCalculatorRspBo reqChngBo) {
        if (null == reqChngBo) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocStateCalculatorRspDataBo> changeDataList = reqChngBo.getChangeDataList();
        if (ObjectUtil.isNotEmpty(changeDataList)) {
            for (UocStateCalculatorRspDataBo reqBo : changeDataList) {
                if (null == reqBo.getOrderId()) {
                    throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5b57\u6bb5[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == reqBo.getObjType()) {
                    throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5b57\u6bb5[objType]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == reqBo.getObjId()) {
                    throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5b57\u6bb5[objId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != reqBo.getState()) continue;
                throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5b57\u6bb5[state]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void validateReqArg(UocStateCalculatorReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getCallServer()) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5b57\u6bb5[callServer]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getServerReqBo()) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5b57\u6bb5[serverReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getServerRspBo()) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355\u72b6\u6001\u8ba1\u7b97\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5b57\u6bb5[serverRspBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

