/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.service.bargaining.UocCancelBargainingService;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocCancelBargainingService"})
public class UocCancelBargainingServiceImpl
implements UocCancelBargainingService {
    private static final Logger log = LoggerFactory.getLogger(UocCancelBargainingServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"cancelBargaining"})
    public UocCancelBargainingRspBo cancelBargaining(@RequestBody UocCancelBargainingReqBo uocCancelBargainingReqBo) {
        this.verifyParam(uocCancelBargainingReqBo);
        this.verifyState(uocCancelBargainingReqBo);
        this.updateBargainingState(uocCancelBargainingReqBo);
        this.insertProgressRecord(uocCancelBargainingReqBo);
        return UocRu.success(UocCancelBargainingRspBo.class);
    }

    private void verifyState(UocCancelBargainingReqBo reqBO) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        UocBargainingDo bargainingDo = this.uocBargainingModel.qryBargainingBy(uocBargainingDo);
        if (!"YJ_YBJ".equals(bargainingDo.getBargainingState()) && !"YJ_BJZ".equals(bargainingDo.getBargainingState())) {
            throw new BaseBusinessException("102001", "\u4e0d\u80fd\u7ec8\u6b62\u8bae\u4ef7\uff0c\u53ea\u80fd\u5bf9\u5df2\u62a5\u4ef7\u6216\u62a5\u4ef7\u4e2d\u7684\u8bae\u4ef7\u5355\u53d1\u8d77\u7ec8\u6b62\uff01");
        }
    }

    private void verifyParam(UocCancelBargainingReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBargainingId()) {
            throw new BaseBusinessException("102001", "\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getCancelReason())) {
            throw new BaseBusinessException("102001", "\u7ec8\u6b62\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateBargainingState(UocCancelBargainingReqBo reqBO) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setUpdateTime(new Date());
        uocBargainingDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setUpdateOperName(reqBO.getName());
        uocBargainingDo.setCancelTime(new Date());
        uocBargainingDo.setCancelReason(reqBO.getCancelReason());
        uocBargainingDo.setCancelOperName(reqBO.getName());
        uocBargainingDo.setCancelOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setBargainingState("YJ_YZZ");
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.updateBargaining(uocBargainingDo);
    }

    private void insertProgressRecord(UocCancelBargainingReqBo reqBO) {
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CANCEL);
        recordDo.setOperTypeName("\u8bae\u4ef7\u5355\u7ec8\u6b62");
        recordDo.setOperId((long)reqBO.getUserId());
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        recordDo.setRemark("\u7ec8\u6b62\u539f\u56e0\uff1a" + reqBO.getCancelReason());
        this.uocBargainingModel.insertProgressRecord(recordDo);
    }
}

