package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@HTServiceImpl
@Slf4j
public class UocCalculateSaleOrderFeeServiceImpl implements UocCalculateSaleOrderFeeService{
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    
    @Override
    public UocCalculateSaleOrderFeeServiceRspBo createAfterOrder(UocCalculateSaleOrderFeeServiceReqBo reqBo) {
        
        // 0、出参
        UocCalculateSaleOrderFeeServiceRspBo rspBo = UocRu.success(UocCalculateSaleOrderFeeServiceRspBo.class);
        
        //1. 入参校验
        valiteParam(reqBo);

        //2. 查询销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getUocSaleOrderItems(reqBo);
    
        //3. 查询变更明细
        List<UocChngOrderItemObj> uocChngOrderItemObjList = getUocChngOrderItemObjs(saleOrderItemList);
        
        //4. 计算实际得采购数量（采购数量 - 退货数量 - 拒收数量）
        List<UocSaleOrderItemBO> uocSaleOrderItemBOList = getRealItemList(saleOrderItemList, uocChngOrderItemObjList);
    
        rspBo.setSaleItemList(uocSaleOrderItemBOList);
        return rspBo;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 计算实际得采购数量（采购数量 - 退货数量 - 拒收数量）
     * @Date 11:37 2023/9/26
     * @Param [saleOrderItemList, uocChngOrderItemObjList]
     * @return java.util.List<com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO>
     */
    private List<UocSaleOrderItemBO> getRealItemList(List<UocSaleOrderItem> saleOrderItemList, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<UocSaleOrderItemBO> saleItemList = new ArrayList<>();
    
        Map<Long,UocSaleOrderItem> saleOrderItemBOMap = saleOrderItemList.stream().collect(Collectors.
                toMap(UocSaleOrderItem::getSaleOrderItemId, UocSaleOrderItem->UocSaleOrderItem));
        
        if(ObjectUtil.isNotEmpty(uocChngOrderItemObjList)){
            
            for(UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList){
                BigDecimal realCount = new BigDecimal("0");
    
                BigDecimal purchaseCount =  saleOrderItemBOMap.get(uocChngOrderItemObj.getSaleOrderItemId()).getPurchaseCount();
                BigDecimal returnCount =  saleOrderItemBOMap.get(uocChngOrderItemObj.getSaleOrderItemId()).getReturnCount();
                BigDecimal refuseCount =  saleOrderItemBOMap.get(uocChngOrderItemObj.getSaleOrderItemId()).getRefuseCount();
    
                if(UocDicConstant.CHNG_NUM_TYPE.ADD.equals(uocChngOrderItemObj.getAddOrSubtractType())){
                    realCount = purchaseCount.add(uocChngOrderItemObj.getChngNum()).subtract(returnCount).subtract(refuseCount);
                }
                if(UocDicConstant.CHNG_NUM_TYPE.SUBTRACT.equals(uocChngOrderItemObj.getAddOrSubtractType())){
                    realCount = purchaseCount.subtract(uocChngOrderItemObj.getChngNum()).subtract(returnCount).subtract(refuseCount);
                }
                UocSaleOrderItemBO uocSaleOrderItemBO = new UocSaleOrderItemBO();
                uocSaleOrderItemBO.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItemBO.setRealCount(realCount);
    
                saleItemList.add(uocSaleOrderItemBO);
            }
        }else {
    
            for (UocSaleOrderItem saleOrderItem: saleOrderItemList){
                BigDecimal realCount = new BigDecimal("0");
                realCount = saleOrderItem.getPurchaseCount().subtract(saleOrderItem.getReturnCount()).subtract(saleOrderItem.getRefuseCount());
    
                UocSaleOrderItemBO uocSaleOrderItemBO = new UocSaleOrderItemBO();
                uocSaleOrderItemBO.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                uocSaleOrderItemBO.setRealCount(realCount);
    
                saleItemList.add(uocSaleOrderItemBO);
            }
        }
        
        return saleItemList;
    }
    
    private List<UocChngOrderItemObj> getUocChngOrderItemObjs(List<UocSaleOrderItem> saleOrderItemList) {
        UocChngOrderItemObjQryBo chngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        
        chngOrderItemObjQryBo.setSaleOrderItemIdList(saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
        List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(chngOrderItemObjQryBo);
        return uocChngOrderItemObjList;
    }
    
    private List<UocSaleOrderItem> getUocSaleOrderItems(UocCalculateSaleOrderFeeServiceReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo =new UocSaleOrderItemQryBo();
        
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo =  iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        
        List<UocSaleOrderItem> saleOrderItemList = uocSaleOrderDo.getSaleOrderItems();
        return saleOrderItemList;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 入参校验
     * @Date 11:38 2023/9/26
     * @Param [reqBo]
     * @return void
     */
    private void  valiteParam(UocCalculateSaleOrderFeeServiceReqBo reqBo){
        
        if(ObjectUtil.isEmpty(reqBo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        if(ObjectUtil.isEmpty(reqBo.getSaleOrderId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参[saleOrderId]不能为空");
        }
        if(ObjectUtil.isEmpty(reqBo.getOrderId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参[orderId]不能为空");
        }
    }
    
}
