/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.service.bargaining.UocQryQuotationDetailService;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationDetailReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationDetailRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocQryQuotationDetailService"})
public class UocQryQuotationDetailServiceImpl
implements UocQryQuotationDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocQryQuotationDetailServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"qryQuotationDetail"})
    public UocQryQuotationDetailRspBo qryQuotationDetail(@RequestBody UocQryQuotationDetailReqBo reqBo) {
        this.verifyParam(reqBo);
        UocBargainingQuotationBo qryBargainingQuotationBo = new UocBargainingQuotationBo();
        qryBargainingQuotationBo.setQuotationId((long)reqBo.getQuotationId());
        qryBargainingQuotationBo.setBiddingCode(reqBo.getBiddingCode());
        UocBargainingQuotationBo quotationBo = this.uocBargainingModel.getQuotationBy(qryBargainingQuotationBo);
        if (quotationBo == null) {
            throw new BaseBusinessException("100001", "\u62a5\u4ef7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UocQryQuotationDetailRspBo rspBo = UocRu.js(quotationBo, UocQryQuotationDetailRspBo.class);
        UocBargainingDo uocBargainingQryDo = new UocBargainingDo();
        uocBargainingQryDo.setBargainingId(quotationBo.getBargainingId());
        UocBargainingDo uocBargainingDo = this.uocBargainingModel.qryBargainingBy(uocBargainingQryDo);
        rspBo.setSupId(uocBargainingDo.getSupId());
        rspBo.setSupNo(uocBargainingDo.getBargainingNo());
        rspBo.setSupplierName(uocBargainingDo.getSupplierName());
        rspBo.setBargainingState(uocBargainingDo.getBargainingState());
        return rspBo;
    }

    private void verifyParam(UocQryQuotationDetailReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getQuotationId()) {
            throw new BaseBusinessException("102001", "\u62a5\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

