/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocCalculateSaleOrderFeeService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCalculateSaleOrderFeeService"})
public class UocCalculateSaleOrderFeeServiceImpl
implements UocCalculateSaleOrderFeeService {
    private static final Logger log = LoggerFactory.getLogger(UocCalculateSaleOrderFeeServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @PostMapping(value={"calculate"})
    public UocCalculateSaleOrderFeeServiceRspBo calculate(@RequestBody UocCalculateSaleOrderFeeServiceReqBo reqBo) {
        UocCalculateSaleOrderFeeServiceRspBo rspBo = UocRu.success(UocCalculateSaleOrderFeeServiceRspBo.class);
        this.valiteParam(reqBo);
        List<UocSaleOrderItem> saleOrderItemList = this.getUocSaleOrderItems(reqBo);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.getUocChngOrderItemObjs(saleOrderItemList);
        List<UocSaleOrderItemBO> uocSaleOrderItemBOList = this.getRealItemList(saleOrderItemList, uocChngOrderItemObjList);
        rspBo.setSaleItemList(uocSaleOrderItemBOList);
        return rspBo;
    }

    private List<UocSaleOrderItemBO> getRealItemList(List<UocSaleOrderItem> saleOrderItemList, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        ArrayList<UocSaleOrderItemBO> saleItemList = new ArrayList<UocSaleOrderItemBO>();
        Map<Long, UocSaleOrderItem> saleOrderItemBOMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, UocSaleOrderItem2 -> UocSaleOrderItem2));
        if (ObjectUtil.isNotEmpty(uocChngOrderItemObjList)) {
            for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
                BigDecimal realCount = new BigDecimal("0");
                BigDecimal purchaseCount = saleOrderItemBOMap.get(uocChngOrderItemObj.getSaleOrderItemId()).getPurchaseCount();
                BigDecimal returnCount = saleOrderItemBOMap.get(uocChngOrderItemObj.getSaleOrderItemId()).getReturnCount();
                BigDecimal refuseCount = saleOrderItemBOMap.get(uocChngOrderItemObj.getSaleOrderItemId()).getRefuseCount();
                if (UocDicConstant.CHNG_NUM_TYPE.ADD.equals(uocChngOrderItemObj.getAddOrSubtractType())) {
                    realCount = purchaseCount.add(uocChngOrderItemObj.getChngNum()).subtract(returnCount).subtract(refuseCount);
                }
                if (UocDicConstant.CHNG_NUM_TYPE.SUBTRACT.equals(uocChngOrderItemObj.getAddOrSubtractType())) {
                    realCount = purchaseCount.subtract(uocChngOrderItemObj.getChngNum()).subtract(returnCount).subtract(refuseCount);
                }
                UocSaleOrderItemBO uocSaleOrderItemBO = new UocSaleOrderItemBO();
                uocSaleOrderItemBO.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItemBO.setRealCount(realCount);
                saleItemList.add(uocSaleOrderItemBO);
            }
        } else {
            for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
                BigDecimal realCount = new BigDecimal("0");
                realCount = saleOrderItem.getPurchaseCount().subtract(saleOrderItem.getReturnCount()).subtract(saleOrderItem.getRefuseCount());
                UocSaleOrderItemBO uocSaleOrderItemBO = new UocSaleOrderItemBO();
                uocSaleOrderItemBO.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                uocSaleOrderItemBO.setRealCount(realCount);
                saleItemList.add(uocSaleOrderItemBO);
            }
        }
        return saleItemList;
    }

    private List<UocChngOrderItemObj> getUocChngOrderItemObjs(List<UocSaleOrderItem> saleOrderItemList) {
        UocChngOrderItemObjQryBo chngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        chngOrderItemObjQryBo.setSaleOrderItemIdList(saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.iUocChngOrderModel.getListChngOrderItemObj(chngOrderItemObjQryBo);
        return uocChngOrderItemObjList;
    }

    private List<UocSaleOrderItem> getUocSaleOrderItems(UocCalculateSaleOrderFeeServiceReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> saleOrderItemList = uocSaleOrderDo.getSaleOrderItems();
        return saleOrderItemList;
    }

    private void valiteParam(UocCalculateSaleOrderFeeServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

