/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.UocGetApprovalOrderDetailService;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspReceiverAddressBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspStakeholderBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocGetApprovalOrderDetailService"})
public class UocGetApprovalOrderDetailServiceImpl
implements UocGetApprovalOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocGetApprovalOrderDetailServiceImpl.class);
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Value(value="${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;

    @PostMapping(value={"getApprovalOrderDetail"})
    public UocGetApprovalOrderDetailServiceRspBo getApprovalOrderDetail(@RequestBody UocGetApprovalOrderDetailServiceReqBo reqBo) {
        this.validateParam(reqBo);
        UocGetApprovalOrderDetailServiceRspBo rspBo = UocRu.success(UocGetApprovalOrderDetailServiceRspBo.class);
        UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
        uocAuditOrderQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        uocAuditOrderQryBo.setOrderId(reqBo.getOrderId());
        UocAuditOrderDo uocAuditOrderDo = this.iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
        rspBo.setAuditOrderCode(uocAuditOrderDo.getAuditOrderCode());
        rspBo.setAuditOrderId(uocAuditOrderDo.getAuditOrderId());
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        log.info("\u67e5\u8be2uocApprovalObjs\uff1a{}", (Object)JSON.toJSONString(uocApprovalObjs));
        List<Long> objIdList = uocApprovalObjs.stream().map(e -> Long.valueOf(e.getObjId())).collect(Collectors.toList());
        log.info("\u67e5\u8be2objIdList\uff1a{}", (Object)JSON.toJSONString(objIdList));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> saleOrderMainInfoList = this.iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
        rspBo.setCreateOrderTime(saleOrderMainInfoList.get(0).getCreateTime());
        rspBo.setSendTime(saleOrderMainInfoList.get(0).getSendTime());
        rspBo.setRemark(saleOrderMainInfoList.get(0).getRemark());
        if (null != saleOrderMainInfoList.get(0).getStakeholder()) {
            UocGetSaleOrderDetailServiceRspStakeholderBo stakeholderBo = new UocGetSaleOrderDetailServiceRspStakeholderBo();
            BeanUtils.copyProperties((Object)saleOrderMainInfoList.get(0).getStakeholder(), (Object)stakeholderBo);
            rspBo.setStakeholderBo(stakeholderBo);
        }
        Map<String, UocOrderAgreement> orderAgreementMap = null;
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderMainInfoList.get(0).getOrderSource())) {
            UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
            uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
            List<UocOrderAgreement> agreementOrderList = this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
            if (!CollectionUtils.isEmpty(agreementOrderList)) {
                orderAgreementMap = agreementOrderList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, e -> e));
            }
        }
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        uocOrderAccessoryQryBo.setObjId((Long)objIdList.get(0));
        List<UocOrderAccessory> accessoryList = this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        ArrayList<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<UocBaseOrderAccessoryTypeDetailBo>();
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(accessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap = accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(UocRu.jsl(accessoryDetailMap.get(attachmentType), UocBaseOrderAccessoryDetailBo.class));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        log.info("\u67e5\u8be2\u9644\u4ef6\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(accessoryDetailBoList));
        rspBo.setAccessoryList(accessoryDetailBoList);
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderInfo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(saleOrderMainInfoList.get(0).getOrderId());
        relaQryBo.setContactId(orderInfo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
        ArrayList uocBaseExtParallelBoList = new ArrayList();
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId((Long)objIdList.get(0));
        List<UocSaleOrderMap> saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            rspBo.setExtFields(JSONArray.parseArray((String)JSON.toJSONString(saleOrderExpandList), BaseExtendFieldBo.class));
        }
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderIdList(objIdList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        log.info("\u67e5\u8be2\u5ba1\u6279\u8be6\u60c5\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(saleOrderItemList));
        Map<Long, UocSaleOrderDo> uocSaleOrderDoMap = saleOrderMainInfoList.stream().collect(Collectors.toMap(UocSaleOrderDo::getSaleOrderId, e -> e));
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            List saleOrderDetailItemBoList = JSONArray.parseArray((String)JSON.toJSONString(saleOrderItemList), UocGetSaleOrderDetailServiceRspItemBo.class);
            rspBo.setSaleOrderDetailItemBoList(saleOrderDetailItemBoList);
            UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
            uocSaleItemMapQryBo.setSaleOrderItemIdList(saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
            List<UocSaleItemMap> saleItemMapList = this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
            Map<Long, List<UocSaleItemMap>> saleItemMapMap = saleItemMapList.stream().collect(Collectors.groupingBy(UocSaleItemMap::getSaleOrderItemId));
            BigDecimal totalPurchseFee = new BigDecimal("0");
            BigDecimal totalSaleFee = new BigDecimal("0");
            BigDecimal totalTransFee = new BigDecimal("0");
            for (UocGetSaleOrderDetailServiceRspItemBo itemBo : saleOrderDetailItemBoList) {
                itemBo.setSaleOrderNo(uocSaleOrderDoMap.get(itemBo.getSaleOrderId()).getSaleOrderNo());
                itemBo.setSupplierName(uocSaleOrderDoMap.get(itemBo.getSaleOrderId()).getStakeholder().getSupName());
                if (orderAgreementMap != null) {
                    itemBo.setAgreementNo(orderAgreementMap.get(itemBo.getAgreementId()).getPlaAgreementCode());
                    itemBo.setAgreementName(orderAgreementMap.get(itemBo.getAgreementId()).getAgreementName());
                }
                totalPurchseFee = totalPurchseFee.add(itemBo.getPurchaseFee());
                totalSaleFee = totalSaleFee.add(itemBo.getSaleFee());
                itemBo.setExtFields(UocRu.jsl(saleItemMapMap.get(itemBo.getSaleOrderItemId()), BaseExtendFieldBo.class));
            }
            rspBo.setTotalSaleFee(totalSaleFee);
            rspBo.setTotalPurchaseFee(totalPurchseFee);
            rspBo.setTotalTransFee(totalTransFee);
        }
        log.info("\u67e5\u8be2\u5ba1\u6279\u8be6\u60c5\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)rspBo));
        String dataAchiveTabSuffix = null;
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(reqBo, dataAchiveTabSuffix);
        rspBo.setAuditProcInst(auditProcInst);
        return rspBo;
    }

    private void validateParam(UocGetApprovalOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAuditOrderId() == null) {
            throw new BaseBusinessException("100001", "\u5ba1\u6279\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(UocGetApprovalOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        uocApprovalObjQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                String procInstId;
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    uocApprovalObjQryBo1.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (ObjectUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setTaskList(taskBoList);
                String string = procInstId = CollectionUtils.isEmpty(uocOrderTaskInsts) ? "" : uocOrderTaskInsts.get(0).getProcInstId();
                if (StringUtils.isNotBlank((CharSequence)procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }
        }
        return procInst;
    }
}

