package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationDetailReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationDetailRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocQryQuotationDetailServiceImpl
 * 说明:
 * 时间:2023/9/19 14:24
 * 作者:Dum
 */
@Slf4j
@HTServiceImpl
public class UocQryQuotationDetailServiceImpl implements UocQryQuotationDetailService {

    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @Override
    public UocQryQuotationDetailRspBo qryQuotationDetail(UocQryQuotationDetailReqBo reqBo) {
        verifyParam(reqBo);
        //查询报价单
        UocBargainingQuotationBo qryBargainingQuotationBo = new UocBargainingQuotationBo();
        qryBargainingQuotationBo.setQuotationId(Long.valueOf(reqBo.getQuotationId()));
        qryBargainingQuotationBo.setBiddingCode(reqBo.getBiddingCode());
        UocBargainingQuotationBo quotationBo = uocBargainingModel.getQuotationBy(qryBargainingQuotationBo);
        if (quotationBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "报价单信息不存在");
        }
        UocQryQuotationDetailRspBo rspBo = UocRu.js(quotationBo, UocQryQuotationDetailRspBo.class);
        //查询议价单
        UocBargainingDo uocBargainingQryDo = new UocBargainingDo();
        uocBargainingQryDo.setBargainingId(quotationBo.getBargainingId());
        UocBargainingDo uocBargainingDo = uocBargainingModel.qryBargainingBy(uocBargainingQryDo);
        rspBo.setSupId(uocBargainingDo.getSupId());
        rspBo.setSupNo(uocBargainingDo.getBargainingNo());
        rspBo.setSupplierName(uocBargainingDo.getSupplierName());
        rspBo.setBargainingState(uocBargainingDo.getBargainingState());
        return rspBo;
    }

    /**
     * 参数校验
     *
     * @param reqBo
     */
    private void verifyParam(UocQryQuotationDetailReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getQuotationId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "报价单ID不能为空");
        }

    }
}
