/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocCancelSaleOrderTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderService"})
public class UocCancelSaleOrderServiceImpl
implements UocCancelSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocCancelSaleOrderServiceImpl.class);
    @Autowired
    private UocCancelSaleOrderTransaction uocCancelSaleOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"cancelSaleOrder"})
    public UocCancelSaleOrderServiceRspBo cancelSaleOrder(@RequestBody UocCancelSaleOrderServiceReqBo reqBo) {
        UocCancelSaleOrderServiceRspBo rspBo = this.uocCancelSaleOrderTransaction.cancelSaleOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocCancelSaleOrderServiceReqBo reqBo, UocCancelSaleOrderServiceRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        orderBo.setOrderId(reqBo.getOrderId());
        orderBo.setObjId(reqBo.getSaleOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

