/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspInspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspSaleOrderBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UocUpdateInspPayStatusTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocUpdateInspPayStatusTransaction.class);
    @Value(value="${uoc.updateInspPayStatus.size:100}")
    private Integer updateInspPayStatusSize;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocUpdateInspPayStatusServiceRspBo updateInspPayStatus(UocUpdateInspPayStatusServiceReqBo reqBo) {
        log.info("\u9a8c\u6536\u5355\u652f\u4ed8\u56de\u8c03\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        this.validateReqBo(reqBo);
        UocUpdateInspPayStatusServiceRspBo rspBo = UocRu.success(UocUpdateInspPayStatusServiceRspBo.class);
        List inspList = reqBo.getInspList();
        UocInspOrderQryBo qryInspBo = new UocInspOrderQryBo();
        qryInspBo.setInspOrderIdList(inspList);
        List<UocInspOrderDo> listInspOrder = this.iUocInspOrderModel.getListInspOrder(qryInspBo);
        List<Long> saleOrderIdList = listInspOrder.stream().map(UocInspOrderDo::getSaleOrderId).distinct().collect(Collectors.toList());
        UocSaleOrderDo qrySaleBo = new UocSaleOrderDo();
        qrySaleBo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderDo> uocSaleOrderDoList = this.iUocSaleOrderModel.qrySaleOrderList(qrySaleBo);
        for (UocInspOrderDo uocInspOrderDo : listInspOrder) {
            Long saleOrderId = uocInspOrderDo.getSaleOrderId();
            Long orderId = uocInspOrderDo.getOrderId();
            Integer payStatus = uocInspOrderDo.getPayStatus();
            Long inspOrderId = uocInspOrderDo.getInspOrderId();
            UocUpdateInspPayStatusServiceRspInspBo inspTmpBo = new UocUpdateInspPayStatusServiceRspInspBo();
            rspBo.getInspList().add(inspTmpBo);
            inspTmpBo.setOrderId(orderId);
            inspTmpBo.setSaleOrderId(saleOrderId);
            inspTmpBo.setInspOrderId(inspOrderId);
            if (UocStateConstants.INSP_ORDER_STATUS.PAYED.equals(payStatus)) {
                inspTmpBo.setInspPayStatus(payStatus);
                continue;
            }
            inspTmpBo.setInspPayStatus(UocStateConstants.INSP_ORDER_STATUS.PAYED);
            UocInspOrderDo updateInspBo = new UocInspOrderDo();
            updateInspBo.setOrderId(orderId);
            updateInspBo.setInspOrderId(inspOrderId);
            updateInspBo.setPayStatus(UocStateConstants.INSP_ORDER_STATUS.PAYED);
            log.info("\u9a8c\u6536\u5355\u652f\u4ed8\u56de\u8c03\u66f4\u65b0\u9a8c\u6536\u5355\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)updateInspBo));
            this.iUocInspOrderModel.updateInspPayStatus(updateInspBo);
        }
        List<UocInspOrderDo> updateedList = this.iUocInspOrderModel.getListInspOrder(qryInspBo);
        Map<Long, List<UocInspOrderDo>> saleInspMap = updateedList.stream().collect(Collectors.groupingBy(UocInspOrderDo::getSaleOrderId));
        for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDoList) {
            List<UocInspOrderDo> uocInspOrderDoList = saleInspMap.get(uocSaleOrderDo.getSaleOrderId());
            boolean allInspPayed = true;
            for (UocInspOrderDo uocInspOrderDo : uocInspOrderDoList) {
                if (UocStateConstants.INSP_ORDER_STATUS.PAYED.equals(uocInspOrderDo.getPayStatus())) continue;
                allInspPayed = false;
                break;
            }
            if (!allInspPayed || !"XS_DH_JS".equals(uocSaleOrderDo.getSaleOrderState()) && !"XS_YS_YS".equals(uocSaleOrderDo.getSaleOrderState()) && !"XS_YS_BFYS".equals(uocSaleOrderDo.getSaleOrderState()) || UocStateConstants.PAY_STATUS.PAYED.equals(uocSaleOrderDo.getPayState())) continue;
            log.info("\u9500\u552e\u5355({})\u66f4\u65b0\u72b6\u6001\u4e3a\u5df2\u652f\u4ed8({})", (Object)uocSaleOrderDo.getSaleOrderId(), (Object)UocStateConstants.PAY_STATUS.PAYED);
            UocSaleOrderDo updateSaleStateDo = new UocSaleOrderDo();
            updateSaleStateDo.setOrderId(uocSaleOrderDo.getOrderId());
            updateSaleStateDo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            updateSaleStateDo.setPayState(UocStateConstants.PAY_STATUS.PAYED);
            updateSaleStateDo.setUpdateTime(new Date());
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleStateDo);
            UocUpdateInspPayStatusServiceRspSaleOrderBo addCompletionBO = new UocUpdateInspPayStatusServiceRspSaleOrderBo();
            addCompletionBO.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            addCompletionBO.setOrderId(uocSaleOrderDo.getOrderId());
            rspBo.getNeedCompletionSaleOrderList().add(addCompletionBO);
        }
        return rspBo;
    }

    private void validateReqBo(UocUpdateInspPayStatusServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInspList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[inspList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getInspList().size() > this.updateInspPayStatusSize) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u9a8c\u6536\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\uff1a" + this.updateInspPayStatusSize);
        }
    }
}

