package com.tydic.dyc.oc.model.insporder.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题:UocInspOrderModelImpl
 * 说明:验收单方法实现
 * 时间:2022/2/25 11:34
 * 作者:罗有
 */
@Slf4j
@Service
public class UocInspOrderModelImpl implements IUocInspOrderModel {

    @Autowired
    private UocInspOrderRepository uocInspOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Override
    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        valDo(uocInspOrderDo);
        uocInspOrderRepository.createInspOrder(uocInspOrderDo);
        uocCommonRepository.addBatchOrderAccessory(uocInspOrderDo.getUocOrderAccessoryList());
    }

    @Override
    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        //罗侃（北控）要求注释，不强校验
//        if (null == uocInspOrderQryBo.getOrderId()) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
//        }
        return uocInspOrderRepository.getInspOrderMain(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        if (null == uocInspOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
//        if (null == uocInspOrderItemQryBo.getOrderId()) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
//        }
        UocInspOrderDo uocInspOrderDo = uocInspOrderRepository.getListInspOrderItem(uocInspOrderItemQryBo);
        log.info("验收明细查询出参：{}", JSON.toJSONString(uocInspOrderDo));
        return uocInspOrderDo;
    }
    @Override
    public UocInspOrderDo getInspOrderItemList(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        if (null == uocInspOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        UocInspOrderDo uocInspOrderDo = uocInspOrderRepository.getInspOrderItemList(uocInspOrderItemQryBo);
        log.info("验收明细查询出参2：{}", JSON.toJSONString(uocInspOrderDo));
        return uocInspOrderDo;
    }

    @Override
    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
//        if (null == uocInspOrderQryBo.getOrderId()) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID为空");
//        }
        return uocInspOrderRepository.getListInspOrder(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getInspOrderNo(UocInspOrderDo uocInspOrderDo) {
        if (null == uocInspOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocInspOrderDo.getOrderSource()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参来源不能为空");
        }
        String orderNo = uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_INSPECTION_NO + "_" + uocInspOrderDo.getOrderSource());
        uocInspOrderDo.setInspOrderNo(orderNo);
        return uocInspOrderDo;
    }

    @Override
    public UocInspOrderDo qryTotalFeeAndCount(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocInspOrderRepository.qryTotalFeeAndCount(uocInspOrderQryBo);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocInspOrderItem uocSaleOrderItem) {
        uocInspOrderRepository.modifySaleOrderItemReturningCount(uocSaleOrderItem);
    }

    private void valDo(UocInspOrderDo uocInspOrderDo) {
        if (null == uocInspOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocInspOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
    }

    @Override
    public void modifyInspOrderItemChngingCount(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderRepository.modifyInspOrderItemChngingCount(convertInspOrderDo);
    }

    @Override
    public void modifyItemChngCountRefuse(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderRepository.modifyItemChngCountRefuse(convertInspOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirm(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderRepository.modifyItemChngCountConfirm(convertInspOrderDo);
    }

    @Override
    public void modifyBatchItemInspConfirm(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderRepository.modifyBatchItemInspConfirm(convertInspOrderDo);
    }
    @Override
    public void modifyItemChngCountConfirmAdd(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderRepository.modifyItemChngCountConfirmAdd(convertInspOrderDo);
    }
    @Override
    public void modifyItemChngCountConfirmReduce(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderRepository.modifyItemChngCountConfirmReduce(convertInspOrderDo);
    }
    @Override
    public void modifyInsporderChngTotalFeeConfirm(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderRepository.modifyInsporderChngTotalFeeConfirm(convertInspOrderDo);
    }

    @Override
    public void updateInspPayStatus(UocInspOrderDo updateInspOrderDo) {
        uocInspOrderRepository.updateInspPayStatus(updateInspOrderDo);
    }

    @Override
    public void batchSyncInsp() {
        uocInspOrderRepository.batchSyncInsp();
    }
}
