package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;


@Component
public class UocInspOrderModifyRemainInspCountTransaction {
    
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocInspOrderModifyRemainInspCountRspBo modifyCount(UocInspOrderModifyRemainInspCountReqBo reqBo) {
        UocInspOrderModifyRemainInspCountRspBo rspBo = UocRu.success(UocInspOrderModifyRemainInspCountRspBo.class);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        //查询变更明细
        List<UocChngOrderItemObj> uocChngOrderItemObjList = getListChngOrderItemObj(reqBo);
        Map<Integer, List<UocChngOrderItemObj>> chngItems = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngType));
        
        List<UocChngOrderItemObj> uocChngNums = chngItems.get(UocConstant.BUSI_TYPE.NUM);
        
        //数量变更
        if (!CollectionUtil.isEmpty(uocChngNums)) {
            
            refuse(reqBo, operId, now, uocChngNums);
        }
        
        //封装出参对象 (查询销售单明细 ，验收单明细)
        buildSyncRsp(reqBo, rspBo, uocChngOrderItemObjList);
        return rspBo;
    }
    
    /**
     * 处理拒绝
     *
     * @param reqBo
     * @param operId
     * @param now
     * @param uocChngOrderItemObjList
     */
    private void refuse(UocInspOrderModifyRemainInspCountReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        iUocSaleOrderModel.modifyItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        // 验收单明细异常变更数量更新为0
        iUocInspOrderModel.modifyItemChngCountRefuse(convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }
    
    
    /**
     * 查询验收单信息信息
     *
     * @param reqBo
     * @param now
     * @param operId
     * @param uocChngOrderItemObjList
     * @return
     */
    private UocInspOrderDo convertInspOrderDo(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList()));
        uocInspOrderDo.setOrderIdList(orderIdList);
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }
    
    /**
     * 查询执行单信息
     */
    private UocSaleOrderDo convertSaleOrderDo(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }
    
    
    /**
     * 查询变更对象明细信息
     */
    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocInspOrderModifyRemainInspCountReqBo reqBo) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
        }
        return uocChngOrderItemObjList;
    }
    
    private void buildSyncRsp(UocInspOrderModifyRemainInspCountReqBo reqBo, UocInspOrderModifyRemainInspCountRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> inspOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList());
        List<Long> shipOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList());
        
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.setSaleOrderItemList(UocRu.jsl(saleOrderItemList, UocSaleOrderItemBO.class));
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIds);
        List<UocShipOrderItem> shipOrderItemList = iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        rspBo.getShipOrderIdList().addAll(shipOrderItemList.stream().map(x -> x.getShipOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspOrderItemIds);
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        
        Map<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingBy(UocInspOrderItem::getInspOrderId));
        rspBo.setInspOrderIdLists(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "").distinct().collect(Collectors.toList()));
        rspBo.getInspOrderIdList().addAll(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        
        reqBo.getChngOrderList().forEach(x -> {
            rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId());
        });
        
        List<UocInspOrderDo> inspOrderDoList = new ArrayList<>();
        List<Long> inspOrderIdList = uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getInspOrderId).distinct().collect(Collectors.toList());
        
        for (Long inspOrderId : inspOrderIdList) {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setInspOrderId(Long.valueOf(inspOrderId));
            uocInspOrderDo = iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            
            uocInspOrderDo.setUocInspOrderItemList(inspOrderMap.get(inspOrderId));
            inspOrderDoList.add(uocInspOrderDo);
        }
        
        List<Long> saleOrderIdList = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderId).distinct().collect(Collectors.toList());
        
        List<UocSaleOrderDo> saleOrderDoList = new ArrayList<>();
        for (Long saleOrderId : saleOrderIdList) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setSaleOrderId(Long.valueOf(saleOrderId));
            UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            
            saleOrderDoList.add(uocSaleOrderDo);
        }
        rspBo.setInspOrderBoList(UocRu.jsl(inspOrderDoList, UocInspOrderBo.class));
        rspBo.setSaleOrderBOList(UocRu.jsl(saleOrderDoList, UocSaleOrderBO.class));
    }

    
    private UocShipOrderDo convertShipOrderDo(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
        uocShipOrderDo.setOrderIdList(orderIdList);
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        return uocShipOrderDo;
    }
    
    
}


