/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdInvoiceQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderCheckAccountQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncInsp
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncInsp.class);
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    private static final String ES_INSP_ORDER_ITEM_KEY = "uocInspOrderItemList";
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Value(value="${uoc.syncinsp.putInspSource:true}")
    private boolean putInspSource;
    private static final String ES_INSP_ORDER_ACCESSORY_KEY = "inspAccessoryList";

    @Override
    public String indexName() {
        return this.uocIndexConfig.getInspOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderDo inspOderItem;
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocInspOrderDo inspOrderMain = this.getInspOrderMain(reqBo);
        if (null == inspOrderMain) {
            return iUocEsSyncQryRspBo;
        }
        inspOrderMain.setCheckState(this.qryCheckState(reqBo, inspOrderMain));
        JSONObject inspOrderJson = JSON.parseObject((String)JSON.toJSONString((Object)inspOrderMain));
        try {
            inspOrderJson.put("totalSaleFeeLong", (Object)UocMoneyUtil.bigDecimal2Long(inspOrderMain.getTotalSaleFee()));
            inspOrderJson.put("totalPurchaseFeeLong", (Object)UocMoneyUtil.bigDecimal2Long(inspOrderMain.getTotalPurchaseFee()));
        }
        catch (Exception e) {
            log.debug("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff01");
        }
        if (!CollectionUtils.isEmpty(inspOrderMain.getExtParallelBoList())) {
            inspOrderMain.getExtParallelBoList().forEach(uocInspOrderMap -> inspOrderJson.put(uocInspOrderMap.getFieldCode(), (Object)uocInspOrderMap.getFieldValue()));
        }
        if (!CollectionUtils.isEmpty((inspOderItem = this.getInspOderItem(inspOrderMain)).getUocInspOrderItemList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = this.getSaleItem(inspOrderMain);
            Map<Long, UocShipOrderItem> shipOrderItemMap = this.getListShipOrderItem(inspOderItem);
            JSONArray inspOrdeItemArray = new JSONArray();
            BigDecimal inspSaleMoney = BigDecimal.ZERO;
            BigDecimal inspPurchaseMoney = BigDecimal.ZERO;
            for (UocInspOrderItem uocInspOrderItem : inspOderItem.getUocInspOrderItemList()) {
                JSONObject inspOrderItemJson = JSON.parseObject((String)JSON.toJSONString((Object)uocInspOrderItem));
                if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                    uocInspOrderItem.getItemExtParallelBoList().forEach(uocInspItemMap -> inspOrderItemJson.put(uocInspItemMap.getFieldCode(), (Object)uocInspItemMap.getFieldValue()));
                }
                UocSaleOrderItem uocSaleOrderItem = saleItemMap.get(uocInspOrderItem.getSaleOrderItemId());
                this.putSaleItem(inspOrderItemJson, uocSaleOrderItem);
                if (null != uocSaleOrderItem && null != uocSaleOrderItem.getSalePrice() && null != uocSaleOrderItem.getPurchaseCount()) {
                    BigDecimal inspPurFee = uocSaleOrderItem.getSalePrice().multiply(uocInspOrderItem.getInspCount());
                    inspOrderItemJson.put("inspSaleMoney", (Object)inspPurFee);
                    inspSaleMoney = inspSaleMoney.add(inspPurFee);
                }
                if (null != uocSaleOrderItem && null != uocSaleOrderItem.getPurchasePrice() && null != uocSaleOrderItem.getPurchaseCount()) {
                    BigDecimal inspSalFee = uocSaleOrderItem.getPurchasePrice().multiply(uocInspOrderItem.getInspCount());
                    inspOrderItemJson.put("inspPurchaseMoney", (Object)inspSalFee);
                    inspPurchaseMoney = inspPurchaseMoney.add(inspSalFee);
                }
                this.putShipItem(inspOrderItemJson, shipOrderItemMap.get(uocInspOrderItem.getShipOrderItemId()));
                inspOrdeItemArray.add((Object)inspOrderItemJson);
            }
            inspOrderJson.put(ES_INSP_ORDER_ITEM_KEY, (Object)inspOrdeItemArray);
            inspOrderJson.put("inspSaleMoney", (Object)inspSaleMoney);
            inspOrderJson.put("inspPurchaseMoney", (Object)inspPurchaseMoney);
            inspOrderJson.put("inspOrderAccessoryList", inspOrderMain.getUocOrderAccessoryList());
        }
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        accessoryQryBo.setObjId(inspOrderMain.getInspOrderId());
        List<UocOrderAccessory> accessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            inspOrderJson.put(ES_INSP_ORDER_ACCESSORY_KEY, (Object)JSONArray.parseArray((String)JSON.toJSONString(accessoryList)));
        }
        Map<String, Map<String, String>> dicMap = this.getDic();
        UocSaleOrderDo saleOrder = this.getSaleOrder(inspOrderMain);
        UocOrderDo uocOrderDo = this.getUocOrderDo(inspOrderMain);
        this.putSaleOrder(inspOrderMain, inspOrderJson, saleOrder, dicMap);
        this.putOrder(inspOrderJson, uocOrderDo, dicMap);
        this.putShipOrder(inspOrderMain, inspOrderJson);
        this.putOrderRel(reqBo, inspOrderJson, saleOrder, dicMap);
        this.putOrderShouldPay(reqBo, inspOrderJson);
        this.putStr(inspOrderJson, inspOrderMain, dicMap);
        this.putInvoice(inspOrderJson, reqBo);
        this.putChngFlag(inspOrderJson, reqBo);
        this.putReceiverAddressBo(inspOrderJson, uocOrderDo);
        iUocEsSyncQryRspBo.setJsonObj(inspOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private void putReceiverAddressBo(JSONObject inspOrderJson, UocOrderDo uocOrderDo) {
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(uocOrderDo.getOrderId());
        relaQryBo.setContactId(uocOrderDo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        inspOrderJson.put("receiverAddressBO", (Object)uocOrdLogisticsRela);
    }

    private void putChngFlag(JSONObject inspOrderJson, IUocEsSyncQryReqBo reqBo) {
        String flag = "false";
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderItemQryBo.setInspOrderId(reqBo.getObjId());
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        if (ObjectUtil.isNotEmpty((Object)uocInspOrderDo) && ObjectUtil.isNotEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
            for (UocInspOrderItem uocInspOrderItem : uocInspOrderDo.getUocInspOrderItemList()) {
                if (uocInspOrderItem.getChngingCount().compareTo(BigDecimal.ZERO) <= 0) continue;
                flag = "true";
                break;
            }
        }
        inspOrderJson.put("inspChngFlag", (Object)flag);
    }

    private void putInvoice(JSONObject inspOrderJson, IUocEsSyncQryReqBo reqBo) {
        UocOrdInvoiceQryBo uocOrdInvoiceQryBo = new UocOrdInvoiceQryBo();
        uocOrdInvoiceQryBo.setOrderId(reqBo.getOrderId());
        UocOrdInvoice uocOrdInvoice = this.iUocOrderModel.qryOrderInvoice(uocOrdInvoiceQryBo);
        inspOrderJson.put("invoice", (Object)uocOrdInvoice);
        if (null != uocOrdInvoice) {
            inspOrderJson.put("buyerName", (Object)uocOrdInvoice.getBuyerName());
        }
    }

    private void putOrderShouldPay(IUocEsSyncQryReqBo reqBo, JSONObject inspOrderJson) {
        List<UocOrderShouldPay> orderShouldPayList = this.getOrderShouldPayList(reqBo);
        if (ObjectUtil.isNotEmpty(orderShouldPayList)) {
            UocOrderShouldPay shouldPay = orderShouldPayList.get(0);
            inspOrderJson.put("payeeId", (Object)shouldPay.getPayeeId());
            inspOrderJson.put("payeeName", (Object)shouldPay.getPayeeName());
        }
    }

    private void putSaleOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        inspOrderJson.put("inspOrderId", (Object)inspOrderMain.getInspOrderId().toString());
        if (null != saleOrder) {
            List<UocSaleOrderMap> saleOrderMapList;
            inspOrderJson.put("payState", (Object)saleOrder.getPayState());
            inspOrderJson.put("orderSource", (Object)saleOrder.getOrderSource().toString());
            inspOrderJson.put("orderCreateOperId", (Object)saleOrder.getCreateOperId());
            inspOrderJson.put("orderCreateOperName", (Object)saleOrder.getCreateOperName());
            inspOrderJson.put("orderCreateLoginName", (Object)saleOrder.getStakeholder().getPurUserName());
            inspOrderJson.put("orderCreateTime", (Object)saleOrder.getCreateTime());
            inspOrderJson.put("saleOrderNo", (Object)saleOrder.getSaleOrderNo());
            inspOrderJson.put("saleOrderNoExt", (Object)saleOrder.getSaleOrderNoExt());
            inspOrderJson.put("modelSettle", (Object)saleOrder.getModelSettle());
            inspOrderJson.put("agreementId", (Object)saleOrder.getAgreementId());
            inspOrderJson.put("agreementCode", (Object)saleOrder.getAgreementNo());
            IUocEsSyncQryReqBo iUocEsSyncQryReqBo = new IUocEsSyncQryReqBo();
            iUocEsSyncQryReqBo.setOrderId(saleOrder.getOrderId());
            iUocEsSyncQryReqBo.setObjId(saleOrder.getSaleOrderId());
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = this.getProcInst(iUocEsSyncQryReqBo, false, UocDicConstant.OBJ_TYPE.SALE);
            UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrder.getOrderSource()) ? this.getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.ORDER) : this.getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.SALE);
            inspOrderJson.put("busiProcInstId", (Object)busiProcInst.getProcInstId());
            inspOrderJson.put("saleOrderState", (Object)saleOrder.getSaleOrderState());
            inspOrderJson.put("auditProcInstId", (Object)auditProcInst.getProcInstId());
            if (null != saleOrder.getOrderSource()) {
                inspOrderJson.put("orderSourceStr", (Object)dicMap.get("UOC_SALE_ORDER_SOURCE").get(saleOrder.getOrderSource().toString()));
            }
            if (null != saleOrder.getModelSettle()) {
                inspOrderJson.put("modelSettleStr", (Object)dicMap.get("UOC_COMMON_MODEL_SETTLE").get(saleOrder.getModelSettle().toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)saleOrder.getPayType())) {
                inspOrderJson.put("payTypeStr", (Object)dicMap.get("UOC_INSP_ORDER_PAY_TYPE").get(saleOrder.getPayType()));
            }
            if (null != saleOrder.getPayState()) {
                inspOrderJson.put("payStateStr", (Object)dicMap.get("UOC_SALE_ORDER_PAY_STATE").get(saleOrder.getPayState().toString()));
            }
            if (null != saleOrder.getSaleOrderState()) {
                inspOrderJson.put("saleOrderStateStr", (Object)dicMap.get("UOC_PRO_CNNG_ORDER_STATUS").get(saleOrder.getSaleOrderState().toString()));
            }
            if (null != (saleOrderMapList = this.getSaleOrderMapList(saleOrder))) {
                saleOrderMapList.forEach(each -> inspOrderJson.put(each.getFieldCode(), (Object)each.getFieldValue()));
            }
            if (this.putInspSource) {
                if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
                    Map<String, String> saleExtMap = saleOrderMapList.stream().collect(Collectors.toMap(item -> item.getFieldCode(), item -> item.getFieldValue()));
                    String itAgrOrderCode = saleExtMap.get("itAgrOrderCode");
                    if ("1".equals(itAgrOrderCode)) {
                        inspOrderJson.put("acceptSource", (Object)"1");
                        inspOrderJson.put("acceptSourceStr", (Object)"IT\u5de5\u4f5c\u53f0");
                    } else {
                        inspOrderJson.put("acceptSource", (Object)"0");
                        inspOrderJson.put("acceptSourceStr", (Object)"\u5546\u57ce");
                    }
                } else {
                    inspOrderJson.put("acceptSource", (Object)"0");
                    inspOrderJson.put("acceptSourceStr", (Object)"\u5546\u57ce");
                }
            }
            this.putSaleStakeholder(saleOrder, inspOrderJson);
            this.putOrderAgreement(inspOrderJson, saleOrder, dicMap);
            this.putSalePayConf(inspOrderJson, saleOrder, dicMap);
        }
    }

    private void putOrder(JSONObject inspOrderJson, UocOrderDo orderDo, Map<String, Map<String, String>> dicMap) {
        if (StringUtils.isNotEmpty((CharSequence)orderDo.getUserType()) && Objects.nonNull(dicMap.get("ORDER_CREATE_USE_TYPE"))) {
            inspOrderJson.put("orderCreateUserType", (Object)orderDo.getUserType());
            inspOrderJson.put("orderCreateUserTypeStr", (Object)dicMap.get("ORDER_CREATE_USE_TYPE").get(orderDo.getUserType()));
        }
    }

    private void putOrderAgreement(JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        List<UocOrderAgreement> agreementList = this.getOrderAgreement(saleOrder);
        if (ObjectUtil.isNotEmpty(agreementList)) {
            inspOrderJson.put("tradeMode", (Object)agreementList.get(0).getTradeMode());
            if (null != agreementList.get(0).getTradeMode()) {
                inspOrderJson.put("tradeModeStr", (Object)dicMap.get("TRADE_MODE").get(agreementList.get(0).getTradeMode().toString()));
            }
        }
    }

    private List<UocOrderAgreement> getOrderAgreement(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo agreementQryBo = new UocOrderAgreementQryBo();
        agreementQryBo.setOrderId(saleOrder.getOrderId());
        agreementQryBo.setId(saleOrder.getAgrDataId());
        return this.iUocSaleOrderModel.getAgreementOrderList(agreementQryBo);
    }

    private List<UocSaleOrderMap> getSaleOrderMapList(UocSaleOrderDo reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        return this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    private void putSalePayConf(JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        List<UocSaleOrderPayConf> payConfList = this.getPayConfList(saleOrder);
        if (ObjectUtil.isNotEmpty(payConfList)) {
            for (UocSaleOrderPayConf uocSaleOrderPayConf : payConfList) {
                if (UocDicConstant.PAY_CONF_USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType())) {
                    this.putPayConfPurchase(inspOrderJson, dicMap, uocSaleOrderPayConf);
                }
                if (!UocDicConstant.PAY_CONF_USE_TYPE.PRO.equals(uocSaleOrderPayConf.getUserType())) continue;
                this.putPayConfPro(inspOrderJson, dicMap, uocSaleOrderPayConf);
            }
        }
    }

    private void putPayConfPurchase(JSONObject inspOrderJson, Map<String, Map<String, String>> dicMap, UocSaleOrderPayConf payConf) {
        inspOrderJson.put("payType", (Object)payConf.getPayType());
        inspOrderJson.put("payBreakScale", (Object)payConf.getPayBreakScale());
        inspOrderJson.put("paymentDays", (Object)payConf.getPaymentDays());
        inspOrderJson.put("payRule", (Object)payConf.getPayRule());
        inspOrderJson.put("payAccountDayRule", (Object)payConf.getPayAccountDayRule());
        inspOrderJson.put("payAccountDay", (Object)payConf.getPayAccountDay());
        inspOrderJson.put("payNodeRule", (Object)payConf.getPayNodeRule());
        if (null != payConf.getPayRule()) {
            inspOrderJson.put("payRuleStr", (Object)dicMap.get("PAY_RULE").get(payConf.getPayRule().toString()));
        }
        if (null != payConf.getPayAccountDayRule()) {
            inspOrderJson.put("payAccountDayRuleStr", (Object)dicMap.get("PAY_ACCOUNT_DAY_RULE").get(payConf.getPayAccountDayRule().toString()));
        }
        if (null != payConf.getPayNodeRule()) {
            inspOrderJson.put("payNodeRuleStr", (Object)dicMap.get("PAY_NODE_RULE").get(payConf.getPayNodeRule().toString()));
        }
    }

    private void putPayConfPro(JSONObject inspOrderJson, Map<String, Map<String, String>> dicMap, UocSaleOrderPayConf payConf) {
        inspOrderJson.put("proPayType", (Object)payConf.getPayType());
        inspOrderJson.put("proPayBreakScale", (Object)payConf.getPayBreakScale());
        inspOrderJson.put("proPaymentDays", (Object)payConf.getPaymentDays());
        inspOrderJson.put("proPayRule", (Object)payConf.getPayRule());
        inspOrderJson.put("proPayAccountDayRule", (Object)payConf.getPayAccountDayRule());
        inspOrderJson.put("proPayAccountDay", (Object)payConf.getPayAccountDay());
        inspOrderJson.put("proPayNodeRule", (Object)payConf.getPayNodeRule());
        if (null != payConf.getPayRule()) {
            inspOrderJson.put("proPayRuleStr", (Object)dicMap.get("PAY_RULE").get(payConf.getPayRule().toString()));
        }
        if (null != payConf.getPayAccountDayRule()) {
            inspOrderJson.put("proPayAccountDayRuleStr", (Object)dicMap.get("PAY_ACCOUNT_DAY_RULE").get(payConf.getPayAccountDayRule().toString()));
        }
        if (null != payConf.getPayNodeRule()) {
            inspOrderJson.put("proPayNodeRuleStr", (Object)dicMap.get("PAY_NODE_RULE").get(payConf.getPayNodeRule().toString()));
        }
    }

    private List<UocSaleOrderPayConf> getPayConfList(UocSaleOrderDo saleOrder) {
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setSaleOrderId(saleOrder.getSaleOrderId());
        payConfQryBo.setOrderId(saleOrder.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
    }

    private List<UocOrderShouldPay> getOrderShouldPayList(IUocEsSyncQryReqBo reqBo) {
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setOrderId(reqBo.getOrderId());
        uocOrderShouldPay.setObjectId(reqBo.getObjId());
        uocOrderShouldPay.setObjectType(UocDicConstant.OBJ_TYPE.INSPECTION);
        return this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
    }

    private void putOrderRel(IUocEsSyncQryReqBo reqBo, JSONObject inspOrderJson, UocSaleOrderDo saleOrder, Map<String, Map<String, String>> dicMap) {
        if (null != saleOrder) {
            List<UocOrderRel> relInfoList = this.getUocRelInfo(reqBo);
            if (UocConstant.ModelSettle.MY.equals(saleOrder.getModelSettle()) && CollectionUtils.isEmpty(relInfoList)) {
                relInfoList = new ArrayList<UocOrderRel>();
                this.addRelInfo(reqBo, relInfoList, UocDicConstant.REL_TYPE.COMMON_INVOICE);
                this.addRelInfo(reqBo, relInfoList, UocDicConstant.REL_TYPE.UP_INVOICE);
            }
            if (UocConstant.ModelSettle.CH.equals(saleOrder.getModelSettle()) && CollectionUtils.isEmpty(relInfoList)) {
                relInfoList = new ArrayList<UocOrderRel>();
                this.addRelInfo(reqBo, relInfoList, UocDicConstant.REL_TYPE.CH_INVOICE);
            }
            ArrayList<String> relId = new ArrayList<String>();
            ArrayList<String> relInfo = new ArrayList<String>();
            Map<String, String> statusMap = dicMap.get("UOC_ORDER_REL_STATUS");
            for (UocOrderRel uocOrderRel : relInfoList) {
                if (null != uocOrderRel.getRelId()) {
                    relId.add(uocOrderRel.getRelId());
                }
                if (null != uocOrderRel.getRelStatus()) {
                    uocOrderRel.setRelStatusStr(statusMap.get(uocOrderRel.getRelStatus().toString()));
                }
                relInfo.add(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType());
            }
            inspOrderJson.put("relId", relId);
            inspOrderJson.put("objId", (Object)reqBo.getObjId());
            inspOrderJson.put("objType", (Object)UocDicConstant.OBJ_TYPE.INSPECTION);
            inspOrderJson.put("relType", relInfoList.stream().map(UocOrderRel::getRelType).collect(Collectors.toList()));
            inspOrderJson.put("relInfo", relInfo);
            inspOrderJson.put("fscRelInfoBos", relInfoList);
        }
    }

    private void addRelInfo(IUocEsSyncQryReqBo reqBo, List<UocOrderRel> relInfoList, Integer relType) {
        UocOrderRel uocOrderRel = new UocOrderRel();
        uocOrderRel.setOrderId(reqBo.getOrderId());
        uocOrderRel.setObjType(reqBo.getObjType());
        uocOrderRel.setRelType(relType);
        uocOrderRel.setObjId(reqBo.getObjId());
        uocOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        relInfoList.add(uocOrderRel);
    }

    private List<UocOrderRel> getUocRelInfo(IUocEsSyncQryReqBo reqBo) {
        UocOrderRelQryBo qryBo = new UocOrderRelQryBo();
        qryBo.setObjId(reqBo.getObjId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        ArrayList<Integer> relType = new ArrayList<Integer>();
        relType.add(UocDicConstant.REL_TYPE.UP_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.COMMON_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.CH_INVOICE);
        qryBo.setRelTypeList(relType);
        return this.iUocOrderModel.qryListRelInfo(qryBo);
    }

    private void putStr(JSONObject inspOrderJson, UocInspOrderDo inspOrderMain, Map<String, Map<String, String>> dicMap) {
        Map<String, String> stateMap = dicMap.get("INSP_ORDER_STATE");
        Map<String, String> checkStateMap = dicMap.get("UOC_ORD_CHECK_STATE");
        Map<String, String> invoiceTagMap = dicMap.get("UOC_ORD_INVOICE_TAG");
        inspOrderJson.put("inspOrderStateStr", (Object)(ObjectUtil.isNotEmpty(stateMap) ? stateMap.get(inspOrderMain.getInspOrderState()) : ""));
        inspOrderJson.put("checkStateStr", (Object)(ObjectUtil.isNotEmpty(checkStateMap) ? checkStateMap.get(inspOrderMain.getCheckState()) : ""));
        inspOrderJson.put("invoiceTagStr", (Object)(ObjectUtil.isNotEmpty(invoiceTagMap) ? invoiceTagMap.get(Convert.toStr((Object)inspOrderMain.getInvoiceTag())) : ""));
        inspOrderJson.put("saleOrderId", (Object)(ObjectUtil.isNotEmpty((Object)inspOrderJson.get((Object)"saleOrderId")) ? inspOrderMain.getSaleOrderId().toString() : ""));
    }

    private void putShipItem(JSONObject inspOrderItemJson, UocShipOrderItem uocShipOrderItem) {
        if (null != uocShipOrderItem) {
            inspOrderItemJson.put("sendCount", (Object)uocShipOrderItem.getSendCount());
        }
    }

    private void putSaleStakeholder(UocSaleOrderDo saleOrder, JSONObject inspOrderJson) {
        UocSaleStakeholder uocSaleStakeholder = saleOrder.getStakeholder();
        if (null != uocSaleStakeholder) {
            inspOrderJson.put("supNo", (Object)uocSaleStakeholder.getSupNo());
            inspOrderJson.put("supId", (Object)uocSaleStakeholder.getSupId());
            inspOrderJson.put("supName", (Object)uocSaleStakeholder.getSupName());
            inspOrderJson.put("purUserId", (Object)uocSaleStakeholder.getPurUserId());
            inspOrderJson.put("purOrgId", (Object)uocSaleStakeholder.getPurOrgId());
            inspOrderJson.put("purOrgName", (Object)uocSaleStakeholder.getPurOrgName());
            inspOrderJson.put("purCompanyId", (Object)uocSaleStakeholder.getPurCompanyId());
            inspOrderJson.put("purCompanyName", (Object)uocSaleStakeholder.getPurCompanyName());
            inspOrderJson.put("proId", (Object)uocSaleStakeholder.getProId());
            inspOrderJson.put("proName", (Object)uocSaleStakeholder.getProName());
            inspOrderJson.put("purAccount", (Object)uocSaleStakeholder.getPurAccount());
            inspOrderJson.put("purAccountName", (Object)uocSaleStakeholder.getPurAccountName());
            inspOrderJson.put("orderCreateLoginName", (Object)uocSaleStakeholder.getPurUserName());
            inspOrderJson.put("purOrgPath", (Object)uocSaleStakeholder.getPurOrgPath());
            inspOrderJson.put("supOrgPath", (Object)uocSaleStakeholder.getSupOrgPath());
            inspOrderJson.put("proOrgPath", (Object)uocSaleStakeholder.getProOrgPath());
        }
    }

    private void putShipOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        List<UocShipOrderDo> uocShipOrderDoList = this.getListShipOrder(inspOrderMain);
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            ArrayList shipOrderNoList = new ArrayList();
            ArrayList shipOrderIdList = new ArrayList();
            uocShipOrderDoList.forEach(uocShipOrderDo -> {
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
            });
            uocShipOrderDoList.sort(Comparator.comparing(UocShipOrderDo::getArriveTime).reversed());
            inspOrderJson.put("lastArriveTime", (Object)uocShipOrderDoList.get(0).getArriveTime());
            inspOrderJson.put("shipOrderNo", shipOrderNoList);
            inspOrderJson.put("shipOrderId", shipOrderIdList);
        }
    }

    private List<UocShipOrderDo> getListShipOrder(UocInspOrderDo uocInspOrderDo) {
        if (CollectionUtils.isEmpty(uocInspOrderDo.getUocShipInspRelList())) {
            return new ArrayList<UocShipOrderDo>();
        }
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderIdList(uocInspOrderDo.getUocShipInspRelList().stream().map(UocShipInspRel::getShipOrderId).collect(Collectors.toList()));
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private Map<Long, UocShipOrderItem> getListShipOrderItem(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getShipOrderItemId).collect(Collectors.toList()));
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            return uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        }
        return new HashMap<Long, UocShipOrderItem>();
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<Long, UocSaleOrderItem>();
    }

    private void putSaleItem(JSONObject inspOrderItemJson, UocSaleOrderItem uocSaleOrderItem) {
        if (null != uocSaleOrderItem) {
            inspOrderItemJson.put("supplierId", (Object)uocSaleOrderItem.getSupplierId());
            inspOrderItemJson.put("supplierShopId", (Object)uocSaleOrderItem.getSupplierShopId());
            inspOrderItemJson.put("skuExtSkuId", (Object)uocSaleOrderItem.getSkuExtSkuId());
            inspOrderItemJson.put("commodityId", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("commodityName", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuId", (Object)uocSaleOrderItem.getSkuId());
            inspOrderItemJson.put("skuCode", (Object)uocSaleOrderItem.getSkuCode());
            inspOrderItemJson.put("skuName", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuMaterialId", (Object)uocSaleOrderItem.getSkuMaterialId());
            inspOrderItemJson.put("skuMaterialCode", (Object)uocSaleOrderItem.getSkuMaterialCode());
            inspOrderItemJson.put("skuMainPicUrl", (Object)uocSaleOrderItem.getSkuMainPicUrl());
            inspOrderItemJson.put("skuMaterialName", (Object)uocSaleOrderItem.getSkuMaterialName());
            inspOrderItemJson.put("skuMaterialTypeId", (Object)uocSaleOrderItem.getSkuMaterialTypeId());
            inspOrderItemJson.put("skuMaterialTypeName", (Object)uocSaleOrderItem.getSkuMaterialTypeName());
            inspOrderItemJson.put("model", (Object)uocSaleOrderItem.getModel());
            inspOrderItemJson.put("spec", (Object)uocSaleOrderItem.getSpec());
            inspOrderItemJson.put("tax", (Object)uocSaleOrderItem.getTax());
            inspOrderItemJson.put("taxId", (Object)uocSaleOrderItem.getTaxId());
            inspOrderItemJson.put("taxPrice", (Object)uocSaleOrderItem.getTaxPrice());
            inspOrderItemJson.put("l1Catalog", (Object)uocSaleOrderItem.getL1Catalog());
            inspOrderItemJson.put("l1CatalogName", (Object)uocSaleOrderItem.getL1CatalogName());
            inspOrderItemJson.put("l2Catalog", (Object)uocSaleOrderItem.getL2Catalog());
            inspOrderItemJson.put("l2CatalogName", (Object)uocSaleOrderItem.getL2CatalogName());
            inspOrderItemJson.put("l3Catalog", (Object)uocSaleOrderItem.getL3Catalog());
            inspOrderItemJson.put("l3CatalogName", (Object)uocSaleOrderItem.getL3CatalogName());
            inspOrderItemJson.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
            inspOrderItemJson.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
            inspOrderItemJson.put("purchaseCount", (Object)uocSaleOrderItem.getPurchaseCount());
            inspOrderItemJson.put("settleUnit", (Object)uocSaleOrderItem.getSettleUnit());
            inspOrderItemJson.put("unitDigit", (Object)(StringUtils.isEmpty((CharSequence)uocSaleOrderItem.getUnitDigit()) ? "" : uocSaleOrderItem.getUnitDigit()));
        }
    }

    private UocInspOrderDo getInspOderItem(UocInspOrderDo inspOrderMain) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        uocInspOrderItemQryBo.setOrderId(inspOrderMain.getOrderId());
        return this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
    }

    private UocInspOrderDo getInspOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private UocOrderDo getUocOrderDo(UocInspOrderDo reqBo) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.qryOrderBy(qryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("INSP_ORDER_STATE");
        pCodes.add("UOC_ORD_CHECK_STATE");
        pCodes.add("UOC_COMMON_MODEL_SETTLE");
        pCodes.add("UOC_ORDER_OBJ_TYPE");
        pCodes.add("UOC_ORDER_REL_TYPE");
        pCodes.add("UOC_ORDER_REL_STATUS");
        pCodes.add("UOC_SALE_ORDER_SOURCE");
        pCodes.add("PAY_RULE");
        pCodes.add("PAY_ACCOUNT_DAY_RULE");
        pCodes.add("PAY_NODE_RULE");
        pCodes.add("TRADE_MODE");
        pCodes.add("UOC_INSP_ORDER_PAY_TYPE");
        pCodes.add("UOC_SALE_ORDER_PAY_STATE");
        pCodes.add("UOC_PRO_CNNG_ORDER_STATUS");
        pCodes.add("ORDER_CREATE_USE_TYPE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private String qryCheckState(IUocEsSyncQryReqBo reqBo, UocInspOrderDo inspOrderMain) {
        UocOrderCheckAccountQryBo uocOrderCheckAccountQryBo = new UocOrderCheckAccountQryBo();
        uocOrderCheckAccountQryBo.setOrderId(inspOrderMain.getSaleOrderId());
        uocOrderCheckAccountQryBo.setObjId(reqBo.getObjId());
        uocOrderCheckAccountQryBo.setObjType(reqBo.getObjType());
        UocOrderCheckAccount uocOrderCheckAccount = this.iUocOrderModel.qryCheckInfo(uocOrderCheckAccountQryBo);
        if (null == uocOrderCheckAccount) {
            return UocDicConstant.CHECK_STATE.NO_CHECK.toString();
        }
        return Convert.toStr((Object)uocOrderCheckAccount.getCheckState());
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjId(reqBo.getObjId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {
            uocApprovalObjQryBo.setObjId(reqBo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setTaskList(taskBoList);
                String procInstId = "";
                if (UocDicConstant.OBJ_TYPE.ORDER.equals(objType)) {
                    procInstId = uocOrderTaskInsts.get(0).getProcInstId();
                } else {
                    for (UocOrderTaskInst bo : uocOrderTaskInsts) {
                        if (0 != bo.getFinishTag()) continue;
                        procInstId = bo.getProcInstId();
                        break;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }
        }
        return procInst;
    }
}

