package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderStatisticReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderStatisticRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocOrderStatisticServiceImpl
 * 说明：单据统计信息查询服务
 * 时间：2022/4/1 20:38
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocOrderStatisticServiceImpl implements UocOrderStatisticService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Override
    public UocOrderStatisticRspBo qryStatisticInfo(UocOrderStatisticReqBo reqBo) {
        validateArg(reqBo);
        UocOrderStatisticRspBo success = UocRu.success(UocOrderStatisticRspBo.class);
        if (UocConstant.SearchType.SALE.equals(reqBo.getSearchType())) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setCreateTimeStart(DateUtil.parse(reqBo.getCreateTimeStart()));
            uocSaleOrderQryBo.setCreateTimeEnd(DateUtil.parse(reqBo.getCreateTimeEnd()));
            uocSaleOrderQryBo.setSupId(Convert.toLong(reqBo.getSupNo()));

            UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qryTotalFeeAndCount(uocSaleOrderQryBo);

            success.setTotalCount(uocSaleOrderDo.getTotalCount());
            success.setTotalFee(uocSaleOrderDo.getTotalFee());

        } else {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setCreateTimeStart(DateUtil.parse(reqBo.getCreateTimeStart()));
            uocInspOrderQryBo.setCreateTimeEnd(DateUtil.parse(reqBo.getCreateTimeEnd()));
            uocInspOrderQryBo.setSupId(Convert.toLong(reqBo.getSupNo()));

            UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.qryTotalFeeAndCount(uocInspOrderQryBo);

            success.setTotalCount(uocInspOrderDo.getTotalCount());
            success.setTotalFee(uocInspOrderDo.getTotalFee());

        }
        return success;
    }

    private void validateArg(UocOrderStatisticReqBo reqBo) {
        if (StringUtils.isBlank(reqBo.getSupNo())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "supNo不能为空");
        }
        if (null == reqBo.getSearchType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "searchType不能为空");
        }
        if (StringUtils.isBlank(reqBo.getCreateTimeStart())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "createTimeStart不能为空");
        }
        if (StringUtils.isBlank(reqBo.getCreateTimeEnd())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "createTimeEnd不能为空");
        }
    }
}
