/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.common.UocQryBusiCodeService;
import com.tydic.dyc.oc.service.common.bo.UocQryBusiCodeReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryBusiCodeRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.common.UocQryBusiCodeService"})
public class UocQryBusiCodeServiceImpl
implements UocQryBusiCodeService {
    private static final Logger log = LoggerFactory.getLogger(UocQryBusiCodeServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"qryBusiCode"})
    public UocQryBusiCodeRspBo qryBusiCode(@RequestBody UocQryBusiCodeReqBo reqBo) {
        UocOrderTaskInst taskInst;
        this.validateArgs(reqBo);
        UocQryBusiCodeRspBo rspBo = UocRu.success(UocQryBusiCodeRspBo.class);
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setTaskInstId(reqBo.getTaskId());
        uocOrderTaskInst.setProcInstId(reqBo.getProcInstId());
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (!ObjectUtil.isEmpty(uocOrderTaskInsts) && UocDicConstant.OBJ_TYPE.APPROVE.equals((taskInst = uocOrderTaskInsts.get(0)).getObjType()) && !ObjectUtil.isEmpty((Object)taskInst.getObjId())) {
            UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
            uocAuditOrderQryBo.setAuditOrderId(taskInst.getObjId());
            UocAuditOrderDo uocAuditOrderDo = this.iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
            if (!ObjectUtil.isEmpty((Object)uocAuditOrderDo)) {
                rspBo.setObjNo(uocAuditOrderDo.getAuditOrderCode());
            }
        }
        return rspBo;
    }

    private void validateArgs(UocQryBusiCodeReqBo uocQryBusiCodeReqBo) {
        if (null == uocQryBusiCodeReqBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocQryBusiCodeReqBo.getTaskId())) {
            throw new BaseBusinessException("102001", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

