package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationItemBO;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author DUM
 * @date 2023/8/14
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocMsgHandleQuotationServiceImpl implements UocMsgHandleQuotationService {

    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocMsgHandleQuotationRspBo dealQuotation(UocMsgHandleQuotationReqBo reqBo) {
        UocMsgHandleQuotationRspBo rspBo = UocRu.success(UocMsgHandleQuotationRspBo.class);
        //校验
        validateBo(reqBo);
        //对象转换、计算小计、总计
        UocBargainingQuotationDo uocBargainingQuotationDo =assembleUpdateQuotationDo(reqBo);
        log.info("处理报价单-更新报价入参：{}", JSON.toJSONString(uocBargainingQuotationDo));
        // 更新报价明细
        uocBargainingModel.updateQuotationItemWithSkuId(uocBargainingQuotationDo);
        //更新报价
        uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
        //更新议价单主单状态,更新议价单明细信息
        UocBargainingDo uocBargainingDo = assembleUpdateBargainingDo(uocBargainingQuotationDo);
        log.info("处理报价单-更新议价入参：{}", JSON.toJSONString(uocBargainingDo));
        uocBargainingModel.updateBargaining(uocBargainingDo);
        // 更新报价明细
        uocBargainingModel.updateBargainingItemConfirmedPrice(uocBargainingDo);
        //记录操作动作
        insertProgressRecord(uocBargainingQuotationDo);
        //出参
        rspBo.setBargainingId(uocBargainingQuotationDo.getBargainingId());
        rspBo.setTaskId(getTaskInstId(uocBargainingQuotationDo));
        return rspBo;
    }
    /**
     * 转换对象
     **/
    private UocBargainingQuotationDo assembleUpdateQuotationDo(UocMsgHandleQuotationReqBo reqBo) {
        UocBargainingQuotationBo qryBargainingQuotationBo = new UocBargainingQuotationBo();
        qryBargainingQuotationBo.setQuotationId(Long.valueOf(reqBo.getThirdApplyId()));
        //报价时间大于等于当前时间可报价
        qryBargainingQuotationBo.setQuotationExpiryTimeStart(new Date());
        UocBargainingQuotationBo quotationBo = uocBargainingModel.getQuotationBy(qryBargainingQuotationBo);
        if (quotationBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "报价单信息不存在已达到截止报价时间");
        }
        /**
         * 描述：为了测试，模拟数据
         * TODO DUM 测试模拟数据 begain -->
         **/
        /*UocBargainingItemQryBo uocBargainingItemQryBo = new UocBargainingItemQryBo();
        uocBargainingItemQryBo.setBargainingId(quotationBo.getBargainingId());
        List<UocBargainingItem>  tempItemList =uocBargainingModel.qryBargainingItemList(uocBargainingItemQryBo);
        List<UocMsgHandleQuotationItemBO> skuInfoList= new ArrayList<>();
        for (UocBargainingItem bargainingItem: tempItemList) {
            UocMsgHandleQuotationItemBO item = new UocMsgHandleQuotationItemBO();
            item.setSkuId(bargainingItem.getSkuId());
            item.setThirdSkuUid(bargainingItem.getExtSkuId());
            item.setConfirmedPrice(bargainingItem.getPurchasePrice().multiply(new BigDecimal("0.5")).setScale(2, RoundingMode.HALF_UP));
            item.setSkuName("【测试数据价格1/2 】"+bargainingItem.getSkuName());
            item.setSkuNum(bargainingItem.getPurchaseCount().intValue());
            item.setConfirmedBrandName("【测试数据】品牌名");
            item.setConfirmedModel("【测试数据】报价型号");
            if(ObjectUtil.isNotEmpty(bargainingItem.getTaxPrice())){
                item.setTaxPrice(new BigDecimal(bargainingItem.getTaxPrice()));
            }else {
                item.setTaxPrice(new BigDecimal(0));
            }
            item.setTaxRate(bargainingItem.getTax());
            item.setNakedPrice(new BigDecimal(0));
            item.setGreenFlag(1);
            item.setGreenFlagDesc("GreenFlagDesc字段");
            item.setMicroCompanyFlag(2);
            item.setMicroCompanyFlagDesc("MicroCompanyFlagDesc-123");
            skuInfoList.add(item);
        }
        reqBo.setSkuInfoList(skuInfoList);*/
        /**
         * 描述：为了测试，模拟数据
         * TODO DUM 测试模拟数据   <-- end
         **/
        //对象转换、计算小计、总计
        UocBargainingQuotationDo bargainingQuotationDo = new UocBargainingQuotationDo();
        //变更状态”已报价“
        bargainingQuotationDo.setQuotationStatus(UocStateConstants.BARGAINING_QUOTATION_STATES.BJ_YBJ);
        bargainingQuotationDo.setBargainingId(quotationBo.getBargainingId());
        //报价时间（接口无返回，取报价系统时间）
        bargainingQuotationDo.setQuotationTime(new Date());
        //议价前金额相关计算
        BigDecimal totalOriginalPrice = quotationBo.getTotalOriginalPrice();
        //报价总金额
        BigDecimal totalConfirmedPrice = new BigDecimal(0);
        //总价折扣率
        BigDecimal totalDiscountRate = new BigDecimal(0);
        //以下回传议价ID
        bargainingQuotationDo.setQuotationId(Long.valueOf(reqBo.getThirdApplyId()));
        bargainingQuotationDo.setBiddingCode(reqBo.getBiddingCode());
        bargainingQuotationDo.setBiddingStatus(reqBo.getBiddingStatus());
        bargainingQuotationDo.setOrderDeadLine(reqBo.getOrderDeadLine());
        List<UocMsgHandleQuotationItemBO> skuItem = reqBo.getSkuInfoList();
        List<UocBargainingQuotationItem> quotationItemList = new ArrayList<>();
        bargainingQuotationDo.setBargainingQuotationItems(quotationItemList);
        for (UocMsgHandleQuotationItemBO skuBo : skuItem) {
            UocBargainingQuotationItem item = new UocBargainingQuotationItem();
            item.setQuotationId(bargainingQuotationDo.getQuotationId());
            item.setSkuId(Long.valueOf(skuBo.getThirdSkuUid()));//接口规范三方Sku(交行skuId)
            item.setExtSkuId(skuBo.getSkuId());//接口规范电商sku(交行ExtSkuId)
            item.setConfirmedPrice(skuBo.getConfirmedPrice());
            item.setSkuName(skuBo.getSkuName());
            item.setSkuNum(skuBo.getSkuNum());
            item.setConfirmedBrandName(skuBo.getConfirmedBrandName());
            item.setConfirmedModel(skuBo.getConfirmedModel());
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setTaxRate(skuBo.getTaxRate());
            item.setNakedPrice(skuBo.getNakedPrice());
            item.setGreenFlag(skuBo.getGreenFlag());
            item.setGreenFlagDesc(skuBo.getGreenFlagDesc());
            item.setMicroCompanyFlag(skuBo.getMicroCompanyFlag());
            item.setMicroCompanyFlagDesc(skuBo.getMicroCompanyFlagDesc());
            //计算-小计金额
            BigDecimal confirmedPriceSub = skuBo.getConfirmedPrice().multiply(new BigDecimal(skuBo.getSkuNum().intValue()));
            item.setConfirmedPriceSub(confirmedPriceSub); //设置报价小计
            //计算合计
            totalConfirmedPrice = totalConfirmedPrice.add(confirmedPriceSub);
            quotationItemList.add(item);
        }
        //计算 节省金额
        BigDecimal savedPrice = totalOriginalPrice.subtract(totalConfirmedPrice);
        bargainingQuotationDo.setTotalConfirmedPrice(totalConfirmedPrice);
        bargainingQuotationDo.setSavedPrice(savedPrice);
        totalDiscountRate = totalConfirmedPrice.divide(totalOriginalPrice, 2, BigDecimal.ROUND_HALF_UP);
        bargainingQuotationDo.setTotalDiscountRate(totalDiscountRate);
        return bargainingQuotationDo;
    }

    /**
     * 转换对象
     **/
    private UocBargainingDo assembleUpdateBargainingDo(UocBargainingQuotationDo quotationDo) {
        UocBargainingDo uocBargainingDo =new UocBargainingDo();
        //变更状态”已报价“
        uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_YBJ);
        uocBargainingDo.setTotalConfirmedPrice(quotationDo.getTotalConfirmedPrice());
        uocBargainingDo.setTotalDiscountRate(quotationDo.getTotalDiscountRate());
        uocBargainingDo.setBargainingId(quotationDo.getBargainingId());
        //对象转换
        List<UocBargainingQuotationItem> skuItem = quotationDo.getBargainingQuotationItems();
        List<UocBargainingItem> bargainingItemList = new ArrayList<>();
        uocBargainingDo.setBargainingItems(bargainingItemList);
        for (UocBargainingQuotationItem skuBo : skuItem) {
            UocBargainingItem item = new UocBargainingItem();
            item.setSkuId(skuBo.getSkuId());
            item.setConfirmedPrice(skuBo.getConfirmedPrice());
            item.setConfirmedPriceSub(skuBo.getConfirmedPriceSub()); //设置报价小计
            bargainingItemList.add(item);
        }
        return uocBargainingDo;
    }

    /**
     * 参数校验
     */
    private void validateBo(UocMsgHandleQuotationReqBo quotationReqBo) {
        if (quotationReqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(quotationReqBo.getThirdApplyId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[议价单ID]不能为空");
        }
        List<UocMsgHandleQuotationItemBO> quotationItems = quotationReqBo.getSkuInfoList();
        if (ObjectUtil.isEmpty(quotationItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细]不能为空");
        }
        for (UocMsgHandleQuotationItemBO quotationItemBO : quotationItems) {
            if (ObjectUtil.isEmpty(quotationItemBO.getThirdSkuUid())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细行号（SkuID）]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getSkuId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细单品ID]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getConfirmedPrice())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细-报价]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getSkuName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SkuName]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getSkuNum())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SkuNum]不能为空");
            }
        }
    }

    /**
     * 计算（小计/合计/差异率）
     */
    private void calculateTotal(UocBargainingQuotationDo quotationDo) {

    }


    private String getTaskInstId(UocBargainingQuotationDo quotationDo) {
        String taskId ="";
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(quotationDo.getBargainingId());
        taskInstQryBo.setObjId(quotationDo.getBargainingId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isEmpty(taskInsts)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "议价单报价业务失败：未查询到任务表信息!");
        }
        taskInsts = taskInsts.stream().sorted(Comparator.comparing(UocOrderTaskInst::getCreateTime).reversed()).collect(Collectors.toList());
        log.info("议价流程流程数据：{}", JSON.toJSONString(taskInsts));
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            taskId = taskInsts.get(0).getTaskInstId();
        }
        return taskId;
    }

    /**
     * 记录操作动作
     * @param quotationDo
     */
    private void insertProgressRecord(UocBargainingQuotationDo quotationDo){
        //记录操作记录
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(quotationDo.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CANCEL);
        recordDo.setOperTypeName("报价完成");
        recordDo.setOperId(1111l);
        recordDo.setOperName("自动任务");
        recordDo.setOperTime(new Date());
        uocBargainingModel.insertProgressRecord(recordDo);
    }
}
