package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.transactionservice.UocCancelSaleOrderTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocCancelSaleOrderServiceImpl
 * 说明:销售单取消(作废)
 * 时间:2022/2/25 10:33
 * 作者:田坤林
 */
@Slf4j
@HTServiceImpl
public class UocCancelSaleOrderServiceImpl implements UocCancelSaleOrderService {

	@Autowired
	private UocCancelSaleOrderTransaction uocCancelSaleOrderTransaction;
	@Autowired
	private UocThreadPool uocThreadPool;
	@Autowired
	private UocIndexConfig uocIndexConfig;

	@Override
	public UocCancelSaleOrderServiceRspBo cancelSaleOrder(UocCancelSaleOrderServiceReqBo reqBo) {
		UocCancelSaleOrderServiceRspBo rspBo = uocCancelSaleOrderTransaction.cancelSaleOrder(reqBo);
		if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
			//本地线程同步es
			syncEs(reqBo, rspBo);
		}
		return rspBo;
	}
	private void syncEs(UocCancelSaleOrderServiceReqBo reqBo, UocCancelSaleOrderServiceRspBo rspBo) {
		List<SyncEsRunnableBo> list = new ArrayList<>();
		SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
		orderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
		orderBo.setOrderId(reqBo.getOrderId());
		orderBo.setObjId(reqBo.getSaleOrderId());
		orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
		list.add(orderBo);

		uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
	}

}
