package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocCancelSaleOrderConfirmOrRefuseTransaction;
import com.tydic.dyc.oc.transactionservice.UocInspOrderModifyRemainInspCountTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;


@HTServiceImpl
public class UocInspOrderModifyRemainInspCountServiceImpl implements UocInspOrderModifyRemainInspCountService {

    @Autowired
    private UocInspOrderModifyRemainInspCountTransaction uocInspOrderModifyRemainInspCountTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    
    @Override
    public UocInspOrderModifyRemainInspCountRspBo modifyCount(UocInspOrderModifyRemainInspCountReqBo reqBo) {
        UocInspOrderModifyRemainInspCountRspBo rspBo = uocInspOrderModifyRemainInspCountTransaction.modifyCount(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }
    
    private void syncEs(UocInspOrderModifyRemainInspCountReqBo reqBo, UocInspOrderModifyRemainInspCountRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        //同步变更单
        for (UocChngOrderConfirmOrRefuseReqItemBo uocChngOrderConfirmOrRefuseReqItemBo : reqBo.getChngOrderList()) {
            SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
            chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
            chngBo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            chngBo.setObjId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(chngBo);
        }
        
        //同步销售单
        List<String> saleOrderIdList = rspBo.getSaleOrderIdList();
        for (String saleOrderId : saleOrderIdList) {
            String[] split = saleOrderId.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }
        
        //同步验收单
        List<String> inspOrderIdList = rspBo.getInspOrderIdList();
        for (String inspOrderId : inspOrderIdList) {
            String[] split = inspOrderId.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(uocIndexConfig.getInspOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }
        
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
    

}
