package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemRspBo;
import com.tydic.dyc.oc.transactionservice.UocArrvaITAcceptanceByNoItemTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocReceiveItInspOrderNoItemServiceImpl
 * 说明:
 * 时间:2023/8/31 14:35
 * 作者:dum
 */
@Slf4j
@HTServiceImpl
public class UocReceiveItInspOrderNoItemServiceImpl implements  UocReceiveItInspOrderNoItemService{
    @Autowired
    private UocArrvaITAcceptanceByNoItemTransaction uocArrvaITAcceptanceByNoItemTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public UocReceiveItInspOrderNoItemRspBo dealReceiveItInspOrderNoItem(UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocReceiveItInspOrderNoItemRspBo rspBo = uocArrvaITAcceptanceByNoItemTransaction.dealItArrvalAcceptance(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocReceiveItInspOrderNoItemReqBo reqBo, UocReceiveItInspOrderNoItemRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        list.add(saleBo);
        list.add(inspBo);
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
