/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocUpdateInspPayStatusService;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspInspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocUpdateInspPayStatusServiceRspSaleOrderBo;
import com.tydic.dyc.oc.transactionservice.UocUpdateInspPayStatusTransaction;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocUpdateInspPayStatusService"})
public class UocUpdateInspPayStatusServiceImpl
implements UocUpdateInspPayStatusService {
    private static final Logger log = LoggerFactory.getLogger(UocUpdateInspPayStatusServiceImpl.class);
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocUpdateInspPayStatusTransaction uocUpdateInspPayStatusTransaction;

    @PostMapping(value={"updateInspPayStatus"})
    public UocUpdateInspPayStatusServiceRspBo updateInspPayStatus(@RequestBody UocUpdateInspPayStatusServiceReqBo reqBo) {
        UocUpdateInspPayStatusServiceRspBo rspBo = this.uocUpdateInspPayStatusTransaction.updateInspPayStatus(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocUpdateInspPayStatusServiceReqBo reqBo, UocUpdateInspPayStatusServiceRspBo rspBo) {
        List inspOrderList;
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        List needCompletionSaleOrderList = rspBo.getNeedCompletionSaleOrderList();
        if (ObjectUtil.isNotEmpty((Object)needCompletionSaleOrderList)) {
            for (UocUpdateInspPayStatusServiceRspSaleOrderBo saleOrderBo : needCompletionSaleOrderList) {
                SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
                orderBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
                orderBo.setOrderId(saleOrderBo.getOrderId());
                orderBo.setObjId(saleOrderBo.getSaleOrderId());
                orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(orderBo);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(inspOrderList = rspBo.getInspList()))) {
            for (UocUpdateInspPayStatusServiceRspInspBo inspBo : inspOrderList) {
                SyncEsRunnableBo syncInspBo = new SyncEsRunnableBo();
                syncInspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
                syncInspBo.setOrderId(inspBo.getOrderId());
                syncInspBo.setObjId(inspBo.getInspOrderId());
                syncInspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(syncInspBo);
            }
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

