package com.tydic.dyc.oc.model.chngorder;

import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;

import java.util.List;

/**
 * 标题:IUocChngOrderModel
 * 说明:变更单
 * 时间:2022/3/8 18:06
 * 作者:罗有
 */

public interface IUocChngOrderModel {
    /**
     * 创建变更单
     */
    void createChngOrder(UocChngOrderDo uocChngOrderDo);

    /**
     * 批量修改变更单状态
     *
     * @param uocChngOrderDoList
     */
    void modifyBatchChngOrderState(List<UocChngOrderDo> uocChngOrderDoList);

    /**
     * 查询变更单明细对象列表
     *
     * @param uocChngOrderItemObjQryBo
     * @return
     */
    List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo);

    /**
     * 查询变更单列表
     *
     * @param uocChngOrderQryBo
     * @return
     */
    List<UocChngOrderDo> getListChngOrder(UocChngOrderQryBo uocChngOrderQryBo);

    /**
     * 获取变更单编号
     *
     * @param uocChngOrderQryBo
     * @return
     */
    UocChngOrderDo getChngOrderNo(UocChngOrderQryBo uocChngOrderQryBo);

    /**
     * 更新状态和环节编码
     *
     * @param uocChngOrderDo
     */
    void updateShipStatusAndProCode(UocChngOrderDo uocChngOrderDo);

    /**
     * 更新变更单主体信息
     *
     * @param uocChngOrderDo
     */
    void updateChngOrderMain(UocChngOrderDo uocChngOrderDo);

    /**
     * 查询变更单主体信息
     *
     * @param uocChngOrderQryBo
     * @return
     */
    UocChngOrderDo getChngOrder(UocChngOrderQryBo uocChngOrderQryBo);

    /**
     * 查询变更单对象列表
     *
     * @param uocChngOrderObjQryBo
     * @return
     */
    List<UocChngOrderObj> getListChngOrderObj(UocChngOrderObjQryBo uocChngOrderObjQryBo);

    /**
     * 增加扩展字段
     *
     * @param uocChngOrderDo
     */
    void addChngOrderMap(UocChngOrderDo uocChngOrderDo);

    /**
     * 批量更新扩展字段值
     *
     * @param uocChngOrderDo
     */
    void updateBatchValue(UocChngOrderDo uocChngOrderDo);

    /**
     * 删除扩展字段
     *
     * @param uocChngOrderDo
     */
    void updateInvalid(UocChngOrderDo uocChngOrderDo);

    /**
     * 查询变更单对象列表(不查询变更单详情)
     *
     * @param uocChngOrderObjQryBo
     * @return
     */
    List<UocChngOrderObj> getListChngOrderObjWithOutItem(UocChngOrderObjQryBo uocChngOrderObjQryBo);

    /**
     * 查询售后服务对象
     * @param uocChngOrderObjQryBo
     * @return
     */
    List<UocChngOrderObj> getChngOrderObjList(UocChngOrderObjQryBo uocChngOrderObjQryBo);

    /**
     *查询变更明细拓展信息
     */
    List<UocChngOrderItemMap> getChngItemMapItem(UocChngOrderItemMap uocChngOrderItemMap);

    void modifyItemChngCountConfirm(UocChngOrderItemObj uocChngOrderItemObj);
}
