package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.common.bo.UocQryBusiCodeReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryBusiCodeRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
@HTServiceImpl
public class UocQryBusiCodeServiceImpl implements UocQryBusiCodeService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocBargainingModel iUocBargainingModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Override
    public UocQryBusiCodeRspBo qryBusiCode(UocQryBusiCodeReqBo reqBo) {
        validateArgs(reqBo);
        UocQryBusiCodeRspBo rspBo = UocRu.success(UocQryBusiCodeRspBo.class);
        //获取业务实例信息
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setTaskInstId(reqBo.getTaskId());
        uocOrderTaskInst.setProcInstId(reqBo.getProcInstId());
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (!ObjectUtil.isEmpty(uocOrderTaskInsts)){
            UocOrderTaskInst taskInst = uocOrderTaskInsts.get(0);
            if (!ObjectUtil.isEmpty(taskInst.getObjId())){
                if (UocDicConstant.OBJ_TYPE.APPROVE.equals(taskInst.getObjType())){
                    //获取审批单编号
                    UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
                    uocAuditOrderQryBo.setAuditOrderId(taskInst.getObjId());
                    UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
                    if (!ObjectUtil.isEmpty(uocAuditOrderDo)){
                        rspBo.setObjNo(uocAuditOrderDo.getAuditOrderCode());
                    }
                } else if (UocDicConstant.OBJ_TYPE.SALE.equals(taskInst.getObjType())){
                    UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                    uocSaleOrderDo.setSaleOrderId(taskInst.getObjId());
                    UocSaleOrderDo saleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
                    if (!ObjectUtil.isEmpty(saleOrderDo)){
                        rspBo.setObjNo(saleOrderDo.getSaleOrderNo());
                    }
                }else if (UocDicConstant.OBJ_TYPE.ORDER.equals(taskInst.getObjType())){
                    UocOrderDo uocOrderDo = new UocOrderDo();
                    uocOrderDo.setOrderId(taskInst.getObjId());
                    UocOrderDo orderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
                    if (!ObjectUtil.isEmpty(orderDo)){
                        rspBo.setObjNo(orderDo.getOrderNo());
                    }
                }else if (UocDicConstant.OBJ_TYPE.SHIP.equals(taskInst.getObjType())){
                    UocShipOrderQryBo shipOrderQryBo = new UocShipOrderQryBo();
                    shipOrderQryBo.setShipOrderId(taskInst.getObjId());
                    List<UocShipOrderDo> shipOrderDos = iUocShipOrderModel.getListShipOrder(shipOrderQryBo);
                    if (!ObjectUtil.isEmpty(shipOrderDos)){
                        rspBo.setObjNo(shipOrderDos.get(0).getShipOrderNo());
                    }
                }else if (UocDicConstant.OBJ_TYPE.BARGAIN.equals(taskInst.getObjType())){
                    UocBargainingDo bargainingDo = new UocBargainingDo();
                    bargainingDo.setBargainingId(taskInst.getObjId());
                    UocBargainingDo uocBargainingDo = iUocBargainingModel.qryBargainingBy(bargainingDo);
                    if (!ObjectUtil.isEmpty(uocBargainingDo)){
                        rspBo.setObjNo(uocBargainingDo.getBargainingNo());
                    }
                }else if (UocDicConstant.OBJ_TYPE.AFTER.equals(taskInst.getObjType())){
                    UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
                    uocAfOrderQryBo.setAfOrderId(taskInst.getObjId());
                    UocAfOrder afOrder = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
                    if (!ObjectUtil.isEmpty(afOrder)){
                        rspBo.setObjNo(afOrder.getAfServCode());
                    }
                }else if (UocDicConstant.OBJ_TYPE.CHNG.equals(taskInst.getObjType())){
                    UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
                    uocChngOrderQryBo.setChngOrderId(taskInst.getObjId());
                    UocChngOrderDo chngOrderDo = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
                    if (!ObjectUtil.isEmpty(chngOrderDo)){
                        rspBo.setObjNo(chngOrderDo.getChngOrderNo());
                    }
                }
            }
        }
        return rspBo;
    }

    private void validateArgs(UocQryBusiCodeReqBo uocQryBusiCodeReqBo){
        if (null == uocQryBusiCodeReqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(uocQryBusiCodeReqBo.getTaskId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "任务ID不能为空");
        }
    }
}
