/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocMsgCreateVoterService;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterRspBo;
import com.tydic.dyc.oc.transactionservice.UocMsgCreateVoterTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocMsgCreateVoterService"})
public class UocMsgCreateVoterServiceImpl
implements UocMsgCreateVoterService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgCreateVoterServiceImpl.class);
    @Autowired
    private UocMsgCreateVoterTransaction uocMsgCreateVoterTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"createVoter"})
    public UocMsgCreateVoterRspBo createVoter(@RequestBody UocMsgCreateVoterReqBo reqBo) {
        UocMsgCreateVoterRspBo rspBo = this.uocMsgCreateVoterTransaction.createVoter(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocMsgCreateVoterReqBo reqBo, UocMsgCreateVoterRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(rspBo.getOrderId());
        saleBo.setObjId(rspBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
        shipBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        shipBo.setOrderId(rspBo.getOrderId());
        shipBo.setObjId(rspBo.getShipOrderId());
        shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(shipBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

