/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocShouldPayCalculateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateShouldBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocShouldPayCalculateService"})
public class UocShouldPayCalculateServiceImpl
implements UocShouldPayCalculateService {
    private static final Logger log = LoggerFactory.getLogger(UocShouldPayCalculateServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    private final ThreadLocal<ConcurrentHashMap<String, Object>> threadLocal = new ThreadLocal();

    @PostMapping(value={"calculate"})
    public UocShouldPayCalculateRspBO calculate(@RequestBody UocShouldPayCalculateReqBO reqBO) {
        this.val(reqBO);
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        UocShouldPayCalculateRspBO rspBO = new UocShouldPayCalculateRspBO();
        ArrayList<UocShouldPayCalculateShouldBO> shouldPayList = new ArrayList<UocShouldPayCalculateShouldBO>();
        this.dealShouldPayList(reqBO, shouldPayList, concurrentHashMap, rspBO);
        rspBO.setShouldPayList(shouldPayList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealShouldPayList(UocShouldPayCalculateReqBO reqBO, List<UocShouldPayCalculateShouldBO> shouldPayList, ConcurrentHashMap<String, Object> concurrentHashMap, UocShouldPayCalculateRspBO rspBO) {
        Long saleOrderId = this.qrySaleOrderId(reqBO, concurrentHashMap);
        UocSaleOrderDo uocSaleOrderDo = this.qrySaleOrder(reqBO.getOrderId(), saleOrderId);
        rspBO.setSaleOrderState(uocSaleOrderDo.getSaleOrderState());
        UocSaleStakeholder stakeholder = uocSaleOrderDo.getStakeholder();
        List<UocSaleOrderPayConf> uocSaleOrderPayConfList = this.qrySaleOrderPayConf(reqBO.getOrderId(), saleOrderId, reqBO.getShouldPayType(), reqBO.getPayNodeRule());
        if (CollectionUtils.isEmpty(uocSaleOrderPayConfList)) {
            return;
        }
        this.fillCommonAttr(reqBO.getObjType(), reqBO.getShouldPayType(), shouldPayList, uocSaleOrderDo, stakeholder, uocSaleOrderPayConfList);
        HashMap payConfMap = new HashMap();
        uocSaleOrderPayConfList.forEach(item -> payConfMap.put(item.getUserType(), item));
        for (UocShouldPayCalculateShouldBO item2 : shouldPayList) {
            List<UocSaleOrderItem> uocSaleOrderItemList;
            UocSaleOrderPayConf payConf = (UocSaleOrderPayConf)payConfMap.get(item2.getUserType());
            BigDecimal ratio = this.qryRatio(reqBO, item2, payConf);
            log.info("\u4ed8\u6b3e\u65b9\u5f0f\u4e3a:{}\uff0c\u4ed8\u6b3e\u6bd4\u4f8b\u4e3a{}", (Object)item2.getPayType(), (Object)ratio.toString());
            if (UocDicConstant.OBJ_TYPE.SALE.equals(item2.getObjType())) {
                if (UocDicConstant.USE_TYPE.PUR.equals(item2.getUserType())) {
                    item2.setShouldPayAmount(uocSaleOrderDo.getTotalSaleFee().multiply(ratio));
                } else {
                    item2.setShouldPayAmount(uocSaleOrderDo.getTotalPurchaseFee().multiply(ratio));
                }
                item2.setObjectId(uocSaleOrderDo.getSaleOrderId());
                item2.setObjectNo(uocSaleOrderDo.getSaleOrderNo());
                item2.setContractNo(uocSaleOrderDo.getContractNo());
                continue;
            }
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(item2.getObjType())) {
                List uocShipOrderItemList = (List)concurrentHashMap.get("shipOrderItemDO");
                uocSaleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemListByItemIds(uocShipOrderItemList.stream().map(UocShipOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
                if (CollectionUtils.isEmpty(uocSaleOrderItemList)) {
                    throw new BaseBusinessException("101016", "\u6570\u636e\u5f02\u5e38\uff0c\u5230\u53d1\u8d27\u5355\u660e\u7ec6\u5bf9\u5e94\u7684\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a");
                }
                this.fillShipShouldPayFee(item2, payConf, ratio, uocShipOrderItemList, uocSaleOrderItemList);
                UocShipOrderDo shipOrderDO = (UocShipOrderDo)concurrentHashMap.get("shipOrderDO");
                item2.setObjectId(shipOrderDO.getShipOrderId());
                item2.setObjectNo(shipOrderDO.getShipOrderNo());
                item2.setContractNo(uocSaleOrderDo.getContractNo());
                continue;
            }
            if (!UocDicConstant.OBJ_TYPE.INSPECTION.equals(item2.getObjType())) continue;
            List uocInspOrderItemList = (List)concurrentHashMap.get("inspOrderItemDO");
            uocSaleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemListByItemIds(uocInspOrderItemList.stream().map(UocInspOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty(uocSaleOrderItemList)) {
                throw new BaseBusinessException("101016", "\u6570\u636e\u5f02\u5e38\uff0c\u9a8c\u6536\u8d27\u5355\u660e\u7ec6\u5bf9\u5e94\u7684\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a");
            }
            this.fillInspShouldPayFee(item2, payConf, ratio, uocInspOrderItemList, uocSaleOrderItemList);
            UocInspOrderDo inspOrderDO = (UocInspOrderDo)concurrentHashMap.get("inspOrderDO");
            item2.setObjectId(inspOrderDO.getInspOrderId());
            item2.setObjectNo(inspOrderDO.getInspOrderNo());
            item2.setContractNo(uocSaleOrderDo.getContractNo());
        }
    }

    private void fillInspShouldPayFee(UocShouldPayCalculateShouldBO item, UocSaleOrderPayConf payConf, BigDecimal ratio, List<UocInspOrderItem> uocInspOrderItemList, List<UocSaleOrderItem> uocSaleOrderItemList) {
        boolean lastInspOrder = true;
        HashMap map = new HashMap();
        if (UocDicConstant.USE_TYPE.PUR.equals(item.getUserType())) {
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getSalePrice()));
        } else {
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getPurchasePrice()));
        }
        BigDecimal inspPrice = new BigDecimal("0");
        for (UocInspOrderItem entity2 : uocInspOrderItemList) {
            BigDecimal price = (BigDecimal)map.get(entity2.getSaleOrderItemId());
            if (price == null) {
                throw new BaseBusinessException("101016", "map\u6570\u636e\u7f3a\u5931");
            }
            BigDecimal oneInspPrice = entity2.getInspCount().multiply(price);
            inspPrice = inspPrice.add(oneInspPrice);
        }
        inspPrice = inspPrice.multiply(ratio).setScale(2, RoundingMode.DOWN);
        item.setShouldPayAmount(inspPrice);
    }

    private void fillShipShouldPayFee(UocShouldPayCalculateShouldBO item, UocSaleOrderPayConf payConf, BigDecimal ratio, List<UocShipOrderItem> uocShipOrderItemList, List<UocSaleOrderItem> uocSaleOrderItemList) {
        boolean lastShipOrder = true;
        HashMap map = new HashMap();
        if (UocDicConstant.USE_TYPE.PUR.equals(item.getUserType())) {
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getSalePrice()));
        } else {
            uocSaleOrderItemList.forEach(entity -> map.put(entity.getSaleOrderItemId(), entity.getPurchasePrice()));
        }
        BigDecimal sendPrice = new BigDecimal("0");
        for (UocShipOrderItem entity2 : uocShipOrderItemList) {
            BigDecimal price = (BigDecimal)map.get(entity2.getSaleOrderItemId());
            if (price == null) {
                throw new BaseBusinessException("101016", "map\u6570\u636e\u7f3a\u5931");
            }
            BigDecimal oneSendPrice = entity2.getSendCount().multiply(price);
            sendPrice = sendPrice.add(oneSendPrice);
        }
        sendPrice = sendPrice.multiply(ratio).setScale(2, RoundingMode.DOWN);
        item.setShouldPayAmount(sendPrice);
    }

    private BigDecimal qryRatio(UocShouldPayCalculateReqBO reqBO, UocShouldPayCalculateShouldBO item, UocSaleOrderPayConf payConf) {
        BigDecimal ratio = new BigDecimal("1");
        if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(item.getPayType())) {
            if (UocDicConstant.SHOULD_PAY_TYPE.GOODS.equals(reqBO.getShouldPayType())) {
                ratio = payConf.getVerPaySup().divide(new BigDecimal(100));
            } else if (UocDicConstant.SHOULD_PAY_TYPE.CHECK.equals(reqBO.getShouldPayType())) {
                ratio = payConf.getPilPaySup().divide(new BigDecimal(100));
            } else if (UocDicConstant.SHOULD_PAY_TYPE.GUARANTEE.equals(reqBO.getShouldPayType())) {
                ratio = payConf.getQuaPaySup().divide(new BigDecimal(100));
            } else if (UocDicConstant.SHOULD_PAY_TYPE.ADVANCE.equals(reqBO.getShouldPayType())) {
                ratio = payConf.getPrePaySup().divide(new BigDecimal(100));
            }
        }
        return ratio;
    }

    private Long qrySaleOrderId(UocShouldPayCalculateReqBO reqBO, ConcurrentHashMap<String, Object> concurrentHashMap) {
        Long saleOrderId = null;
        if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            saleOrderId = reqBO.getObjId();
        } else if (UocDicConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())) {
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setShipOrderId(reqBO.getObjId());
            uocShipOrderQryBo.setOrderId(reqBO.getOrderId());
            UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if (uocShipOrderDo == null) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u4e3b\u4f53\u4e3a\u7a7a");
            }
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
            uocShipOrderItemQryBo.setOrderId(reqBO.getOrderId());
            UocShipOrderDo listShipOrderItem = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            uocShipOrderDo.setShipOrderItemBoList(listShipOrderItem.getShipOrderItemBoList());
            if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u4e3a\u7a7a");
            }
            concurrentHashMap.put("shipOrderDO", uocShipOrderDo);
            concurrentHashMap.put("shipOrderItemDO", uocShipOrderDo.getShipOrderItemBoList());
            saleOrderId = uocShipOrderDo.getSaleOrderId();
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setOrderId(reqBO.getOrderId());
            uocInspOrderQryBo.setInspOrderId(reqBO.getObjId());
            UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            if (uocInspOrderDo == null) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3b\u4f53\u4e3a\u7a7a");
            }
            saleOrderId = uocInspOrderDo.getSaleOrderId();
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setOrderId(reqBO.getOrderId());
            uocInspOrderItemQryBo.setInspOrderId(reqBO.getObjId());
            List<UocInspOrderItem> uocInspOrderItemList = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo).getUocInspOrderItemList();
            if (CollectionUtils.isEmpty(uocInspOrderItemList)) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u9a8c\u6536\u5355\u660e\u7ec6\u4e3a\u7a7a");
            }
            concurrentHashMap.put("inspOrderDO", uocInspOrderDo);
            concurrentHashMap.put("inspOrderItemDO", uocInspOrderItemList);
        }
        if (saleOrderId == null) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355Id\u4e3a\u7a7a");
        }
        return saleOrderId;
    }

    private void fillCommonAttr(Integer objType, Integer shouldPayType, List<UocShouldPayCalculateShouldBO> shouldPayList, UocSaleOrderDo uocSaleOrderDo, UocSaleStakeholder stakeholder, List<UocSaleOrderPayConf> uocSaleOrderPayConfList) {
        for (UocSaleOrderPayConf payConf : uocSaleOrderPayConfList) {
            UocShouldPayCalculateShouldBO uocShouldPayCalculateShouldBO = new UocShouldPayCalculateShouldBO();
            if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
                if (UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType())) {
                    uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.SALE);
                } else {
                    uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.ORDER);
                }
            } else if (UocDicConstant.OBJ_TYPE.SHIP.equals(objType)) {
                uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.GOODS);
            } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(objType)) {
                uocShouldPayCalculateShouldBO.setObjectTypeReturn(UocConstant.OBJECT_TYPE.CHECK);
            }
            uocShouldPayCalculateShouldBO.setObjectType(objType);
            uocShouldPayCalculateShouldBO.setPayType(payConf.getPayType());
            uocShouldPayCalculateShouldBO.setShouldPayType(shouldPayType);
            uocShouldPayCalculateShouldBO.setOrderId(uocSaleOrderDo.getOrderId());
            if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(payConf.getPayType())) {
                uocShouldPayCalculateShouldBO.setShouldPayDate(this.getShouldPayDate(payConf));
            }
            this.fillPayerAndPayee(uocSaleOrderDo.getModelSettle(), stakeholder, payConf.getUserType(), uocShouldPayCalculateShouldBO);
            uocShouldPayCalculateShouldBO.setPenaltyRatio(payConf.getPayBreakScale());
            uocShouldPayCalculateShouldBO.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            uocShouldPayCalculateShouldBO.setObjType(objType);
            uocShouldPayCalculateShouldBO.setUserType(payConf.getUserType());
            shouldPayList.add(uocShouldPayCalculateShouldBO);
        }
    }

    private Date getShouldPayDate(UocSaleOrderPayConf payConf) {
        Calendar now = Calendar.getInstance();
        if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
            int nowDay = now.get(5);
            if (nowDay < payConf.getPayAccountDay()) {
                now.set(5, payConf.getPayAccountDay());
            } else {
                now.add(2, 1);
                now.set(5, payConf.getPayAccountDay());
            }
        } else if (UocDicConstant.PAY_RULE.ACCOUNT_PERIOD_COUNT_BUSI_NODE.equals(payConf.getPayRule())) {
            now.add(5, payConf.getPaymentDays());
        } else {
            throw new BaseBusinessException("100001", "\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u975e\u6cd5\uff01");
        }
        return now.getTime();
    }

    private void fillPayerAndPayee(Integer modelSettle, UocSaleStakeholder stakeholder, Integer userType, UocShouldPayCalculateShouldBO uocShouldPayCalculateShouldBO) {
        if (UocDicConstant.MODEL_SETTLE.TRADE.equals(modelSettle)) {
            if (UocDicConstant.USE_TYPE.PUR.equals(userType)) {
                uocShouldPayCalculateShouldBO.setPayerId(Long.valueOf(stakeholder.getPurOrgId()));
                uocShouldPayCalculateShouldBO.setPayerName(stakeholder.getPurOrgName());
                uocShouldPayCalculateShouldBO.setPayeeId(Long.valueOf(stakeholder.getProId()));
                uocShouldPayCalculateShouldBO.setPayeeName(stakeholder.getProName());
            } else {
                uocShouldPayCalculateShouldBO.setPayerId(Long.valueOf(stakeholder.getProId()));
                uocShouldPayCalculateShouldBO.setPayerName(stakeholder.getProName());
                uocShouldPayCalculateShouldBO.setPayeeId(Long.valueOf(stakeholder.getSupId()));
                uocShouldPayCalculateShouldBO.setPayeeName(stakeholder.getSupName());
            }
        } else if (UocDicConstant.MODEL_SETTLE.MATCH.equals(modelSettle)) {
            uocShouldPayCalculateShouldBO.setPayerId(Long.valueOf(stakeholder.getPurOrgId()));
            uocShouldPayCalculateShouldBO.setPayerName(stakeholder.getPurOrgName());
            uocShouldPayCalculateShouldBO.setPayeeId(Long.valueOf(stakeholder.getSupId()));
            uocShouldPayCalculateShouldBO.setPayeeName(stakeholder.getSupName());
        }
    }

    private UocSaleOrderDo qrySaleOrder(Long orderId, Long saleOrderId) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(orderId);
        uocSaleOrderQryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException("101016", "\u9500\u552e\u5355\u67e5\u8be2\u4e3a\u7a7a");
        }
        return uocSaleOrderDo;
    }

    private List<UocSaleOrderPayConf> qrySaleOrderPayConf(Long orderId, Long saleOrderId, Integer shouldPayType, Integer payNodeRule) {
        ArrayList<UocSaleOrderPayConf> allSaleOrderPayConfList = new ArrayList<UocSaleOrderPayConf>();
        if (UocConstant.SHOULD_PAY_TYPE.PRE_PAY.equals(shouldPayType)) {
            UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
            uocSaleOrderPayConfQryBo.setOrderId(orderId);
            uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED);
            List<UocSaleOrderPayConf> prePaySaleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
            if (!CollectionUtils.isEmpty(prePaySaleOrderPayConfList)) {
                allSaleOrderPayConfList.addAll(prePaySaleOrderPayConfList);
            }
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT);
            List<UocSaleOrderPayConf> agrSaleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
            if (!CollectionUtils.isEmpty(agrSaleOrderPayConfList)) {
                allSaleOrderPayConfList.addAll(agrSaleOrderPayConfList);
            }
        } else if (UocConstant.SHOULD_PAY_TYPE.ACOUNT_DAY.equals(shouldPayType)) {
            UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
            uocSaleOrderPayConfQryBo.setOrderId(orderId);
            uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.PAY_BY_PERIOD);
            List<UocSaleOrderPayConf> saleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
            for (UocSaleOrderPayConf bo : saleOrderPayConfList) {
                if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(bo.getPayRule())) {
                    if (!payNodeRule.equals(bo.getPayAccountDayRule())) continue;
                    allSaleOrderPayConfList.add(bo);
                    continue;
                }
                if (!payNodeRule.equals(bo.getPayNodeRule())) continue;
                allSaleOrderPayConfList.add(bo);
            }
        } else {
            UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
            uocSaleOrderPayConfQryBo.setOrderId(orderId);
            uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
            uocSaleOrderPayConfQryBo.setPayType(UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT);
            List<UocSaleOrderPayConf> saleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
            allSaleOrderPayConfList.addAll(saleOrderPayConfList);
        }
        return allSaleOrderPayConfList;
    }

    private void val(UocShouldPayCalculateReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getObjId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ObjId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ObjType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(UocDicConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType()) || UocDicConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType()) || UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType()))) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ObjType\u76ee\u524d\u4ec5\u652f\u63012\u9500\u552e\u5355\u30014\u53d1\u8d27\u5355\u30018\u9a8c\u6536\u5355");
        }
        if (reqBO.getShouldPayType() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ShouldPayType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(UocDicConstant.SHOULD_PAY_TYPE.ADVANCE.equals(reqBO.getShouldPayType()) || UocDicConstant.SHOULD_PAY_TYPE.GOODS.equals(reqBO.getShouldPayType()) || UocDicConstant.SHOULD_PAY_TYPE.CHECK.equals(reqBO.getShouldPayType()) || UocDicConstant.SHOULD_PAY_TYPE.GUARANTEE.equals(reqBO.getShouldPayType()) || UocDicConstant.SHOULD_PAY_TYPE.PAYMENT.equals(reqBO.getShouldPayType()))) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ShouldPayType\u76ee\u524d\u4ec5\u652f\u6301\uff1a1:\u8d26\u671f\uff1b2\uff1a\u9884\u4ed8\u6b3e\u5e94\u4ed8\uff1b5\uff1a\u5230\u8d27\u6b3e\u5e94\u4ed8\uff1b6\uff1a\u9a8c\u6536\u6b3e\u5e94\u4ed8\uff1b7\uff1a\u8d28\u4fdd\u91d1\u5e94\u4ed8");
        }
        if (reqBO.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61OrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

