/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderItemQryBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.service.cmporder.UocGetCmpOrderDetailService;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspDetailBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemFormatBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemFormatChildBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.cmporder.UocGetCmpOrderDetailService"})
public class UocQryCmpOrderDetailServiceImpl
implements UocGetCmpOrderDetailService {
    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;

    @PostMapping(value={"qryCmpOrderDetail"})
    public UocGetCmpOrderDetailServiceRspBo qryCmpOrderDetail(@RequestBody UocGetCmpOrderDetailServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocGetCmpOrderDetailServiceRspBo rspBo = UocRu.success(UocGetCmpOrderDetailServiceRspBo.class);
        UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
        uocCmpOrderQryBo.setCmpOrderNo(reqBo.getCmpOrderNo());
        UocCmpOrderQryBo cmpOrderDetail = this.uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
        if (ObjectUtil.isNotEmpty((Object)cmpOrderDetail)) {
            UocGetCmpOrderDetailServiceRspDetailBo cmpOrderBo = UocRu.js(cmpOrderDetail, UocGetCmpOrderDetailServiceRspDetailBo.class);
            List<UocCmpOrderItemQryBo> uocCmpOrderItemList = cmpOrderDetail.getUocCmpOrderItemList();
            for (UocCmpOrderItemQryBo each : uocCmpOrderItemList) {
                each.setVendorId(each.getGoodsSupplierId());
            }
            if (CollectionUtil.isNotEmpty(uocCmpOrderItemList)) {
                cmpOrderBo.setUocCmpOrderItemList(UocRu.jsl(uocCmpOrderItemList, UocGetCmpOrderDetailServiceRspItemBo.class));
                cmpOrderBo.setSkuMainPicUrl(uocCmpOrderItemList.get(0).getImgUrl());
                cmpOrderBo.setUocCmpOrderItemFormatList(new ArrayList());
                ConcurrentMap<String, List<UocCmpOrderItemQryBo>> cmpOrderItemsMap = uocCmpOrderItemList.stream().collect(Collectors.groupingByConcurrent(UocCmpOrderItemQryBo::getSpuId));
                for (String key : cmpOrderItemsMap.keySet()) {
                    UocGetCmpOrderDetailServiceRspItemFormatBo formatBo = new UocGetCmpOrderDetailServiceRspItemFormatBo();
                    formatBo.setCmpOrderNo(cmpOrderBo.getCmpOrderNo());
                    formatBo.setImgUrl(((UocCmpOrderItemQryBo)((List)cmpOrderItemsMap.get(key)).get(0)).getImgUrl());
                    formatBo.setRemark(((UocCmpOrderItemQryBo)((List)cmpOrderItemsMap.get(key)).get(0)).getRemark());
                    formatBo.setUocCmpItemFormatChildList(UocRu.jsl((List)cmpOrderItemsMap.get(key), UocGetCmpOrderDetailServiceRspItemFormatChildBo.class));
                    cmpOrderBo.getUocCmpOrderItemFormatList().add(formatBo);
                }
            }
            rspBo.setCmpOrderDetailinfo(cmpOrderBo);
        }
        return rspBo;
    }

    private void validateArg(UocGetCmpOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocGetCmpOrderDetailServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCmpOrderNo())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6bd4\u4ef7\u5355\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

