/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.transactionservice.UocArrvalAcceptanceTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceService"})
public class UocArrvalAcceptanceServiceImpl
implements UocArrvalAcceptanceService {
    private static final Logger log = LoggerFactory.getLogger(UocArrvalAcceptanceServiceImpl.class);
    @Autowired
    private UocArrvalAcceptanceTransaction uocArrvalAcceptanceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealArrvalAcceptance"})
    public UocArrvalAcceptanceRspBo dealArrvalAcceptance(@RequestBody UocArrvalAcceptanceReqBo reqBo) {
        UocArrvalAcceptanceRspBo rspBo = this.uocArrvalAcceptanceTransaction.dealArrvalAcceptance(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocArrvalAcceptanceReqBo reqBo, UocArrvalAcceptanceRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        SyncEsRunnableBo transactionBo = new SyncEsRunnableBo();
        transactionBo.setIndexName(this.uocIndexConfig.getTransactionIndex());
        transactionBo.setOrderId(reqBo.getOrderId());
        transactionBo.setObjId(rspBo.getInspOrderId());
        transactionBo.setJsonObj(reqBo.getJsonObj());
        transactionBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        transactionBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(transactionBo);
        list.add(saleBo);
        list.add(inspBo);
        log.debug("\u9a8c\u6536\u5355es\u540c\u6b65\uff1a" + JSON.toJSONString(list));
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

