/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseForInspReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseForInspRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseSaleTaskInstBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseShipTaskInstBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocChngOrderConfirmOrRefuseForInspTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocChngOrderConfirmOrRefuseForInspTransaction.class);
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;
    private static final Integer CHNG_TYPE_ADD = 1;
    private static final Integer CHNG_TYPE_SUBTRACT = 2;
    @Value(value="${updateChingNumFlag:false}")
    private boolean updateChingNumFlag;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocChngOrderConfirmOrRefuseForInspRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        UocChngOrderConfirmOrRefuseForInspRspBo rspBo = UocRu.success(UocChngOrderConfirmOrRefuseForInspRspBo.class);
        this.validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.getListChngOrderItemObj(reqBo);
        this.iUocChngOrderModel.modifyBatchChngOrderState(this.convertChngOrderDo(reqBo, now, operId));
        Map<Integer, List<UocChngOrderItemObj>> chngItems = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngType));
        List<UocChngOrderItemObj> uocChngNums = chngItems.get(UocConstant.BUSI_TYPE.NUM);
        List<UocChngOrderItemObj> uocChngState = chngItems.get(UocConstant.BUSI_TYPE.STATE);
        if (!CollectionUtil.isEmpty(uocChngNums)) {
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !this.updateChingNumFlag) {
                this.confirm(reqBo, operId, now, uocChngNums);
            }
            if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                this.refuse(reqBo, operId, now, uocChngNums);
            }
        }
        if (!CollectionUtil.isEmpty(uocChngState)) {
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !this.updateChingNumFlag) {
                this.confirmStat(reqBo, operId, now, uocChngState);
                this.getShipTaskInsts(reqBo, rspBo);
                this.getSaleOrderInfo(reqBo, rspBo);
            }
            if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                this.refuseState(reqBo, operId, now, uocChngState);
            }
        }
        this.updateSaleOrdersTate(reqBo);
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        });
        this.dealMap(reqBo, now);
        this.buildSyncRsp(reqBo, rspBo, uocChngOrderItemObjList);
        return rspBo;
    }

    private void updateSaleOrdersTate(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        List<Long> chngOrderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIdList);
        List<UocChngOrderObj> chngOrderObjList = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (ObjectUtil.isEmpty(chngOrderObjList)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u5355\u5bf9\u8c61\u4e3a\u7a7a");
        }
        List<Long> saleOrderIdList = chngOrderObjList.stream().map(UocChngOrderObj::getSaleOrderId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
        }
        Map<Long, List<UocSaleOrderItem>> saleOrderItemMapBySale = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSaleOrderId));
        for (Long saleOrderId : saleOrderItemMapBySale.keySet()) {
            List<UocSaleOrderItem> itemList = saleOrderItemMapBySale.get(saleOrderId);
            BigDecimal totalPurchaseCount = itemList.stream().map(UocSaleOrderItem::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalInspCount = itemList.stream().map(UocSaleOrderItem::getAcceptanceCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalArrivedCount = itemList.stream().map(UocSaleOrderItem::getArriveCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalRefusedCount = itemList.stream().map(UocSaleOrderItem::getRefuseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.debug("saleOrderId=" + saleOrderId + ",totalInspCount:=" + totalInspCount + ",totalArrivedCount:=" + totalArrivedCount + ",totalRefusedCount:=" + totalRefusedCount);
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                log.debug("saleOrderId=" + saleOrderId + ":XS_YS_BFYS");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_YS_BFYS", reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) == 0 && totalArrivedCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                log.debug("saleOrderId=" + saleOrderId + ":XS_DH_BFDH");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_DH_BFDH", reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) == 0 && totalArrivedCount.compareTo(BigDecimal.ZERO) == 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                log.debug("saleOrderId=" + saleOrderId + ":XS_DH_JS");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_DH_JS", reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) == 0) {
                log.debug("saleOrderId=" + saleOrderId + ":XS_YS_YS");
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_YS_YS", reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 || totalArrivedCount.compareTo(BigDecimal.ZERO) == 0 || totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) continue;
            log.debug("saleOrderId=" + saleOrderId + ":XS_DH_DH");
            this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_DH_DH", reqBo.getUserId(), reqBo.getName());
        }
    }

    private void updateSaleOrderMain(Long orderId, Long saleOrderId, String saleOrderState, Long userId, String name) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderState(saleOrderState);
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        uocSaleOrderDo.setUpdateOperId(userId.toString());
        uocSaleOrderDo.setUpdateOperName(name);
        uocSaleOrderDo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
    }

    private void refuse(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocSaleOrderModel.modifyItemChngCountRefuse(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocInspOrderModel.modifyItemChngCountRefuse(this.convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private void confirm(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
            if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)) {
                this.iUocInspOrderModel.modifyItemChngCountConfirmAdd(this.convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                this.iUocSaleOrderModel.modifyItemChngCountConfirmAdd(this.convertSaleOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                this.iUocChngOrderModel.modifyItemChngCountConfirm(uocChngOrderItemObj);
                continue;
            }
            if (!uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)) continue;
            this.iUocInspOrderModel.modifyItemChngCountConfirmReduce(this.convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
            this.iUocSaleOrderModel.modifyItemChngCountConfirmReduce(this.convertSaleOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
            this.iUocChngOrderModel.modifyItemChngCountConfirm(uocChngOrderItemObj);
        }
        this.chngInspFee(uocChngOrderItemObjList, reqBo);
    }

    private void chngInspFee(List<UocChngOrderItemObj> uocChngOrderItemObjList, UocChngOrderConfirmOrRefuseForInspReqBo reqBO) {
        List<Long> inspItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).distinct().collect(Collectors.toList());
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspItemIdList);
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getInspOrderItemList(uocInspOrderItemQryBo);
        if (null == uocInspOrderDo || CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
            throw new ZTBusinessException("\u67e5\u8be2\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        Map<Long, List<UocChngOrderItemObj>> inspItemMap = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getInspOrderItemId));
        Map<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingBy(UocInspOrderItem::getInspOrderId));
        inspOrderMap.forEach((k, v) -> {
            BigDecimal totalAddSaleFee = BigDecimal.ZERO;
            BigDecimal totalAddPurchaseFee = BigDecimal.ZERO;
            BigDecimal totalReduceSaleFee = BigDecimal.ZERO;
            BigDecimal totalReducePurchaseFee = BigDecimal.ZERO;
            for (UocInspOrderItem item : v) {
                UocChngOrderItemObj uocChngOrderItemObj = (UocChngOrderItemObj)((List)inspItemMap.get(item.getInspOrderItemId())).get(0);
                if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)) {
                    totalAddSaleFee = totalAddSaleFee.add(uocChngOrderItemObj.getChngFee());
                    totalAddPurchaseFee = totalAddPurchaseFee.add(uocChngOrderItemObj.getChngPurchaseFee());
                    continue;
                }
                if (!uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)) continue;
                totalReduceSaleFee = totalReduceSaleFee.add(uocChngOrderItemObj.getChngFee());
                totalReducePurchaseFee = totalReducePurchaseFee.add(uocChngOrderItemObj.getChngPurchaseFee());
            }
            BigDecimal totalSaleChngFee = totalReduceSaleFee.subtract(totalAddSaleFee);
            BigDecimal totalPurchaseChngFee = totalReducePurchaseFee.subtract(totalAddPurchaseFee);
            UocInspOrderDo orderDo = new UocInspOrderDo();
            orderDo.setInspOrderId((Long)k);
            orderDo.setTotalSaleFee(totalSaleChngFee);
            orderDo.setTotalPurchaseFee(totalPurchaseChngFee);
            orderDo.setUpdateOperId(reqBO.getUserId().toString());
            orderDo.setUpdateTime(new Date());
            this.iUocInspOrderModel.modifyInsporderChngTotalFeeConfirm(orderDo);
        });
    }

    private UocInspOrderDo convertInspOrderDoForSingle(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, UocChngOrderItemObj uocChngOrderItemObj) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(Arrays.asList(uocChngOrderItemObj.getInspOrderItemId()));
        uocInspOrderDo.setOrderIdList(Arrays.asList(uocChngOrderItemObj.getOrderId()));
        uocInspOrderDo.setInspCount(uocChngOrderItemObj.getChngNum());
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    private UocSaleOrderDo convertSaleOrderDoForSingle(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, UocChngOrderItemObj uocChngOrderItemObj) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setChngingCount(uocChngOrderItemObj.getChngNum());
        uocSaleOrderDo.setOrderIdList(Collections.singletonList(uocChngOrderItemObj.getOrderId()));
        uocSaleOrderDo.setSaleOrderItemsIdList(Collections.singletonList(uocChngOrderItemObj.getSaleOrderItemId()));
        return uocSaleOrderDo;
    }

    private UocInspOrderDo convertInspOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList()));
        uocInspOrderDo.setOrderIdList(orderIdList);
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId) {
        String state = this.getState(reqBo);
        return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setChngOrderState(state);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(operId);
            uocChngOrderDo.setUpdateOperName(reqBo.getName());
            uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
            return uocChngOrderDo;
        }).collect(Collectors.toList());
    }

    private String getState(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            return "CHNG_CHNG_JJ";
        }
        return "CHNG_CHNG_QR";
    }

    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u660e\u7ec6\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return uocChngOrderItemObjList;
    }

    private void validateArg(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u53ea\u652f\u6301\u786e\u8ba4\u6216\u62d2\u7edd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getChngOrderList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u7684\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u7684\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                    }
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                    if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                });
            }
        });
    }

    private void dealMap(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now) {
        List chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
                ArrayList<UocChngOrderMap> extParallelBoList = new ArrayList<UocChngOrderMap>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                    uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                    uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                    uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                    uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    uocChngOrderMap.setUpdateTime(now);
                    extParallelBoList.add(uocChngOrderMap);
                });
                delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
                this.iUocChngOrderModel.updateInvalid(delChngOrderDo);
            }
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                UocChngOrderDo add = new UocChngOrderDo();
                UocChngOrderDo modify = new UocChngOrderDo();
                ArrayList<UocChngOrderMap> addList = new ArrayList<UocChngOrderMap>();
                ArrayList<UocChngOrderMap> modifyList = new ArrayList<UocChngOrderMap>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                        UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                        addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                        addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        addShipOrderMap.setId(IdUtil.nextId());
                        addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                        addShipOrderMap.setCreateTime(now);
                        addList.add(addShipOrderMap);
                    } else {
                        UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                        updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                        updateShipOrderMap.setUpdateTime(now);
                        modifyList.add(updateShipOrderMap);
                    }
                });
                if (!CollectionUtils.isEmpty(addList)) {
                    add.setUocChngOrderMapList(addList);
                    this.iUocChngOrderModel.addChngOrderMap(add);
                }
                if (!CollectionUtils.isEmpty(modifyList)) {
                    modify.setUocChngOrderMapList(modifyList);
                    this.iUocChngOrderModel.updateBatchValue(modify);
                }
            }
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) ? "CHNG_CHNG_QR" : "CHNG_CHNG_JJ");
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            this.iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
        });
    }

    private void buildSyncRsp(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> inspOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList());
        List<Long> shipOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.setSaleOrderItemList(UocRu.jsl(saleOrderItemList, UocSaleOrderItemBO.class));
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIds);
        List<UocShipOrderItem> shipOrderItemList = this.iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        rspBo.getShipOrderIdList().addAll(shipOrderItemList.stream().map(x -> x.getShipOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspOrderItemIds);
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        Map<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingBy(UocInspOrderItem::getInspOrderId));
        rspBo.setInspOrderIdLists(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "").distinct().collect(Collectors.toList()));
        rspBo.getInspOrderIdList().addAll(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        reqBo.getChngOrderList().forEach(x -> rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId()));
        ArrayList<UocInspOrderDo> inspOrderDoList = new ArrayList<UocInspOrderDo>();
        List inspOrderIdList = uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getInspOrderId).distinct().collect(Collectors.toList());
        for (Long inspOrderId : inspOrderIdList) {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setInspOrderId((long)inspOrderId);
            uocInspOrderDo = this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            uocInspOrderDo.setUocInspOrderItemList(inspOrderMap.get(inspOrderId));
            inspOrderDoList.add(uocInspOrderDo);
        }
        List saleOrderIdList = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderId).distinct().collect(Collectors.toList());
        ArrayList<UocSaleOrderDo> saleOrderDoList = new ArrayList<UocSaleOrderDo>();
        for (Long saleOrderId : saleOrderIdList) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setSaleOrderId((long)saleOrderId);
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            saleOrderDoList.add(uocSaleOrderDo);
        }
        rspBo.setInspOrderBoList(UocRu.jsl(inspOrderDoList, UocInspOrderBo.class));
        rspBo.setSaleOrderBOList(UocRu.jsl(saleOrderDoList, UocSaleOrderBO.class));
    }

    private void confirmStat(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo;
        UocShipOrderDo uocShipOrderDo;
        Map<String, List<UocChngOrderItemObj>> chngOrderItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getOtherChngValue));
        List<UocChngOrderItemObj> uocChngOrderItemObjsJS = chngOrderItemMaps.get("1");
        List<UocChngOrderItemObj> uocChngOrderItemObjsTT = chngOrderItemMaps.get("2");
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsJS)) {
            uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            uocSaleOrderDo = this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            this.iUocSaleOrderModel.modifyItemRefuseCountConfirm(uocSaleOrderDo);
            this.iUocShipOrderModel.modifyItemRefuseCountConfirm(uocShipOrderDo);
        }
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsTT)) {
            uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            uocSaleOrderDo = this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            this.iUocSaleOrderModel.modifyItemArriveCountConfirm(uocSaleOrderDo);
            this.iUocShipOrderModel.modifyItemArriveCountConfirm(uocShipOrderDo);
        }
        List<Long> shipItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).distinct().collect(Collectors.toList());
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipItemIdList);
        List<UocShipOrderItem> shipOrderItemList = this.iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        if (CollectionUtil.isNotEmpty(shipOrderItemList)) {
            Map<Long, Long> shipItemToShipIdMaps = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, UocShipOrderItem::getShipOrderId));
            uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
                UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
                Long shipOrderItemId = uocChngOrderItemObj.getShipOrderItemId();
                Long shipOrderId = (Long)shipItemToShipIdMaps.get(shipOrderItemId);
                uocShipOrderDo.setOrderId(uocChngOrderItemObj.getOrderId());
                uocShipOrderDo.setShipOrderId(shipOrderId);
                this.iUocShipOrderModel.modifyStatChngShipStatus(uocShipOrderDo);
            });
        }
    }

    private void getShipTaskInsts(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rsp) {
        ArrayList shipTaskInstBoList = new ArrayList();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderObj> listChngOrderObjWithOutItem = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        listChngOrderObjWithOutItem.forEach(x -> {
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setOrderId(x.getOrderId());
            uocOrderTaskInst.setObjId(x.getShipOrderId());
            uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
            if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
            }
            UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
            String taskInstId = uocOrderTaskInst1.getTaskInstId();
            String procState = uocOrderTaskInst1.getProcState();
            UocChngOrderConfirmOrRefuseShipTaskInstBo uocChngOrderConfirmOrRefuseShipTaskInstBo = new UocChngOrderConfirmOrRefuseShipTaskInstBo();
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setShipOrderId(x.getShipOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setTaskId(taskInstId);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setStepId(procState);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setChngOrderId(x.getChngOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setOrderId(x.getOrderId());
            shipTaskInstBoList.add(uocChngOrderConfirmOrRefuseShipTaskInstBo);
        });
        rsp.setShipTaskInstList(shipTaskInstBoList);
    }

    private void getSaleOrderInfo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rsp) {
        ArrayList<UocChngOrderConfirmOrRefuseSaleTaskInstBo> saleOrderTaskInstBoList = new ArrayList<UocChngOrderConfirmOrRefuseSaleTaskInstBo>();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderItemObj> listChngOrderItemObj = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        Map<Long, List<UocChngOrderItemObj>> chngOrderItemMaps = listChngOrderItemObj.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngOrderId));
        List<UocChngOrderObj> listChngOrderObjWithOutItem = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (CollectionUtil.isEmpty(listChngOrderObjWithOutItem)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u5bf9\u8c61\u4e3a\u7a7a");
        }
        for (UocChngOrderObj uocChngOrderObj : listChngOrderObjWithOutItem) {
            String procState;
            Long saleOrderId = uocChngOrderObj.getSaleOrderId();
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(saleOrderId);
            uocSaleOrderDo.setOrderId(uocChngOrderObj.getOrderId());
            UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            if (!UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMain.getOrderSource()) || !UocConstant.BUSI_TYPE.STATE.equals(uocChngOrderObj.getChngType())) continue;
            Boolean flag = null;
            UocOrderTaskInst uocSaleOrderTaskInst = new UocOrderTaskInst();
            uocSaleOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
            uocSaleOrderTaskInst.setObjId(saleOrderId);
            uocSaleOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocSaleOrderTaskInst.setFinishTag(0);
            List<UocOrderTaskInst> uocSaleOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocSaleOrderTaskInst);
            if (CollectionUtil.isEmpty(uocSaleOrderTaskInsts)) {
                return;
            }
            UocOrderTaskInst uocSaleOrderTaskInst1 = uocSaleOrderTaskInsts.get(0);
            List<UocChngOrderItemObj> uocChngOrderItemObjs = chngOrderItemMaps.get(uocChngOrderObj.getChngOrderId());
            if (CollectionUtil.isEmpty(uocChngOrderItemObjs)) break;
            if ("1".equals(uocChngOrderItemObjs.get(0).getOtherChngValue())) {
                UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                uocShipOrderQryBo.setSaleOrderId(saleOrderId);
                uocShipOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
                List<UocShipOrderDo> listShipOrder = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
                if (CollectionUtil.isEmpty(listShipOrder)) {
                    throw new BaseBusinessException("100001", "\u901a\u8fc7\u9500\u552e\u5355\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u4e3a\u7a7a");
                }
                for (UocShipOrderDo uocShipOrderDo : listShipOrder) {
                    UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
                    uocOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
                    uocOrderTaskInst.setObjId(uocShipOrderDo.getShipOrderId());
                    uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                    uocOrderTaskInst.setFinishTag(0);
                    List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
                    if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                        return;
                    }
                    UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
                    String procState2 = uocOrderTaskInst1.getProcState();
                    if ("XS_YS_YS".equals(procState2)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    break;
                }
                if ((flag = (Boolean)Optional.ofNullable(flag).orElse(Boolean.FALSE)).booleanValue()) {
                    String taskId = uocSaleOrderTaskInst1.getTaskInstId();
                    UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
                    saleTaskinfo.setTaskId(taskId);
                    saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
                    saleTaskinfo.setSaleOrderId(saleOrderId);
                    saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
                    saleOrderTaskInstBoList.add(saleTaskinfo);
                }
            }
            if (!"2".equals(uocChngOrderItemObjs.get(0).getOtherChngValue()) || !"XS_DH_JS".equals(procState = uocSaleOrderTaskInst1.getProcState())) continue;
            String taskId = uocSaleOrderTaskInst1.getTaskInstId();
            UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
            saleTaskinfo.setTaskId(taskId);
            saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
            saleTaskinfo.setSaleOrderId(saleOrderId);
            saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
            saleOrderTaskInstBoList.add(saleTaskinfo);
        }
        rsp.setSaleOrderTaskInstList(saleOrderTaskInstBoList);
    }

    private void refuseState(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocShipOrderModel.modifyItemChngCountRefuse(this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocSaleOrderModel.modifyBatchItemChngCountRefuse(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private UocShipOrderDo convertShipOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
        uocShipOrderDo.setOrderIdList(orderIdList);
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        return uocShipOrderDo;
    }
}

