/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerCommonSyncSale
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerCommonSyncSale.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerCommonSyncSale->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setObjId(saleOrderId);
        ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
        saleList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        eventReqBo.setDataList(saleList);
        retList.add(eventReqBo);
        UocApprovalObjQryBo qryBo = new UocApprovalObjQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setObjId(String.valueOf(saleOrderId));
        List<UocApprovalObj> uocApprovalObjList = this.iUocAuditOrderModel.qryApprovealObj(qryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjList)) {
            uocApprovalObjList.forEach(uocApprovalObj -> {
                Long auditOrderId = uocApprovalObj.getAuditOrderId();
                this.addSyncParam(retList, orderId, auditOrderId, this.uocIndexConfig.getApprovalOrderPlusIndex());
            });
        }
        log.info("\u540c\u6b65\u9500\u552e\u5355\u63d0\u4ea4\u51fa\u53c2:{}", (Object)JSON.toJSONString(retList));
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_ES_SYNC_SALE_ORDER";
    }

    private void addSyncParam(List<IUocEsSyncQryEventReqBo> retList, Long orderId, Long objId, String indexName) {
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setObjId(objId);
        syncQryReqBo.setOrderId(orderId);
        this.addEvent(retList, syncQryReqBo, indexName);
    }

    private void addEvent(List<IUocEsSyncQryEventReqBo> retList, IUocEsSyncQryReqBo syncQryReqBo, String index) {
        ArrayList<IUocEsSyncQryReqBo> esSyncQryReqBoList = new ArrayList<IUocEsSyncQryReqBo>();
        esSyncQryReqBoList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(index);
        eventReqBo.setDataList(esSyncQryReqBoList);
        retList.add(eventReqBo);
    }
}

