/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderRspBo;
import com.tydic.dyc.oc.transactionservice.UocMsgSplitOrderTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService"})
public class UocMsgSplitOrderServiceImpl
implements UocMsgSplitOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgSplitOrderServiceImpl.class);
    @Autowired
    private UocMsgSplitOrderTransaction uocMsgSplitOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"splitOrder"})
    public UocMsgSplitOrderRspBo splitOrder(@RequestBody UocMsgSplitOrderReqBo reqBo) {
        UocMsgSplitOrderRspBo rspBo = this.uocMsgSplitOrderTransaction.splitOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocMsgSplitOrderReqBo reqBo, UocMsgSplitOrderRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        for (UocCreateOrderServiceRspSaleOrderBo uocCreateOrderServiceRspSaleOrderBo : rspBo.getSaleOrderList()) {
            SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
            saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            saleBo.setOrderId(rspBo.getOrderId());
            saleBo.setObjId(uocCreateOrderServiceRspSaleOrderBo.getSaleOrderId());
            saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleBo);
        }
        if (ObjectUtil.isNotEmpty((Object)rspBo.getShipOrderIdList())) {
            for (Long shipOrderId : rspBo.getShipOrderIdList()) {
                SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
                shipBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
                shipBo.setOrderId(rspBo.getOrderId());
                shipBo.setObjId(shipOrderId);
                shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(shipBo);
            }
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

