/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfSupplier;
import com.tydic.dyc.oc.service.order.UocOrderQuotaAllocationDealBusiService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderQuotaAllocationDealReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderQuotaAllocationDealRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.order.UocOrderQuotaAllocationDealBusiService"})
public class UocOrderQuotaAllocationDealBusiServiceImpl
implements UocOrderQuotaAllocationDealBusiService {
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"dealOrderQuotaAllocation"})
    public UocProOrderQuotaAllocationDealRspBo dealOrderQuotaAllocation(@RequestBody UocProOrderQuotaAllocationDealReqBo reqBo) {
        UocProOrderQuotaAllocationDealRspBo rsp = UocRu.success(UocProOrderQuotaAllocationDealRspBo.class);
        if (3 == reqBo.getOperateType()) {
            UocConfSupplier supplierPO = new UocConfSupplier();
            supplierPO.setSupNo(reqBo.getSupNo());
            supplierPO.setConfId(reqBo.getConfId());
            try {
                supplierPO.setOrderLimit(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuota()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u8f6c\u6362\u91d1\u989d\u6709\u8bef");
            }
            supplierPO.setOperatingTime(new Date());
            supplierPO.setOperatorId(String.valueOf(reqBo.getUserId()));
            supplierPO.setOperatorName(reqBo.getName());
            supplierPO.setLimitStatus(1);
            int i = this.iUocOrderModel.updateConfSupplierById(supplierPO);
            if (1 != i) {
                throw new BaseBusinessException("100100", "\u5220\u9664\u914d\u7f6e\u5931\u8d25");
            }
            return rsp;
        }
        if (2 == reqBo.getOperateType()) {
            UocConfSupplier uocConfSupplier = this.iUocOrderModel.getConfSupplierModelById(reqBo.getConfId());
            if (null == uocConfSupplier || 1 == uocConfSupplier.getLimitStatus()) {
                throw new BaseBusinessException("100100", "\u8be5\u4f9b\u5e94\u5546\u7684\u914d\u7f6e\u5df2\u7ecf\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002");
            }
            UocConfSupplier supplierPO = new UocConfSupplier();
            supplierPO.setSupNo(reqBo.getSupNo());
            supplierPO.setConfId(reqBo.getConfId());
            try {
                supplierPO.setOrderLimit(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuota()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u8f6c\u6362\u91d1\u989d\u6709\u8bef");
            }
            supplierPO.setOperatingTime(new Date());
            supplierPO.setOperatorId(String.valueOf(reqBo.getUserId()));
            supplierPO.setOperatorName(reqBo.getName());
            supplierPO.setLimitStatus(0);
            this.iUocOrderModel.updateConfSupplierById(supplierPO);
        } else if (1 == reqBo.getOperateType()) {
            UocConfSupplier supplierPO = new UocConfSupplier();
            supplierPO.setSupNo(reqBo.getSupNo());
            supplierPO.setBusinessTypeCode(reqBo.getBusinessTypeCode());
            UocConfSupplier supplierPO1 = this.iUocOrderModel.getConfSupplierModelBy(supplierPO);
            try {
                supplierPO.setOrderLimit(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuota()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u8f6c\u6362\u91d1\u989d\u6709\u8bef");
            }
            supplierPO.setSupName(reqBo.getSupplierName());
            supplierPO.setOperatingTime(new Date());
            supplierPO.setOperatorId(String.valueOf(reqBo.getUserId()));
            supplierPO.setOperatorName(reqBo.getName());
            supplierPO.setSysAttr("2");
            supplierPO.setLimitStatus(0);
            if (null != supplierPO1) {
                if (0 == supplierPO1.getLimitStatus()) {
                    throw new BaseBusinessException("100100", "\u8be5\u4f9b\u5e94\u5546\u7684\u914d\u7f6e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002");
                }
                supplierPO.setConfId(supplierPO1.getConfId());
                this.iUocOrderModel.updateConfSupplierById(supplierPO);
            } else {
                supplierPO.setConfId(IdUtil.nextId());
                this.iUocOrderModel.addConfSupplier(supplierPO);
            }
        }
        return rsp;
    }
}

